/*
 * Decompiled with CFR 0.152.
 */
package io.tileverse.vectortile.mvt;

import com.google.protobuf.CodedOutputStream;
import io.tileverse.vectortile.model.GeometryReader;
import io.tileverse.vectortile.model.VectorTile;
import io.tileverse.vectortile.mvt.GeometryDecoder;
import io.tileverse.vectortile.mvt.InsufficientBufferException;
import io.tileverse.vectortile.mvt.MvtTile;
import io.tileverse.vectortile.mvt.VectorTileProto;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class VectorTileCodec {
    public byte[] encode(VectorTile tile) {
        VectorTileProto.Tile proto = this.getProto(tile);
        return proto.toByteArray();
    }

    public void encode(VectorTile tile, OutputStream outputStream) throws IOException {
        VectorTileProto.Tile proto = this.getProto(tile);
        proto.writeTo(outputStream);
    }

    public void encode(VectorTile tile, ByteBuffer buffer) throws InsufficientBufferException, IOException {
        VectorTileProto.Tile proto = this.getProto(tile);
        int serializedSize = proto.getSerializedSize();
        if (buffer.remaining() < serializedSize) {
            throw new InsufficientBufferException(serializedSize, buffer.remaining());
        }
        CodedOutputStream codedOutput = CodedOutputStream.newInstance((ByteBuffer)buffer);
        proto.writeTo(codedOutput);
        codedOutput.flush();
    }

    public int getSerializedSize(VectorTile tile) {
        VectorTileProto.Tile proto = this.getProto(tile);
        return proto.getSerializedSize();
    }

    public VectorTile decode(byte[] data) throws IOException {
        return this.decode(ByteBuffer.wrap(data));
    }

    public VectorTile decode(ByteBuffer data) throws IOException {
        VectorTileProto.Tile tile = VectorTileProto.Tile.parseFrom(data);
        return new MvtTile(tile);
    }

    public VectorTile decode(InputStream data) throws IOException {
        VectorTileProto.Tile tile = VectorTileProto.Tile.parseFrom(data);
        return new MvtTile(tile);
    }

    private VectorTileProto.Tile getProto(VectorTile tile) {
        if (tile instanceof MvtTile) {
            MvtTile mvt = (MvtTile)tile;
            return mvt.tileProto();
        }
        throw new UnsupportedOperationException("Generic Tile to MVT conversion not yet implemented");
    }

    public static GeometryReader newGeometryReader() {
        return new GeometryDecoder();
    }
}

