/*
 * Decompiled with CFR 0.152.
 */
package io.tileverse.vectortile.mvt;

import io.tileverse.vectortile.model.VectorTile;
import io.tileverse.vectortile.mvt.LayerBuilder;
import io.tileverse.vectortile.mvt.MvtTile;
import io.tileverse.vectortile.mvt.VectorTileProto;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.prep.PreparedGeometry;
import org.locationtech.jts.geom.prep.PreparedGeometryFactory;

public class VectorTileBuilder {
    private final BuildParams state = new BuildParams();
    private VectorTileProto.Tile.Builder protoTileBuilder = VectorTileProto.Tile.newBuilder();

    public VectorTileBuilder init(VectorTile tile) {
        throw new UnsupportedOperationException("implement");
    }

    public VectorTileBuilder merge(VectorTile tile) {
        throw new UnsupportedOperationException("implement");
    }

    public LayerBuilder layer() {
        return new LayerBuilder(this);
    }

    public VectorTile build() {
        VectorTileProto.Tile proto = this.buildProto();
        MvtTile tile = new MvtTile(proto);
        this.protoTileBuilder.clear();
        return tile;
    }

    VectorTileProto.Tile buildProto() {
        return (VectorTileProto.Tile)this.protoTileBuilder.build();
    }

    public VectorTileBuilder setExtent(int extent) {
        this.state.setExtent(extent);
        return this;
    }

    public VectorTileBuilder setClipBuffer(int clipBuffer) {
        this.state.setClipBuffer(clipBuffer);
        return this;
    }

    public VectorTileBuilder setAutoIncrementIds(boolean autoincrementIds) {
        this.state.setAutoincrementIds(autoincrementIds);
        return this;
    }

    public VectorTileBuilder setSimplificationDistanceTolerance(double simplificationDistanceTolerance) {
        this.state.setSimplificationDistanceTolerance(simplificationDistanceTolerance);
        return this;
    }

    public VectorTileBuilder setUsePrecisionModelSnapping(boolean usePrecisionModelSnapping) {
        this.state.setUsePrecisionModelSnapping(usePrecisionModelSnapping);
        return this;
    }

    void addLayer(VectorTileProto.Tile.Layer layer) {
        if (layer != null && layer.getFeaturesCount() > 0) {
            this.protoTileBuilder.addLayers(layer);
        }
    }

    BuildParams params() {
        return this.state;
    }

    static final class BuildParams {
        private final Params params = new Params();
        private double minimumLength;
        private double minimumArea;
        private Geometry clipGeometry;
        private Envelope clipEnvelope;
        private PreparedGeometry clipGeometryPrepared;
        private long autoincrement;

        BuildParams() {
        }

        private void reset() {
            this.minimumArea = 0.0;
            this.minimumLength = 0.0;
            this.clipGeometry = null;
            this.clipEnvelope = null;
            this.clipGeometryPrepared = null;
            this.autoincrement = 0L;
        }

        public int getExtent() {
            return this.params.extent;
        }

        private void setExtent(int extent) {
            this.params.extent = extent;
            this.reset();
        }

        private void setClipBuffer(int clipBuffer) {
            this.params.clipBuffer = clipBuffer;
            this.reset();
        }

        private void setAutoincrementIds(boolean autoincrementIds) {
            this.params.autoincrementIds = autoincrementIds;
            this.reset();
        }

        private void setSimplificationDistanceTolerance(double simplificationDistanceTolerance) {
            this.params.simplificationDistanceTolerance = simplificationDistanceTolerance;
            this.reset();
        }

        private void setUsePrecisionModelSnapping(boolean usePrecisionModelSnapping) {
            this.params.usePrecisionModelSnapping = usePrecisionModelSnapping;
            this.reset();
        }

        public long getNextFeatureId() {
            long l;
            if (this.params.autoincrementIds) {
                long l2 = this.autoincrement;
                l = l2;
                this.autoincrement = l2 + 1L;
            } else {
                l = -1L;
            }
            return l;
        }

        public double getMinimumLength() {
            return this.minimumLength;
        }

        public double getMinimumArea() {
            return this.minimumArea;
        }

        public double getSimplificationDistanceTolerance() {
            return this.params.simplificationDistanceTolerance;
        }

        public boolean isUsePrecisionModelSnapping() {
            return this.params.usePrecisionModelSnapping;
        }

        public Geometry getClipGeometry() {
            this.ensureClipGeometry();
            return this.clipGeometry;
        }

        public Envelope getClipEnvelope() {
            this.ensureClipGeometry();
            return this.clipEnvelope;
        }

        public PreparedGeometry getClipGeometryPrepared() {
            this.ensureClipGeometry();
            return this.clipGeometryPrepared;
        }

        private void ensureClipGeometry() {
            if (this.clipGeometry == null) {
                this.clipGeometry = this.createTileEnvelope();
                this.clipEnvelope = this.clipGeometry.getEnvelopeInternal();
                this.clipGeometryPrepared = PreparedGeometryFactory.prepare((Geometry)this.clipGeometry);
            }
        }

        private Geometry createTileEnvelope() {
            Coordinate[] coords;
            int buffer = this.params.clipBuffer;
            int size = this.params.extent;
            coords = new Coordinate[]{new Coordinate((double)(0 - buffer), (double)(size + buffer)), new Coordinate((double)(size + buffer), (double)(size + buffer)), new Coordinate((double)(size + buffer), (double)(0 - buffer)), new Coordinate((double)(0 - buffer), (double)(0 - buffer)), coords[0]};
            return new GeometryFactory().createPolygon(coords);
        }
    }

    private static final class Params {
        private int extent = 4096;
        private int clipBuffer = 32;
        private boolean autoincrementIds = true;
        private double simplificationDistanceTolerance = -1.0;
        private boolean usePrecisionModelSnapping = false;

        private Params() {
        }
    }
}

