/*
 * Decompiled with CFR 0.152.
 */
package io.tileverse.vectortile.mvt;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequenceFactory;
import org.locationtech.jts.geom.Envelope;

final class SubCoordinateSequence
implements CoordinateSequence {
    private final CoordinateSequence delegate;
    private final int start;
    private final int length;
    private final CoordinateSequenceFactory fac;

    public SubCoordinateSequence(CoordinateSequence delegate, int start, int length, CoordinateSequenceFactory fac) {
        this.fac = fac;
        if (delegate == null) {
            throw new IllegalArgumentException("Delegate coordinate sequence cannot be null");
        }
        if (start < 0) {
            throw new IllegalArgumentException("Start index cannot be negative: " + start);
        }
        if (length < 0) {
            throw new IllegalArgumentException("Length cannot be negative: " + length);
        }
        if (start + length > delegate.size()) {
            throw new IllegalArgumentException("Start + lenght (" + (start + length) + ") cannot be greater than delegate's size: " + delegate.size());
        }
        this.delegate = delegate;
        this.start = start;
        this.length = length;
    }

    public int size() {
        return this.length;
    }

    public int getDimension() {
        return this.delegate.getDimension();
    }

    public Coordinate getCoordinate(int pos) {
        this.checkBounds(pos);
        int realPos = this.start + pos;
        Coordinate c = this.delegate.createCoordinate();
        c.setX(this.delegate.getOrdinate(realPos, 0));
        c.setY(this.delegate.getOrdinate(realPos, 1));
        return c;
    }

    private final void checkBounds(int pos) {
        if (pos < 0 || pos >= this.length) {
            throw new IndexOutOfBoundsException("Position " + pos + " is out of bounds [0, " + this.length + ")");
        }
    }

    public Coordinate getCoordinateCopy(int pos) {
        this.checkBounds(pos);
        return this.delegate.getCoordinateCopy(this.start + pos);
    }

    public void getCoordinate(int pos, Coordinate coord) {
        this.checkBounds(pos);
        this.delegate.getCoordinate(this.start + pos, coord);
    }

    public double getX(int pos) {
        this.checkBounds(pos);
        return this.delegate.getX(this.start + pos);
    }

    public double getY(int pos) {
        this.checkBounds(pos);
        return this.delegate.getY(this.start + pos);
    }

    public double getZ(int pos) {
        this.checkBounds(pos);
        return this.delegate.getZ(this.start + pos);
    }

    public double getM(int pos) {
        this.checkBounds(pos);
        return this.delegate.getM(this.start + pos);
    }

    public double getOrdinate(int pos, int ordinateIndex) {
        this.checkBounds(pos);
        return this.delegate.getOrdinate(this.start + pos, ordinateIndex);
    }

    public void setOrdinate(int index, int ordinateIndex, double value) {
        this.checkBounds(index);
        this.delegate.setOrdinate(this.start + index, ordinateIndex, value);
    }

    public Coordinate[] toCoordinateArray() {
        Coordinate[] coords = new Coordinate[this.length];
        for (int i = 0; i < this.length; ++i) {
            coords[i] = this.getCoordinate(i);
        }
        return coords;
    }

    public Envelope expandEnvelope(Envelope env) {
        for (int i = 0; i < this.length; ++i) {
            env.expandToInclude(this.getX(i), this.getY(i));
        }
        return env;
    }

    public CoordinateSequence copy() {
        CoordinateSequence copy = this.fac.create(this.length, 2);
        int i = 0;
        int d = this.start;
        while (i < this.length) {
            copy.setOrdinate(i, 0, this.delegate.getOrdinate(d, 0));
            copy.setOrdinate(i, 1, this.delegate.getOrdinate(d, 1));
            ++i;
            ++d;
        }
        return copy;
    }

    @Deprecated
    public Object clone() {
        throw new UnsupportedOperationException();
    }
}

