/*
 * Decompiled with CFR 0.152.
 */
package io.tileverse.vectortile.mvt;

import io.tileverse.vectortile.model.VectorTile;
import io.tileverse.vectortile.mvt.MvtLayer;
import io.tileverse.vectortile.mvt.VectorTileProto;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.locationtech.jts.geom.Envelope;

record MvtTile(VectorTileProto.Tile tileProto, Envelope bounds) implements VectorTile
{
    MvtTile(VectorTileProto.Tile tileProto) {
        this(tileProto, null);
    }

    @Override
    public Optional<Envelope> boundingBox() {
        return Optional.ofNullable(this.bounds);
    }

    @Override
    public VectorTile withBoundingBox(Envelope bounds) {
        return new MvtTile(this.tileProto, bounds);
    }

    @Override
    public Set<String> getLayerNames() {
        return this.layers().keySet();
    }

    @Override
    public List<VectorTile.Layer> getLayers() {
        return this.layers().values().stream().map(this::newLayer).toList();
    }

    @Override
    public Optional<VectorTile.Layer> getLayer(String name) {
        return this.tileProto.getLayersList().stream().filter(l -> name.equals(l.getName())).findFirst().map(this::newLayer);
    }

    private Map<String, VectorTileProto.Tile.Layer> layers() {
        return this.tileProto.getLayersList().stream().collect(Collectors.toMap(VectorTileProto.Tile.Layer::getName, Function.identity()));
    }

    private VectorTile.Layer newLayer(VectorTileProto.Tile.Layer layer) {
        return new MvtLayer(this, layer);
    }

    public int getSerializedSize() {
        return this.tileProto.getSerializedSize();
    }

    @Override
    public String toString() {
        return "%s[%s]".formatted(this.getClass().getSimpleName(), this.getLayers());
    }
}

