/*
 * Decompiled with CFR 0.152.
 */
package io.tileverse.vectortile.mvt;

import io.tileverse.vectortile.model.GeometryReader;
import io.tileverse.vectortile.model.VectorTile;
import io.tileverse.vectortile.mvt.GeometryDecoder;
import io.tileverse.vectortile.mvt.MvtFeature;
import io.tileverse.vectortile.mvt.MvtTile;
import io.tileverse.vectortile.mvt.VectorTileProto;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;

record MvtLayer(MvtTile tile, VectorTileProto.Tile.Layer layerProto) implements VectorTile.Layer
{
    @Override
    public VectorTile getTile() {
        return this.tile;
    }

    @Override
    public String getName() {
        return this.layerProto.getName();
    }

    @Override
    public int getExtent() {
        if (!this.layerProto.hasExtent()) {
            return 4096;
        }
        return this.layerProto.getExtent();
    }

    @Override
    public Set<String> getAttributeNames() {
        return Set.copyOf(this.layerProto.getKeysList());
    }

    @Override
    public int count() {
        return this.layerProto.getFeaturesCount();
    }

    @Override
    public Stream<VectorTile.Layer.Feature> getFeatures() {
        return this.getFeatures(f -> true);
    }

    @Override
    public Stream<VectorTile.Layer.Feature> getFeatures(Predicate<VectorTile.Layer.Feature> filter) {
        return this.getFeatures(filter, new GeometryDecoder());
    }

    @Override
    public Stream<VectorTile.Layer.Feature> getFeatures(Predicate<VectorTile.Layer.Feature> filter, GeometryReader decoder) {
        Objects.requireNonNull(filter, "filter");
        Objects.requireNonNull(decoder, "decoder");
        return this.layerProto.getFeaturesList().stream().map(f -> this.createFeature((VectorTileProto.Tile.Feature)f, decoder)).filter(filter);
    }

    private VectorTile.Layer.Feature createFeature(VectorTileProto.Tile.Feature feature, GeometryReader decoder) {
        return new MvtFeature(this, feature, decoder);
    }

    @Override
    public String toString() {
        return "%s[name=%s, extent=%d, features=%d]".formatted(this.getClass().getSimpleName(), this.getName(), this.getExtent(), this.count());
    }
}

