/*
 * Decompiled with CFR 0.152.
 */
package io.tileverse.vectortile.mvt;

import io.tileverse.vectortile.model.GeometryReader;
import io.tileverse.vectortile.model.VectorTile;
import io.tileverse.vectortile.mvt.GeometryDecoder;
import io.tileverse.vectortile.mvt.MvtLayer;
import io.tileverse.vectortile.mvt.VectorTileProto;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.locationtech.jts.geom.Geometry;

final class MvtFeature
implements VectorTile.Layer.Feature {
    final MvtLayer layer;
    final VectorTileProto.Tile.Feature featureProto;
    final GeometryReader decoder;
    private Map<String, Object> valueIndex;
    private Geometry geometry;

    MvtFeature(MvtLayer layer, VectorTileProto.Tile.Feature feature, GeometryReader decoder) {
        this.layer = Objects.requireNonNull(layer, "layer");
        this.featureProto = Objects.requireNonNull(feature, "feature");
        this.decoder = Objects.requireNonNull(decoder);
    }

    @Override
    public long getId() {
        return this.featureProto.getId();
    }

    @Override
    public VectorTile.Layer getLayer() {
        return this.layer;
    }

    @Override
    public Geometry getGeometry() {
        if (this.geometry == null) {
            this.geometry = this.decoder.decode(this);
        }
        return this.geometry;
    }

    @Override
    public Object getAttribute(String attributeName) {
        return this.getAttributes().getOrDefault(attributeName, null);
    }

    @Override
    public Map<String, Object> getAttributes() {
        if (this.valueIndex == null) {
            this.valueIndex = this.buildValues();
        }
        return this.valueIndex;
    }

    public String toString() {
        return this.featureProto.getType().toString() + GeometryDecoder.toString(this.featureProto.getGeometryList()) + " (id: " + this.getId() + ")";
    }

    private Map<String, Object> buildValues() {
        HashMap<String, Object> values = new HashMap<String, Object>();
        VectorTileProto.Tile.Layer tileLayer = this.layer.layerProto();
        List<Integer> tags = this.featureProto.getTagsList();
        for (int i = 0; i < tags.size(); i += 2) {
            int keyTag = tags.get(i);
            int valueTag = tags.get(i + 1);
            String attName = tileLayer.getKeys(keyTag);
            VectorTileProto.Tile.Value value = tileLayer.getValues(valueTag);
            values.put(attName, this.parseValue(value));
        }
        return values;
    }

    private Object parseValue(VectorTileProto.Tile.Value value) {
        if (value.hasBoolValue()) {
            return value.getBoolValue();
        }
        if (value.hasDoubleValue()) {
            return value.getDoubleValue();
        }
        if (value.hasFloatValue()) {
            return Float.valueOf(value.getFloatValue());
        }
        if (value.hasIntValue()) {
            return value.getIntValue();
        }
        if (value.hasSintValue()) {
            return value.getSintValue();
        }
        if (value.hasUintValue()) {
            return value.getUintValue();
        }
        if (value.hasStringValue()) {
            return value.getStringValue();
        }
        return null;
    }
}

