/*
 * Decompiled with CFR 0.152.
 */
package io.tileverse.vectortile.mvt;

import io.tileverse.vectortile.mvt.FeatureBuilder;
import io.tileverse.vectortile.mvt.VectorTileBuilder;
import io.tileverse.vectortile.mvt.VectorTileProto;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.locationtech.jts.geom.Geometry;

public class LayerBuilder {
    final VectorTileBuilder vectorTileBuilder;
    private String layerName;
    private final Map<String, Integer> keys = new LinkedHashMap<String, Integer>();
    private final Map<Object, Integer> values = new LinkedHashMap<Object, Integer>();
    private final List<VectorTileProto.Tile.Feature> features = new ArrayList<VectorTileProto.Tile.Feature>();
    private final FeatureBuilder reusableFeatureBuilder;

    LayerBuilder(VectorTileBuilder vectorTileBuilder) {
        this.vectorTileBuilder = vectorTileBuilder;
        this.reusableFeatureBuilder = new FeatureBuilder(this);
    }

    public LayerBuilder name(String layerName) {
        this.layerName = layerName;
        return this;
    }

    public FeatureBuilder feature() {
        return this.reusableFeatureBuilder.reset(this.params().getNextFeatureId());
    }

    public LayerBuilder feature(Map<String, Object> properties, Geometry geom) {
        FeatureBuilder fb = this.feature();
        return fb.attributes(properties).geometry(geom).build();
    }

    public LayerBuilder feature(Map<String, Object> properties, Geometry geom, long id) {
        FeatureBuilder fb = this.feature();
        return fb.id(id).attributes(properties).geometry(geom).build();
    }

    public VectorTileBuilder build() {
        VectorTileProto.Tile.Layer builtLayer = this.buildLayer();
        this.vectorTileBuilder.addLayer(builtLayer);
        return this.vectorTileBuilder;
    }

    Integer getKeyIndex(String key) {
        Integer index = this.keys.get(key);
        if (index == null) {
            index = this.keys.size();
            this.keys.put(key, index);
        }
        return index;
    }

    Integer getValueIndex(Object value) {
        Integer index = this.values.get(value);
        if (index == null) {
            index = this.values.size();
            this.values.put(value, index);
        }
        return index;
    }

    void addFeature(VectorTileProto.Tile.Feature feature) {
        if (feature != null) {
            this.features.add(feature);
        }
    }

    private VectorTileProto.Tile.Layer buildLayer() {
        if (this.layerName == null || this.layerName.isEmpty()) {
            throw new IllegalStateException("Layer name must be set");
        }
        if (this.features.isEmpty()) {
            return null;
        }
        VectorTileProto.Tile.Layer.Builder layerBuilder = VectorTileProto.Tile.Layer.newBuilder();
        layerBuilder.setVersion(2);
        layerBuilder.setName(this.layerName);
        layerBuilder.setExtent(this.params().getExtent());
        for (String key : this.keys.keySet()) {
            layerBuilder.addKeys(key);
        }
        for (Object value : this.values.keySet()) {
            VectorTileProto.Tile.Value.Builder valueBuilder = VectorTileProto.Tile.Value.newBuilder();
            this.encodeValue(value, valueBuilder);
            VectorTileProto.Tile.Value encodedValue = (VectorTileProto.Tile.Value)valueBuilder.build();
            layerBuilder.addValues(encodedValue);
        }
        for (VectorTileProto.Tile.Feature feature : this.features) {
            layerBuilder.addFeatures(feature);
        }
        return (VectorTileProto.Tile.Layer)layerBuilder.build();
    }

    private void encodeValue(Object value, VectorTileProto.Tile.Value.Builder valueBuilder) {
        if (value instanceof String) {
            String string = (String)value;
            valueBuilder.setStringValue(string);
        } else if (value instanceof Integer) {
            Integer integer = (Integer)value;
            valueBuilder.setSintValue(integer.intValue());
        } else if (value instanceof Long) {
            Long long1 = (Long)value;
            valueBuilder.setSintValue(long1);
        } else if (value instanceof Float) {
            Float float1 = (Float)value;
            valueBuilder.setFloatValue(float1.floatValue());
        } else if (value instanceof Double) {
            Double double1 = (Double)value;
            valueBuilder.setDoubleValue(double1);
        } else if (value instanceof BigDecimal) {
            valueBuilder.setStringValue(value.toString());
        } else if (value instanceof Number) {
            Number number = (Number)value;
            valueBuilder.setDoubleValue(number.doubleValue());
        } else if (value instanceof Boolean) {
            Boolean boolean1 = (Boolean)value;
            valueBuilder.setBoolValue(boolean1);
        } else {
            valueBuilder.setStringValue(value.toString());
        }
    }

    VectorTileBuilder.BuildParams params() {
        return this.vectorTileBuilder.params();
    }
}

