/*
 * Decompiled with CFR 0.152.
 */
package io.tileverse.vectortile.mvt;

import com.google.protobuf.CodedOutputStream;
import io.tileverse.vectortile.mvt.GeometryCommand;
import io.tileverse.vectortile.mvt.VectorTileBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.IntConsumer;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequenceFilter;
import org.locationtech.jts.geom.CoordinateXY;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryComponentFilter;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Lineal;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygonal;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.geom.Puntal;
import org.locationtech.jts.geom.TopologyException;
import org.locationtech.jts.geom.prep.PreparedGeometry;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;
import org.locationtech.jts.precision.GeometryPrecisionReducer;
import org.locationtech.jts.simplify.DouglasPeuckerSimplifier;
import org.locationtech.jts.simplify.TopologyPreservingSimplifier;

class GeometryEncoder {
    private final VectorTileBuilder.BuildParams params;
    private static final GeometryPrecisionReducer precisionReducer;

    GeometryEncoder(VectorTileBuilder.BuildParams buildParams) {
        this.params = buildParams;
    }

    public List<Geometry> prepareGeometries(Geometry input) {
        Geometry geometry = input;
        if (geometry instanceof Polygonal && geometry.getArea() < this.params.getMinimumArea()) {
            return List.of();
        }
        if (geometry instanceof Lineal && geometry.getLength() < this.params.getMinimumLength()) {
            return List.of();
        }
        if (GeometryEncoder.isGenericGeometryCollection(geometry)) {
            return this.prepareSubGeometries((GeometryCollection)geometry);
        }
        if ((geometry = this.simplify(geometry)) == null || geometry.isEmpty()) {
            return List.of();
        }
        if (geometry instanceof Point) {
            if (!this.clipCovers(geometry)) {
                return List.of();
            }
        } else {
            geometry = this.clipGeometry(geometry);
        }
        if (geometry == null || geometry.isEmpty()) {
            return List.of();
        }
        if (GeometryEncoder.isGenericGeometryCollection(geometry)) {
            return this.prepareSubGeometries((GeometryCollection)geometry);
        }
        if ((geometry = this.applyPrecisionModelSnapping(geometry)) == null) {
            return List.of();
        }
        return List.of(geometry);
    }

    public List<Integer> commands(Geometry preparedGeometry) {
        return this.pack(preparedGeometry);
    }

    private Geometry simplify(Geometry geometry) {
        double simplificationDistance = this.params.getSimplificationDistanceTolerance();
        if (simplificationDistance <= 0.0 || geometry instanceof Point) {
            return geometry;
        }
        Geometry simplified = geometry;
        if (geometry instanceof Lineal) {
            simplified = DouglasPeuckerSimplifier.simplify((Geometry)geometry, (double)simplificationDistance);
        } else if (geometry instanceof Polygonal) {
            simplified = DouglasPeuckerSimplifier.simplify((Geometry)geometry, (double)simplificationDistance);
            if (!(simplified instanceof Polygonal)) {
                simplified = TopologyPreservingSimplifier.simplify((Geometry)geometry, (double)simplificationDistance);
            }
        } else {
            simplified = TopologyPreservingSimplifier.simplify((Geometry)geometry, (double)simplificationDistance);
        }
        if (!simplified.isValid()) {
            simplified = DouglasPeuckerSimplifier.simplify((Geometry)geometry, (double)(simplificationDistance * 2.0));
        }
        return simplified;
    }

    private Geometry applyPrecisionModelSnapping(Geometry geometry) {
        try {
            Geometry preciseGeometry = precisionReducer.reduce(geometry);
            if (this.isValidForEncoding(preciseGeometry)) {
                return preciseGeometry;
            }
        }
        catch (IllegalArgumentException invalidGeom) {
            return null;
        }
        return null;
    }

    private boolean isValidForEncoding(Geometry geometry) {
        int minPoints;
        if (geometry == null || geometry.isEmpty() || geometry.getNumPoints() == 0) {
            return false;
        }
        if (geometry instanceof Puntal) {
            minPoints = 1;
        } else if (geometry instanceof Lineal) {
            minPoints = 2;
        } else if (geometry instanceof Polygonal) {
            minPoints = 4;
        } else {
            return false;
        }
        return geometry.getNumPoints() >= minPoints;
    }

    private List<Geometry> prepareSubGeometries(GeometryCollection geometry) {
        int numGeometries = geometry.getNumGeometries();
        ArrayList<Geometry> prepared = new ArrayList<Geometry>(numGeometries);
        for (int i = 0; i < numGeometries; ++i) {
            Geometry subGeometry = geometry.getGeometryN(i);
            prepared.addAll(this.prepareGeometries(subGeometry));
        }
        return prepared;
    }

    private static boolean isGenericGeometryCollection(Geometry g) {
        return g instanceof GeometryCollection && !(g instanceof Puntal) && !(g instanceof Lineal) && !(g instanceof Polygonal);
    }

    protected boolean clipCovers(Geometry geom) {
        Envelope clipEnvelope = this.params.getClipEnvelope();
        if (geom instanceof Point) {
            Point p = (Point)geom;
            return clipEnvelope.covers(p.getX(), p.getY());
        }
        return clipEnvelope.covers(geom.getEnvelopeInternal());
    }

    protected Geometry clipGeometry(Geometry geometry) {
        Envelope clipEnvelope = this.params.getClipEnvelope();
        try {
            if (clipEnvelope.contains(geometry.getEnvelopeInternal())) {
                return geometry;
            }
            Geometry clipGeometry = this.params.getClipGeometry();
            PreparedGeometry clipGeometryPrepared = this.params.getClipGeometryPrepared();
            Geometry original = geometry;
            if ((geometry = clipGeometry.intersection(original)).isEmpty() && clipGeometryPrepared.intersects(original)) {
                Geometry originalViaWkt = new WKTReader().read(original.toText());
                geometry = clipGeometry.intersection(originalViaWkt);
            }
            return geometry;
        }
        catch (TopologyException e) {
            return geometry;
        }
        catch (ParseException e1) {
            return geometry;
        }
    }

    private List<Integer> pack(Geometry geometry) {
        ArrayList<Integer> commands = new ArrayList<Integer>(geometry.getNumPoints());
        IntConsumer sink = commands::add;
        GeometryPacker.pack(geometry, sink);
        return commands;
    }

    static {
        PrecisionModel integerPrecision = new PrecisionModel(1.0);
        precisionReducer = new GeometryPrecisionReducer(integerPrecision);
        precisionReducer.setRemoveCollapsedComponents(true);
    }

    private record GeometryPacker(CoordinateCursor cursor, IntConsumer commandsSink) implements GeometryComponentFilter,
    CoordinateSequenceFilter
    {
        public static void pack(Geometry geom, IntConsumer commandSink) {
            GeometryPacker.checkPreconditions(geom);
            CoordinateCursor cursor = new CoordinateCursor();
            cursor.processingMultiPoint = geom instanceof MultiPoint;
            geom.apply((GeometryComponentFilter)new GeometryPacker(cursor, commandSink));
            cursor.processingMultiPoint = false;
        }

        private static void checkPreconditions(Geometry geom) {
            if (GeometryEncoder.isGenericGeometryCollection(geom)) {
                throw new IllegalArgumentException("Generic GeometryCollections should have been filtered out by prepareGeometries(), got " + String.valueOf(geom));
            }
            if (geom.isEmpty()) {
                throw new IllegalArgumentException("Empty Geometry should have been filtered out by prepareGeometries(), got " + String.valueOf(geom));
            }
        }

        public void filter(Geometry geom) {
            switch (geom.getDimension()) {
                case 0: {
                    this.encodePuntal((Puntal)geom);
                    break;
                }
                case 1: {
                    this.encodeLineal((Lineal)geom);
                    break;
                }
            }
        }

        public void filter(CoordinateSequence sequence, int coordIndex) {
            if (coordIndex >= this.cursor.startAtIndex && coordIndex <= this.cursor.stopAtIndex) {
                double x = sequence.getOrdinate(coordIndex, 0);
                double y = sequence.getOrdinate(coordIndex, 1);
                this.coordinate(x, y);
            }
        }

        private void encodePuntal(Puntal puntal) {
            if (puntal instanceof Point) {
                Point point = (Point)puntal;
                if (!this.cursor.processingMultiPoint) {
                    this.moveTo(1);
                }
                this.coordinate(point.getX(), point.getY());
            } else if (puntal instanceof MultiPoint) {
                MultiPoint mp = (MultiPoint)puntal;
                this.moveTo(mp.getNumGeometries());
            }
        }

        private void encodeLineal(Lineal geom) {
            if (geom instanceof LineString) {
                LineString line = (LineString)geom;
                this.cursor.startAtIndex = 1;
                int coordCount = line.getNumPoints();
                if (geom instanceof LinearRing) {
                    this.cursor.stopAtIndex = --coordCount - 1;
                }
                this.moveTo(1);
                Point start = line.getPointN(0);
                this.coordinate(start.getX(), start.getY());
                this.lineTo(coordCount - 1);
                line.apply((CoordinateSequenceFilter)this);
                this.cursor.startAtIndex = -1;
                this.cursor.stopAtIndex = Integer.MAX_VALUE;
                if (geom instanceof LinearRing) {
                    this.closePath();
                }
            }
        }

        private void moveTo(int count) {
            this.commandsSink.accept(GeometryCommand.packCommandAndLength(1, count));
        }

        private void lineTo(int count) {
            this.commandsSink.accept(GeometryCommand.packCommandAndLength(2, count));
        }

        private void closePath() {
            this.commandsSink.accept(GeometryCommand.packCommandAndLength(7, 1));
        }

        private void coordinate(double x, double y) {
            int dx = (int)Math.round(x - this.cursor.getX());
            int dy = (int)Math.round(y - this.cursor.getY());
            this.commandsSink.accept(CodedOutputStream.encodeZigZag32((int)dx));
            this.commandsSink.accept(CodedOutputStream.encodeZigZag32((int)dy));
            this.cursor.setX(x);
            this.cursor.setY(y);
        }

        public boolean isDone() {
            return false;
        }

        public boolean isGeometryChanged() {
            return false;
        }

        private static final class CoordinateCursor
        extends CoordinateXY {
            public int startAtIndex = -1;
            public int stopAtIndex = Integer.MAX_VALUE;
            public boolean processingMultiPoint = false;

            private CoordinateCursor() {
            }
        }
    }
}

