/*
 * Decompiled with CFR 0.152.
 */
package io.tileverse.vectortile.mvt;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.Internal;
import io.tileverse.vectortile.model.GeometryReader;
import io.tileverse.vectortile.model.VectorTile;
import io.tileverse.vectortile.mvt.GeometryCommand;
import io.tileverse.vectortile.mvt.MvtFeature;
import io.tileverse.vectortile.mvt.SubCoordinateSequence;
import io.tileverse.vectortile.mvt.VectorTileProto;
import java.util.ArrayList;
import java.util.List;
import java.util.function.UnaryOperator;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequenceFactory;
import org.locationtech.jts.geom.CoordinateSequenceFilter;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.impl.PackedCoordinateSequenceFactory;
import org.locationtech.jts.geom.util.AffineTransformation;

record GeometryDecoder(GeometryFactory gf, UnaryOperator<Geometry> transform) implements GeometryReader
{
    public static final GeometryFactory DEFAULT_GEOMETRY_FACTORY = new GeometryFactory((CoordinateSequenceFactory)new PackedCoordinateSequenceFactory());

    public GeometryDecoder() {
        this(DEFAULT_GEOMETRY_FACTORY, UnaryOperator.identity());
    }

    public GeometryReader withExtentScaling(int fromExtent, int toExtent) {
        double scaleFactor = (double)toExtent / (double)fromExtent;
        AffineTransformation scaleInstance = AffineTransformation.scaleInstance((double)scaleFactor, (double)scaleFactor);
        return this.withAffineTransformation(scaleInstance);
    }

    @Override
    public GeometryReader withGeometryFactory(GeometryFactory geometryFactory) {
        return new GeometryDecoder(geometryFactory, this.transform());
    }

    @Override
    public GeometryReader withGeometryTransformation(UnaryOperator<Geometry> transform) {
        return new GeometryDecoder(this.gf(), transform);
    }

    public GeometryReader withAffineTransformation(AffineTransformation transform) {
        return this.withGeometryTransformation(GeometryReader.toFunction((CoordinateSequenceFilter)transform));
    }

    @Override
    public Geometry decode(VectorTile.Layer.Feature feature) {
        return this.decode(((MvtFeature)feature).featureProto);
    }

    public Geometry decode(VectorTileProto.Tile.Feature feature) {
        return this.decode(feature, this.gf());
    }

    public Geometry decode(VectorTileProto.Tile.Feature feature, GeometryFactory gf) {
        ArrayList<Part> parts = new ArrayList<Part>(feature.getGeometryCount() / 3);
        CoordinateSequence allCoords = this.extractAllCoordinates(feature, parts, gf);
        VectorTileProto.Tile.GeomType type = feature.getType();
        GeometryCollection decoded = switch (type) {
            case VectorTileProto.Tile.GeomType.POINT -> this.decodePoint(allCoords, gf);
            case VectorTileProto.Tile.GeomType.LINESTRING -> this.decodeLineString(parts, allCoords, gf);
            case VectorTileProto.Tile.GeomType.POLYGON -> this.decodePolygon(parts, allCoords, gf);
            default -> gf.createGeometryCollection();
        };
        return (Geometry)this.transform.apply((Geometry)decoded);
    }

    private CoordinateSequence extractAllCoordinates(VectorTileProto.Tile.Feature feature, List<Part> parts, GeometryFactory gf) {
        VectorTileProto.Tile.GeomType geomType = feature.getType();
        Internal.IntList commands = (Internal.IntList)feature.getGeometryList();
        int cmdCount = commands.size();
        int maxPossibleSize = GeometryDecoder.calculateCoordinateCount(commands);
        CoordinateSequence allCoords = gf.getCoordinateSequenceFactory().create(maxPossibleSize, 2);
        int coordIndex = 0;
        int cursorX = 0;
        int cursorY = 0;
        int partStartX = 0;
        int partStartY = 0;
        Orientation firstRingOrientation = null;
        int cmdIndex = 0;
        while (cmdIndex < cmdCount) {
            int nextCmd;
            int nextCommand;
            int cmd = commands.getInt(cmdIndex++);
            int command = GeometryCommand.extractCommand(cmd);
            int count = GeometryCommand.extractCount(cmd);
            if (command != 1) {
                throw new IllegalArgumentException("Geometry part must start with MoveTo");
            }
            int partStart = coordIndex;
            for (int k = 0; k < count; ++k) {
                int dx = CodedInputStream.decodeZigZag32((int)commands.getInt(cmdIndex++));
                int dy = CodedInputStream.decodeZigZag32((int)commands.getInt(cmdIndex++));
                partStartX = cursorX += dx;
                partStartY = cursorY += dy;
                allCoords.setOrdinate(coordIndex, 0, (double)cursorX);
                allCoords.setOrdinate(coordIndex, 1, (double)cursorY);
                ++coordIndex;
            }
            while (cmdIndex < cmdCount && (nextCommand = GeometryCommand.extractCommand(nextCmd = commands.getInt(cmdIndex))) != 1) {
                if (nextCommand == 2) {
                    int nextCount = GeometryCommand.extractCount(nextCmd);
                    ++cmdIndex;
                    for (int k = 0; k < nextCount; ++k) {
                        int dx = CodedInputStream.decodeZigZag32((int)commands.getInt(cmdIndex++));
                        int dy = CodedInputStream.decodeZigZag32((int)commands.getInt(cmdIndex++));
                        allCoords.setOrdinate(coordIndex, 0, (double)(cursorX += dx));
                        allCoords.setOrdinate(coordIndex, 1, (double)(cursorY += dy));
                        ++coordIndex;
                    }
                    continue;
                }
                if (nextCommand == 7) {
                    ++cmdIndex;
                    allCoords.setOrdinate(coordIndex, 0, (double)partStartX);
                    allCoords.setOrdinate(coordIndex, 1, (double)partStartY);
                    ++coordIndex;
                    continue;
                }
                throw new IllegalArgumentException("Invalid command: " + nextCommand);
            }
            int partLength = coordIndex - partStart;
            if (geomType == VectorTileProto.Tile.GeomType.POLYGON) {
                Orientation orientation = GeometryDecoder.areaOfRingSigned(allCoords, partStart, partLength);
                if (orientation == Orientation.DEGENERATE) continue;
                if (firstRingOrientation == null) {
                    firstRingOrientation = orientation;
                }
                parts.add(new Part(partStart, partLength, orientation));
                continue;
            }
            if (geomType != VectorTileProto.Tile.GeomType.LINESTRING || partLength < 2) continue;
            parts.add(new Part(partStart, partLength, Orientation.DEGENERATE));
        }
        if (geomType == VectorTileProto.Tile.GeomType.POINT && coordIndex > 0) {
            parts.add(new Part(0, coordIndex, Orientation.DEGENERATE));
        }
        if (coordIndex == maxPossibleSize) {
            return allCoords;
        }
        return new SubCoordinateSequence(allCoords, 0, coordIndex, gf.getCoordinateSequenceFactory());
    }

    private Geometry decodePoint(CoordinateSequence coords, GeometryFactory gf) {
        return switch (coords.size()) {
            case 0 -> gf.createPoint();
            case 1 -> gf.createPoint(coords);
            default -> gf.createMultiPoint(coords);
        };
    }

    private Geometry decodeLineString(List<Part> parts, CoordinateSequence allCoords, GeometryFactory gf) {
        return switch (parts.size()) {
            case 0 -> gf.createLineString();
            case 1 -> gf.createLineString(allCoords);
            default -> this.createMultiLineString(parts, allCoords, gf);
        };
    }

    private Geometry decodePolygon(List<Part> parts, CoordinateSequence allCoords, GeometryFactory gf) {
        return switch (parts.size()) {
            case 0 -> gf.createPolygon();
            case 1 -> gf.createPolygon(allCoords);
            default -> this.buildComplexPolygon(parts, allCoords, gf);
        };
    }

    private Geometry createMultiLineString(List<Part> parts, CoordinateSequence allCoords, GeometryFactory gf) {
        LineString[] lines = (LineString[])parts.stream().map(p -> this.createSubSequence((Part)p, allCoords, gf)).map(arg_0 -> ((GeometryFactory)gf).createLineString(arg_0)).toArray(LineString[]::new);
        return gf.createMultiLineString(lines);
    }

    private Geometry buildComplexPolygon(List<Part> parts, CoordinateSequence allCoords, GeometryFactory gf) {
        int partCount = parts.size();
        LinearRing[] allRings = new LinearRing[partCount];
        Orientation firstRingOrientation = parts.get(0).orientation();
        for (int partIndex = 0; partIndex < partCount; ++partIndex) {
            CoordinateSequence ringSeq = this.createSubSequence(parts.get(partIndex), allCoords, gf);
            allRings[partIndex] = gf.createLinearRing(ringSeq);
        }
        Polygon[] polygonArray = new Polygon[partCount];
        int polygonCount = 0;
        int currentPolygonStart = 0;
        for (int i = 1; i <= partCount; ++i) {
            boolean isEndOfPolygon;
            boolean bl = isEndOfPolygon = i == partCount;
            if (!isEndOfPolygon) {
                boolean isExteriorRing;
                isEndOfPolygon = isExteriorRing = parts.get(i).orientation() == firstRingOrientation;
            }
            if (!isEndOfPolygon) continue;
            LinearRing shell = allRings[currentPolygonStart];
            int holeCount = i - currentPolygonStart - 1;
            if (holeCount == 0) {
                polygonArray[polygonCount++] = gf.createPolygon(shell);
            } else if (holeCount == 1) {
                polygonArray[polygonCount++] = gf.createPolygon(shell, new LinearRing[]{allRings[currentPolygonStart + 1]});
            } else {
                LinearRing[] holes = new LinearRing[holeCount];
                System.arraycopy(allRings, currentPolygonStart + 1, holes, 0, holeCount);
                polygonArray[polygonCount++] = gf.createPolygon(shell, holes);
            }
            currentPolygonStart = i;
        }
        if (polygonCount == 1) {
            return polygonArray[0];
        }
        if (polygonCount == polygonArray.length) {
            return gf.createMultiPolygon(polygonArray);
        }
        Polygon[] trimmedPolygons = new Polygon[polygonCount];
        System.arraycopy(polygonArray, 0, trimmedPolygons, 0, polygonCount);
        return gf.createMultiPolygon(trimmedPolygons);
    }

    private static int calculateCoordinateCount(Internal.IntList commands) {
        int size = commands.size();
        int closePathCount = 0;
        int commandCount = 0;
        int i = 0;
        while (i < size) {
            int cmd = commands.getInt(i++);
            int command = GeometryCommand.extractCommand(cmd);
            int count = GeometryCommand.extractCount(cmd);
            ++commandCount;
            if (command == 7) {
                ++closePathCount;
                continue;
            }
            if (command != 1 && command != 2) continue;
            i += count * 2;
        }
        int ordinateCount = size - commandCount;
        int coordinateCount = ordinateCount / 2 + closePathCount;
        return coordinateCount;
    }

    private CoordinateSequence createSubSequence(Part part, CoordinateSequence allCoords, GeometryFactory gf) {
        return new SubCoordinateSequence(allCoords, part.start(), part.length(), gf.getCoordinateSequenceFactory());
    }

    private static Orientation areaOfRingSigned(CoordinateSequence ring, int start, int length) {
        int n = length;
        if (n < 3) {
            return Orientation.DEGENERATE;
        }
        double p1x = ring.getOrdinate(start, 0);
        double p1y = ring.getOrdinate(start, 1);
        double p2x = ring.getOrdinate(start + 1, 0);
        double p2y = ring.getOrdinate(start + 1, 1);
        double x0 = p1x;
        p2x -= x0;
        double sum = 0.0;
        for (int i = 1; i < n - 1; ++i) {
            double p0Y = p1y;
            p1x = p2x;
            p1y = p2y;
            p2x = ring.getOrdinate(start + i + 1, 0);
            p2y = ring.getOrdinate(start + i + 1, 1);
            p2x -= x0;
            sum += p1x * (p0Y - p2y);
        }
        return sum / 2.0 > 0.0 ? Orientation.CW : Orientation.CCW;
    }

    public static String toString(List<Integer> commands) {
        StringBuilder sb = new StringBuilder("[\n");
        int cursorX = 0;
        int cursorY = 0;
        int index = 0;
        int pointIndex = 0;
        while (index < commands.size()) {
            int cmd = commands.get(index++);
            int commandId = GeometryCommand.extractCommand(cmd);
            int count = GeometryCommand.extractCount(cmd);
            Object commandName = switch (commandId) {
                case 1 -> "MoveTo";
                case 2 -> "LineTo";
                case 7 -> "ClosePath";
                default -> "Unknown(" + commandId + ")";
            };
            sb.append("  Command: ").append((String)commandName).append(", Count: ").append(count).append("\n");
            if (commandId != 1 && commandId != 2) continue;
            for (int k = 0; k < count; ++k) {
                int dx = CodedInputStream.decodeZigZag32((int)commands.get(index++));
                int dy = CodedInputStream.decodeZigZag32((int)commands.get(index++));
                sb.append("    dx: ").append(dx).append(", dy: ").append(dy);
                sb.append("    Point ").append(pointIndex++).append(": (").append(cursorX += dx).append(", ").append(cursorY += dy).append(")\n");
            }
        }
        sb.append("]");
        return sb.toString();
    }

    private static enum Orientation {
        CW,
        CCW,
        DEGENERATE;

    }

    private record Part(int start, int length, Orientation orientation) {
    }
}

