/*
 * Decompiled with CFR 0.152.
 */
package io.tileverse.vectortile.mvt;

import io.tileverse.vectortile.mvt.GeometryEncoder;
import io.tileverse.vectortile.mvt.LayerBuilder;
import io.tileverse.vectortile.mvt.VectorTileBuilder;
import io.tileverse.vectortile.mvt.VectorTileProto;
import java.util.List;
import java.util.Map;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Lineal;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.Polygonal;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.geom.Puntal;
import org.locationtech.jts.precision.GeometryPrecisionReducer;

public class FeatureBuilder {
    private final LayerBuilder layerBuilder;
    private final VectorTileProto.Tile.Feature.Builder featureBuilder;
    private GeometryPrecisionReducer precisionReducer;
    private Geometry geometry;
    private GeometryEncoder encoder;

    FeatureBuilder(LayerBuilder layerBuilder) {
        this.layerBuilder = layerBuilder;
        this.featureBuilder = VectorTileProto.Tile.Feature.newBuilder();
        PrecisionModel integerPrecision = new PrecisionModel(1.0);
        this.precisionReducer = new GeometryPrecisionReducer(integerPrecision);
        this.precisionReducer.setRemoveCollapsedComponents(true);
        this.encoder = new GeometryEncoder(this.params());
    }

    VectorTileBuilder.BuildParams params() {
        return this.layerBuilder.params();
    }

    FeatureBuilder reset(long id) {
        this.featureBuilder.clear();
        if (id > -1L) {
            this.featureBuilder.setId(id);
        }
        return this;
    }

    public FeatureBuilder id(long id) {
        this.featureBuilder.setId(id);
        return this;
    }

    public FeatureBuilder geometry(Geometry geometry) {
        this.geometry = geometry;
        return this;
    }

    public FeatureBuilder attribute(String name, Object value) {
        if (value != null) {
            this.featureBuilder.addTags(this.layerBuilder.getKeyIndex(name));
            this.featureBuilder.addTags(this.layerBuilder.getValueIndex(value));
        }
        return this;
    }

    public FeatureBuilder attributes(Map<String, Object> attributes) {
        attributes.forEach(this::attribute);
        return this;
    }

    public LayerBuilder build() {
        List<Geometry> finalGeometries = this.encoder.prepareGeometries(this.geometry);
        if (finalGeometries.isEmpty()) {
            return this.layerBuilder;
        }
        if (finalGeometries.size() == 1) {
            Geometry resultingGeometry = finalGeometries.isEmpty() ? null : finalGeometries.get(0);
            this.buildFinalFeature(this.featureBuilder, resultingGeometry);
        } else {
            for (Geometry preparedGeom : finalGeometries) {
                VectorTileProto.Tile.Feature.Builder subFeatureBuilder = this.copyPrototype(this.featureBuilder);
                this.buildFinalFeature(subFeatureBuilder, preparedGeom);
            }
        }
        return this.layerBuilder;
    }

    private VectorTileProto.Tile.Feature.Builder copyPrototype(VectorTileProto.Tile.Feature.Builder prototype) {
        long id = this.params().getNextFeatureId();
        VectorTileProto.Tile.Feature.Builder newF = VectorTileProto.Tile.Feature.newBuilder();
        newF.setId(id);
        newF.addAllTags(prototype.getTagsList());
        return newF;
    }

    private void buildFinalFeature(VectorTileProto.Tile.Feature.Builder finalFeatureBuilder, Geometry resultingGeometry) {
        VectorTileProto.Tile.GeomType geomType = FeatureBuilder.toGeomType(resultingGeometry);
        finalFeatureBuilder.setType(geomType);
        List<Integer> commands = this.encoder.commands(resultingGeometry);
        finalFeatureBuilder.addAllGeometry(commands);
        VectorTileProto.Tile.Feature builtFeature = (VectorTileProto.Tile.Feature)finalFeatureBuilder.build();
        this.layerBuilder.addFeature(builtFeature);
    }

    private static VectorTileProto.Tile.GeomType toGeomType(Geometry geometry) {
        if (geometry instanceof Puntal) {
            return VectorTileProto.Tile.GeomType.POINT;
        }
        if (geometry instanceof Lineal) {
            return VectorTileProto.Tile.GeomType.LINESTRING;
        }
        if (geometry instanceof Polygonal) {
            return VectorTileProto.Tile.GeomType.POLYGON;
        }
        return VectorTileProto.Tile.GeomType.UNKNOWN;
    }

    static boolean shouldClosePath(Geometry geometry) {
        return geometry instanceof Polygon || geometry instanceof LinearRing;
    }
}

