/*
 * Decompiled with CFR 0.152.
 */
package io.tileverse.vectortile.model;

import io.tileverse.vectortile.model.GeometryReader;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;

public interface VectorTile {
    public Optional<Envelope> boundingBox();

    public VectorTile withBoundingBox(Envelope var1);

    public Set<String> getLayerNames();

    public List<Layer> getLayers();

    public Optional<Layer> getLayer(String var1);

    default public Stream<Layer.Feature> getFeatures(String layerName) {
        return this.getLayer(layerName).map(Layer::getFeatures).orElseGet(Stream::empty);
    }

    default public Stream<Layer.Feature> getFeatures(String layerName, Predicate<Layer.Feature> filter, GeometryReader decoder) {
        return this.getLayer(layerName).map(l -> l.getFeatures(filter, decoder)).orElseGet(Stream::empty);
    }

    default public Stream<Layer.Feature> getFeatures() {
        return this.getLayers().stream().flatMap(Layer::getFeatures);
    }

    public static interface Layer {
        public VectorTile getTile();

        public String getName();

        public int getExtent();

        public Set<String> getAttributeNames();

        public int count();

        public Stream<Feature> getFeatures();

        public Stream<Feature> getFeatures(Predicate<Feature> var1);

        public Stream<Feature> getFeatures(Predicate<Feature> var1, GeometryReader var2);

        public static interface Feature {
            public Layer getLayer();

            public long getId();

            public Geometry getGeometry();

            public Object getAttribute(String var1);

            public Map<String, Object> getAttributes();
        }
    }
}

