/*
 * Decompiled with CFR 0.152.
 */
package io.tileverse.vectortile.model;

import io.tileverse.vectortile.model.VectorTile;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.locationtech.jts.geom.CoordinateSequenceFilter;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;

public interface GeometryReader {
    public Geometry decode(VectorTile.Layer.Feature var1);

    public GeometryReader withGeometryFactory(GeometryFactory var1);

    public GeometryReader withGeometryTransformation(UnaryOperator<Geometry> var1);

    public static UnaryOperator<Geometry> toFunction(CoordinateSequenceFilter transform) {
        UnaryOperator transformingFunction = g -> {
            g.apply(transform);
            return g;
        };
        return transformingFunction;
    }

    @SafeVarargs
    public static UnaryOperator<Geometry> concat(UnaryOperator<Geometry> ... operations) {
        Function<Object, Object> concat = UnaryOperator.identity();
        for (UnaryOperator<Geometry> operation : operations) {
            concat = concat.andThen(operation);
        }
        return concat::apply;
    }
}

