/*
 * Decompiled with CFR 0.152.
 */
package io.tileverse.rangereader.s3;

import java.net.URI;
import java.util.Optional;

record S3Reference(URI endpoint, String bucket, String key, String region) {
    S3Reference() {
        this(null, null, null, null);
    }

    public boolean isDefaultAwsEndpoint() {
        return this.endpoint == null;
    }

    public boolean requiresPathStyle() {
        return this.endpoint != null;
    }

    public Optional<URI> endpointOverride() {
        return Optional.ofNullable(this.endpoint);
    }

    @Override
    public String toString() {
        if (this.isDefaultAwsEndpoint()) {
            return "s3://%s/%s".formatted(this.bucket, this.key);
        }
        return "%s/%s/%s".formatted(this.endpoint, this.bucket, this.key);
    }

    S3Reference withEndpoint(URI endpoint) {
        return new S3Reference(endpoint, this.bucket(), this.key(), this.region());
    }

    S3Reference withBucket(String bucket) {
        return new S3Reference(this.endpoint(), bucket, this.key(), this.region());
    }

    S3Reference withKey(String key) {
        return new S3Reference(this.endpoint(), this.bucket(), key, this.region());
    }

    S3Reference withRegion(String region) {
        return new S3Reference(this.endpoint(), this.bucket(), this.key(), region);
    }
}

