/*
 * Decompiled with CFR 0.152.
 */
package io.tileverse.rangereader.s3;

import io.tileverse.rangereader.RangeReader;
import io.tileverse.rangereader.s3.S3CompatibleUrlParser;
import io.tileverse.rangereader.s3.S3RangeReader;
import io.tileverse.rangereader.s3.S3Reference;
import io.tileverse.rangereader.spi.AbstractRangeReaderProvider;
import io.tileverse.rangereader.spi.RangeReaderConfig;
import io.tileverse.rangereader.spi.RangeReaderParameter;
import io.tileverse.rangereader.spi.RangeReaderProvider;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.regions.Region;

public class S3RangeReaderProvider
extends AbstractRangeReaderProvider {
    private static final Logger logger = LoggerFactory.getLogger(S3RangeReaderProvider.class);
    public static final String ENABLED_KEY = "IO_TILEVERSE_RANGEREADER_S3";
    public static final String ID = "s3";
    public static final RangeReaderParameter<Boolean> S3_FORCE_PATH_STYLE = RangeReaderParameter.builder().key("io.tileverse.rangereader.s3.force-path-style").title("Enable S3 path style access").description("When enabled, requests will use path-style addressing (e.g., https://s3.amazonaws.com/bucket/key).\n\nWhen disabled, virtual-hosted-style addressing will be used instead (e.g., https://bucket.s3.amazonaws.com/key).\n\nThis can be useful for compatibility with S3-compatible storage systems that do not support virtual-hosted-style requests.\n\nNote: When a complete S3 URL is provided, path style is automatically detected and enabled for non-AWS endpoints (MinIO, Google Cloud Storage, etc.). This parameter allows explicit override of the automatic detection behavior.\n").type(Boolean.class).group("s3").defaultValue((Object)true).build();
    public static final RangeReaderParameter<String> S3_REGION = RangeReaderParameter.builder().key("io.tileverse.rangereader.s3.region").title("Region").description("Configure the region with which the SDK should communicate.\n\nIf this is not specified, the SDK will attempt to identify the endpoint automatically using the following logic:\n\n* Check the 'aws.region' system property for the region.\n* Check the 'AWS_REGION' environment variable for the region.\n* Check the {user.home}/.aws/credentials and {user.home}/.aws/config files for the region.\n* If running in EC2, check the EC2 metadata service for the region.\n\nIf the region is not found, an exception will be thrown.\n\nEach AWS region corresponds to a separate geographical location where a set of Amazon services is deployed. These regions (except for the special `aws-global` and `aws-cn-global` regions) are separate from each other, with their own set of resources. This means a resource created in one region (eg. an SQS queue) is not available in another region.\n").type(String.class).group("s3").options(Region.regions().stream().filter(Predicate.not(Region::isGlobalRegion)).map(Region::id).toArray()).build();
    public static final RangeReaderParameter<String> S3_AWS_ACCESS_KEY_ID = RangeReaderParameter.builder().key("io.tileverse.rangereader.s3.aws-access-key-id").title("AWS Access Key ID").description("The AWS access key ID to use for authentication.\n\nThis parameter must be used together with AWS_SECRET_ACCESS_KEY. When both are provided, they will be used for authentication regardless of the USE_DEFAULT_CREDENTIALS_PROVIDER setting.\n\nIf neither AWS_ACCESS_KEY_ID nor AWS_SECRET_ACCESS_KEY are provided, authentication behavior is controlled by the USE_DEFAULT_CREDENTIALS_PROVIDER parameter.\n").type(String.class).group("s3").subgroup("authentication").build();
    public static final RangeReaderParameter<String> S3_AWS_SECRET_ACCESS_KEY = RangeReaderParameter.builder().key("io.tileverse.rangereader.s3.aws-secret-access-key").title("AWS Secret Access Key").description("The AWS secret access key to use for authentication.\n\nThis parameter must be used together with AWS_ACCESS_KEY_ID. When both are provided, they will be used for authentication regardless of the USE_DEFAULT_CREDENTIALS_PROVIDER setting.\n\nIf neither AWS_ACCESS_KEY_ID nor AWS_SECRET_ACCESS_KEY are provided, authentication behavior is controlled by the USE_DEFAULT_CREDENTIALS_PROVIDER parameter.\n").type(String.class).group("s3").subgroup("authentication").password(true).build();
    public static final RangeReaderParameter<Boolean> S3_USE_DEFAULT_CREDENTIALS_PROVIDER = RangeReaderParameter.builder().key("io.tileverse.rangereader.s3.use-default-credentials-provider").title("Use Default Credentials Provider").description("When enabled, the AWS default credentials provider chain is used, which looks for credentials in this order:\n  1. Java System Properties - aws.accessKeyId and aws.secretAccessKey\n  2. Environment Variables - AWS_ACCESS_KEY_ID and AWS_SECRET_ACCESS_KEY\n  3. Web Identity Token File - from the path specified in the AWS_WEB_IDENTITY_TOKEN_FILE environment variable\n  4. Shared Credentials File - at ~/.aws/credentials\n  5. Amazon ECS Container Credentials - loaded from the endpoint specified in the AWS_CONTAINER_CREDENTIALS_RELATIVE_URI environment variable\n  6. Amazon EC2 Instance Profile Credentials - loaded from the Amazon EC2 metadata service\n\nIf neither default credentials provider or access/secret key are used, annonymous access will be attempted.\n").type(Boolean.class).group("s3").subgroup("authentication").build();
    public static final RangeReaderParameter<String> S3_DEFAULT_CREDENTIALS_PROFILE = RangeReaderParameter.builder().key("io.tileverse.rangereader.s3.default-credentials-profile").title("Default Credentials Profile").description("The AWS credentials profile name to use when USE_DEFAULT_CREDENTIALS_PROVIDER is enabled.\n\nIf not specified, the 'default' profile is used. This parameter is only effective when USE_DEFAULT_CREDENTIALS_PROVIDER is set to true.\n\nThe profile should exist in the AWS credentials file (typically ~/.aws/credentials) or AWS config file (typically ~/.aws/config).\n").type(String.class).group("s3").subgroup("authentication").build();
    static final List<RangeReaderParameter<?>> PARAMS = List.of(S3_FORCE_PATH_STYLE, S3_REGION, S3_AWS_ACCESS_KEY_ID, S3_AWS_SECRET_ACCESS_KEY, S3_USE_DEFAULT_CREDENTIALS_PROVIDER, S3_DEFAULT_CREDENTIALS_PROFILE);

    public S3RangeReaderProvider() {
        super(true);
    }

    public String getId() {
        return ID;
    }

    public boolean isAvailable() {
        return RangeReaderProvider.isEnabled((String)ENABLED_KEY);
    }

    public String getDescription() {
        return "AWS S3 Range Reader";
    }

    public int getOrder() {
        return -100;
    }

    protected List<RangeReaderParameter<?>> buildParameters() {
        return PARAMS;
    }

    protected RangeReader createInternal(RangeReaderConfig opts) throws IOException {
        S3RangeReader.Builder builder = this.prepareRangeReaderBuilder(opts);
        return builder.build();
    }

    S3RangeReader.Builder prepareRangeReaderBuilder(RangeReaderConfig opts) {
        URI uri = opts.uri();
        S3RangeReader.Builder builder = S3RangeReader.builder().uri(uri);
        opts.getParameter(S3_FORCE_PATH_STYLE).ifPresent(builder::forcePathStyle);
        opts.getParameter(S3_REGION).filter(r -> !r.isBlank()).map(Region::of).ifPresent(builder::region);
        opts.getParameter(S3_AWS_ACCESS_KEY_ID).ifPresent(builder::awsAccessKeyId);
        opts.getParameter(S3_AWS_SECRET_ACCESS_KEY).ifPresent(builder::awsSecretAccessKey);
        opts.getParameter(S3_USE_DEFAULT_CREDENTIALS_PROVIDER).ifPresent(builder::useDefaultCredentialsProvider);
        opts.getParameter(S3_DEFAULT_CREDENTIALS_PROFILE).ifPresent(builder::defaultCredentialsProfile);
        return builder;
    }

    public boolean canProcess(RangeReaderConfig config) {
        if (RangeReaderConfig.matches((RangeReaderConfig)config, (String)this.getId(), (String[])new String[]{ID, "http", "https"})) {
            try {
                boolean hasValidKey;
                S3Reference l = S3CompatibleUrlParser.parseS3Url(config.uri());
                boolean hasValidBucket = l.bucket() != null && !l.bucket().trim().isEmpty();
                boolean bl = hasValidKey = l.key() != null && !l.key().trim().isEmpty();
                if (!hasValidBucket || !hasValidKey) {
                    logger.debug("Skipping URL {} - bucket='{}', key='{}'", new Object[]{config.uri(), l.bucket(), l.key()});
                    return false;
                }
                return true;
            }
            catch (IllegalArgumentException e) {
                logger.debug("Can't process URL {}: {}", (Object)config.uri(), (Object)e.getMessage());
            }
        }
        return false;
    }

    public boolean canProcessHeaders(URI uri, Map<String, List<String>> headers) {
        Set<String> headerNames = headers.keySet();
        return headerNames.stream().anyMatch("x-amz-request-id"::equalsIgnoreCase);
    }
}

