/*
 * Decompiled with CFR 0.152.
 */
package io.tileverse.rangereader.s3;

import io.tileverse.rangereader.AbstractRangeReader;
import io.tileverse.rangereader.RangeReader;
import io.tileverse.rangereader.s3.S3CompatibleUrlParser;
import io.tileverse.rangereader.s3.S3Reference;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import software.amazon.awssdk.auth.credentials.AnonymousCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.auth.credentials.ProfileCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.core.ResponseBytes;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.GetObjectResponse;
import software.amazon.awssdk.services.s3.model.HeadObjectRequest;
import software.amazon.awssdk.services.s3.model.HeadObjectResponse;
import software.amazon.awssdk.services.s3.model.NoSuchKeyException;

public class S3RangeReader
extends AbstractRangeReader
implements RangeReader {
    private final S3Client s3Client;
    private final S3Reference s3Location;
    private final OptionalLong contentLength;

    S3RangeReader(S3Client s3Client, S3Reference s3Location) throws IOException {
        this.s3Client = Objects.requireNonNull(s3Client, "S3Client cannot be null");
        this.s3Location = Objects.requireNonNull(s3Location, "S3Location cannot be null");
        try {
            HeadObjectRequest headRequest = (HeadObjectRequest)HeadObjectRequest.builder().bucket(s3Location.bucket()).key(s3Location.key()).build();
            HeadObjectResponse headResponse = s3Client.headObject(headRequest);
            Long size = headResponse.contentLength();
            this.contentLength = size == null ? OptionalLong.empty() : OptionalLong.of(size);
        }
        catch (NoSuchKeyException e) {
            throw new IOException("S3 object does not exist: s3://" + String.valueOf(s3Location), e);
        }
        catch (SdkException e) {
            throw new IOException("Failed to access S3 object " + String.valueOf(s3Location) + ": " + e.getMessage(), e);
        }
    }

    S3RangeReader(S3Client client, String bucketName, String keyName) throws IOException {
        this(client, new S3Reference(null, bucketName, keyName, null));
    }

    protected int readRangeNoFlip(long offset, int actualLength, ByteBuffer target) throws IOException {
        long rangeEnd = offset + (long)actualLength - 1L;
        try {
            GetObjectRequest rangeRequest = (GetObjectRequest)GetObjectRequest.builder().bucket(this.s3Location.bucket()).key(this.s3Location.key()).range("bytes=" + offset + "-" + rangeEnd).build();
            ResponseBytes objectBytes = this.s3Client.getObjectAsBytes(rangeRequest);
            if (((GetObjectResponse)objectBytes.response()).contentLength() != (long)actualLength) {
                throw new IOException("Unexpected content length: got " + ((GetObjectResponse)objectBytes.response()).contentLength() + ", expected " + actualLength);
            }
            byte[] data = objectBytes.asByteArray();
            target.put(data);
            return data.length;
        }
        catch (SdkException e) {
            throw new IOException("Failed to read range from S3: " + e.getMessage(), e);
        }
    }

    public OptionalLong size() throws IOException {
        return this.contentLength;
    }

    public String getSourceIdentifier() {
        return this.s3Location.toString();
    }

    public void close() {
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private S3Reference s3Location = new S3Reference();
        private S3Client s3Client;
        private Region region;
        private boolean forcePathStyle;
        private AwsCredentialsProvider credentialsProvider;
        private String awsAccessKeyId;
        private String awsSecretAccessKey;
        private boolean useDefaultCredentialsProvider;
        private String defaultCredentialsProfile;

        private Builder() {
        }

        public Builder awsAccessKeyId(String awsAccessKeyId) {
            this.awsAccessKeyId = awsAccessKeyId;
            return this;
        }

        public Builder awsSecretAccessKey(String awsSecretAccessKey) {
            this.awsSecretAccessKey = awsSecretAccessKey;
            return this;
        }

        public Builder useDefaultCredentialsProvider(boolean useDefaultCredentialsProvider) {
            this.useDefaultCredentialsProvider = useDefaultCredentialsProvider;
            return this;
        }

        public Builder defaultCredentialsProfile(String defaultCredentialsProfile) {
            this.defaultCredentialsProfile = defaultCredentialsProfile;
            return this;
        }

        public Builder s3Client(S3Client s3Client) {
            this.s3Client = Objects.requireNonNull(s3Client, "S3Client cannot be null");
            return this;
        }

        public Builder credentialsProvider(AwsCredentialsProvider credentialsProvider) {
            this.credentialsProvider = Objects.requireNonNull(credentialsProvider, "Credentials provider cannot be null");
            return this;
        }

        public Builder region(Region region) {
            this.region = Objects.requireNonNull(region, "Region cannot be null");
            return this;
        }

        public Builder endpoint(URI endpoint) {
            Objects.requireNonNull(endpoint, "Endpoint cannot be null");
            this.s3Location = this.s3Location.withEndpoint(endpoint);
            return this;
        }

        public Builder forcePathStyle() {
            return this.forcePathStyle(true);
        }

        public Builder forcePathStyle(boolean forcePathStyle) {
            this.forcePathStyle = forcePathStyle;
            return this;
        }

        public Builder bucket(String bucket) {
            Objects.requireNonNull(bucket, "Bucket cannot be null");
            this.s3Location = this.s3Location.withBucket(bucket);
            return this;
        }

        public Builder key(String key) {
            Objects.requireNonNull(key, "Key cannot be null");
            this.s3Location = this.s3Location.withKey(key);
            return this;
        }

        public Builder uri(URI uri) {
            Objects.requireNonNull(uri, "URI cannot be null");
            this.s3Location = S3CompatibleUrlParser.parseS3Url(uri);
            return this;
        }

        public Builder uri(String uri) {
            return this.uri(URI.create(uri));
        }

        public S3RangeReader build() throws IOException {
            if (this.s3Location.bucket() == null || this.s3Location.key() == null) {
                throw new IllegalStateException("Bucket and key must be set");
            }
            S3Client client = this.s3Client;
            if (client == null) {
                S3ClientBuilder clientBuilder = S3Client.builder();
                clientBuilder.credentialsProvider(this.resolveCredentialsProvider());
                this.resolveRegion().ifPresent(arg_0 -> ((S3ClientBuilder)clientBuilder).region(arg_0));
                this.s3Location.endpointOverride().ifPresent(arg_0 -> ((S3ClientBuilder)clientBuilder).endpointOverride(arg_0));
                boolean pathStyle = this.s3Location.requiresPathStyle() || this.forcePathStyle;
                clientBuilder.forcePathStyle(Boolean.valueOf(pathStyle));
                try {
                    client = (S3Client)clientBuilder.build();
                }
                catch (SdkException e) {
                    throw new IOException("Failed to create S3 client: " + e.getMessage(), e);
                }
            }
            return new S3RangeReader(client, this.s3Location);
        }

        private Optional<Region> resolveRegion() {
            Region region = this.region;
            if (region == null) {
                if (this.s3Location.region() != null) {
                    region = Region.of((String)this.s3Location.region());
                } else if (this.defaultCredentialsProfile != null) {
                    DefaultAwsRegionProviderChain profileProvider = DefaultAwsRegionProviderChain.builder().profileName(this.defaultCredentialsProfile).build();
                    region = profileProvider.getRegion();
                }
            }
            return Optional.ofNullable(region);
        }

        private AwsCredentialsProvider resolveCredentialsProvider() {
            if (this.credentialsProvider != null) {
                return this.credentialsProvider;
            }
            if (this.awsAccessKeyId != null && this.awsSecretAccessKey != null) {
                AwsBasicCredentials credentials = AwsBasicCredentials.create((String)this.awsAccessKeyId, (String)this.awsSecretAccessKey);
                return StaticCredentialsProvider.create((AwsCredentials)credentials);
            }
            if (this.useDefaultCredentialsProvider) {
                DefaultCredentialsProvider.Builder defaultChainBuilder = DefaultCredentialsProvider.builder().reuseLastProviderEnabled(Boolean.valueOf(true)).asyncCredentialUpdateEnabled(Boolean.valueOf(true));
                if (this.defaultCredentialsProfile != null) {
                    defaultChainBuilder.profileName(this.defaultCredentialsProfile);
                }
                return defaultChainBuilder.build();
            }
            if (this.defaultCredentialsProfile != null) {
                return ProfileCredentialsProvider.create((String)this.defaultCredentialsProfile);
            }
            return AnonymousCredentialsProvider.create();
        }
    }
}

