/*
 * Decompiled with CFR 0.152.
 */
package io.tileverse.rangereader.s3;

import io.tileverse.rangereader.s3.S3Reference;
import java.net.URI;
import java.net.URISyntaxException;
import software.amazon.awssdk.regions.Region;

class S3CompatibleUrlParser {
    S3CompatibleUrlParser() {
    }

    public static S3Reference parseS3Url(String uri) {
        try {
            return S3CompatibleUrlParser.parseS3Url(new URI(uri));
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid S3 URL: " + uri, e);
        }
    }

    public static S3Reference parseS3Url(URI uri) {
        if ("s3".equals(uri.getScheme())) {
            return S3CompatibleUrlParser.parseS3Uri(uri);
        }
        if ("https".equals(uri.getScheme()) || "http".equals(uri.getScheme())) {
            return S3CompatibleUrlParser.parseHttpS3Url(uri);
        }
        throw new IllegalArgumentException("Unsupported scheme: " + uri.getScheme() + " in " + String.valueOf(uri));
    }

    private static S3Reference parseS3Uri(URI uri) {
        String bucket = uri.getHost();
        String key = uri.getPath();
        if (key != null && key.startsWith("/")) {
            key = key.substring(1);
        }
        String region = S3CompatibleUrlParser.extractRegionFromBucketName(bucket);
        return new S3Reference(null, bucket, key != null ? key : "", region);
    }

    private static S3Reference parseHttpS3Url(URI uri) {
        String host = uri.getHost();
        String path = uri.getPath();
        if (S3CompatibleUrlParser.isAwsVirtualHostedStyle(host)) {
            String bucket = host.substring(0, host.indexOf(".s3"));
            String key = path != null && path.startsWith("/") ? path.substring(1) : (path != null ? path : "");
            String region = S3CompatibleUrlParser.extractAwsRegion(host);
            if (region == null) {
                region = S3CompatibleUrlParser.extractRegionFromBucketName(host);
            }
            if (region == null) {
                region = S3CompatibleUrlParser.extractRegionFromBucketName(bucket);
            }
            return new S3Reference(null, bucket, key, region);
        }
        if (S3CompatibleUrlParser.isAwsPathStyle(host)) {
            S3Reference pathStyleLocation = S3CompatibleUrlParser.parsePathStyleComponents(uri);
            String region = S3CompatibleUrlParser.extractAwsRegion(host);
            if (region == null && pathStyleLocation.bucket() != null) {
                region = S3CompatibleUrlParser.extractRegionFromBucketName(pathStyleLocation.bucket());
            }
            return new S3Reference(null, pathStyleLocation.bucket(), pathStyleLocation.key(), region);
        }
        S3Reference pathStyleLocation = S3CompatibleUrlParser.parsePathStyleComponents(uri);
        URI customEndpoint = S3CompatibleUrlParser.buildCustomEndpoint(uri);
        return new S3Reference(customEndpoint, pathStyleLocation.bucket(), pathStyleLocation.key(), null);
    }

    private static boolean isAwsVirtualHostedStyle(String host) {
        return host != null && (host.contains(".s3.") && host.contains("amazonaws.com") || host.contains(".s3-") && host.contains("amazonaws.com"));
    }

    private static boolean isAwsPathStyle(String host) {
        return host != null && (host.equals("s3.amazonaws.com") || host.startsWith("s3.") && host.endsWith(".amazonaws.com"));
    }

    private static URI extractAwsEndpoint(String host) {
        if (host.equals("s3.amazonaws.com")) {
            return null;
        }
        String region = S3CompatibleUrlParser.extractAwsRegion(host);
        if (region != null && !region.equals("us-east-1")) {
            return URI.create("https://s3." + region + ".amazonaws.com");
        }
        return null;
    }

    private static String extractAwsRegion(String host) {
        if (host.contains(".s3.") && host.contains("amazonaws.com")) {
            String[] parts = host.split("\\.");
            for (int i = 0; i < parts.length - 1; ++i) {
                if (!"s3".equals(parts[i]) || i + 1 >= parts.length) continue;
                String nextPart = parts[i + 1];
                if ("amazonaws".equals(nextPart)) {
                    return null;
                }
                return nextPart;
            }
        } else if (host.startsWith("s3.") && host.endsWith(".amazonaws.com")) {
            int endIndex = host.length() - ".amazonaws.com".length();
            if (endIndex > 3) {
                String regionPart = host.substring(3, endIndex);
                return regionPart.isEmpty() ? null : regionPart;
            }
            return null;
        }
        return null;
    }

    private static URI buildCustomEndpoint(URI uri) {
        StringBuilder endpoint = new StringBuilder();
        endpoint.append(uri.getScheme()).append("://").append(uri.getHost());
        if (uri.getPort() != -1) {
            endpoint.append(":").append(uri.getPort());
        }
        return URI.create(endpoint.toString());
    }

    private static S3Reference parsePathStyleComponents(URI uri) {
        String path = uri.getPath();
        if (path == null || path.length() <= 1) {
            return new S3Reference(S3CompatibleUrlParser.buildCustomEndpoint(uri), null, null, null);
        }
        String pathWithoutLeadingSlash = path.substring(1);
        int firstSlash = pathWithoutLeadingSlash.indexOf(47);
        if (firstSlash == -1) {
            return new S3Reference(null, pathWithoutLeadingSlash, "", null);
        }
        String bucket = pathWithoutLeadingSlash.substring(0, firstSlash);
        String key = pathWithoutLeadingSlash.substring(firstSlash + 1);
        return new S3Reference(null, bucket, key, null);
    }

    private static String extractRegionFromBucketName(String hostOrBucket) {
        if (hostOrBucket == null) {
            return null;
        }
        return Region.regions().stream().filter(r -> hostOrBucket.contains(r.id())).map(Region::id).max((r1, r2) -> Integer.compare(r1.length(), r2.length())).orElse(null);
    }
}

