/*
 * Decompiled with CFR 0.152.
 */
package io.tileverse.rangereader.gcs;

import io.tileverse.rangereader.RangeReader;
import io.tileverse.rangereader.gcs.GoogleCloudStorageRangeReader;
import io.tileverse.rangereader.spi.AbstractRangeReaderProvider;
import io.tileverse.rangereader.spi.RangeReaderConfig;
import io.tileverse.rangereader.spi.RangeReaderParameter;
import io.tileverse.rangereader.spi.RangeReaderProvider;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GoogleCloudStorageRangeReaderProvider
extends AbstractRangeReaderProvider {
    public static final String ENABLED_KEY = "IO_TILEVERSE_RANGEREADER_GCS";
    public static final String ID = "gcs";
    public static final RangeReaderParameter<String> GCS_PROJECT_ID = RangeReaderParameter.builder().key("io.tileverse.rangereader.gcs.project-id").title("Google Cloud project ID").description("Project ID is a unique, user-defined identifier for a Google Cloud project.\n\nIf no project ID is set, an attempt to obtain a default project ID from the environment will be made.\n\nThe default project ID will be obtained by the first available project ID among the following sources:\n1. The project ID specified by the GOOGLE_CLOUD_PROJECT environment variable\n2. The App Engine project ID\n3. The project ID specified in the JSON credentials file pointed by the GOOGLE_APPLICATION_CREDENTIALS environment variable\n4. The Google Cloud SDK project ID\n5. The Compute Engine project ID\n").type(String.class).group("gcs").build();
    public static final RangeReaderParameter<String> GCS_QUOTA_PROJECT_ID = RangeReaderParameter.builder().key("io.tileverse.rangereader.gcs.quota-project-id").title("Quota Project ID").description("Quota ProjectId that specifies the project used for quota and billing purposes.\n\nThe caller must have serviceusage.services.use permission on the project.\n").type(String.class).group("gcs").build();
    public static final RangeReaderParameter<Boolean> GCS_USE_DEFAULT_APPLICTION_CREDENTIALS = RangeReaderParameter.builder().key("io.tileverse.rangereader.gcs.default-credentials-chain").title("Use the default application credentials chain").description("Whether to use the default application credentials chain.\n\nTo set up Application Default Credentials for your environment, see https://cloud.google.com/docs/authentication/external/set-up-adc\n\nNot doing so will lead to an error saying \"Your default credentials were not found.\"\n").group("gcs").subgroup("authentication").type(Boolean.class).defaultValue((Object)false).build();
    private static final List<RangeReaderParameter<?>> PARAMS = List.of(GCS_PROJECT_ID, GCS_QUOTA_PROJECT_ID, GCS_USE_DEFAULT_APPLICTION_CREDENTIALS);

    public GoogleCloudStorageRangeReaderProvider() {
        super(true);
    }

    public String getId() {
        return ID;
    }

    public boolean isAvailable() {
        return RangeReaderProvider.isEnabled((String)ENABLED_KEY);
    }

    public String getDescription() {
        return "Google Cloud Storage Range Reader";
    }

    public int getOrder() {
        return -100;
    }

    protected List<RangeReaderParameter<?>> buildParameters() {
        return PARAMS;
    }

    public boolean canProcess(RangeReaderConfig config) {
        return RangeReaderConfig.matches((RangeReaderConfig)config, (String)this.getId(), (String[])new String[]{"gs", "http", "https"});
    }

    public boolean canProcessHeaders(URI uri, Map<String, List<String>> headers) {
        Set<String> headerNames = headers.keySet();
        boolean hasCustomHeaders = headerNames.stream().anyMatch(h -> h.toLowerCase().startsWith("x-goog-"));
        if (hasCustomHeaders) {
            return true;
        }
        String host = uri.getHost();
        return "storage.googleapis.com".equals(host) || "storage.cloud.google.com".equals(host);
    }

    protected RangeReader createInternal(RangeReaderConfig opts) throws IOException {
        URI uri = opts.uri();
        return GoogleCloudStorageRangeReader.builder().uri(uri).build();
    }
}

