/*
 * Decompiled with CFR 0.152.
 */
package io.tileverse.rangereader.azure;

import com.azure.storage.blob.BlobUrlParts;
import io.tileverse.rangereader.RangeReader;
import io.tileverse.rangereader.azure.AzureBlobRangeReader;
import io.tileverse.rangereader.spi.AbstractRangeReaderProvider;
import io.tileverse.rangereader.spi.RangeReaderConfig;
import io.tileverse.rangereader.spi.RangeReaderParameter;
import io.tileverse.rangereader.spi.RangeReaderProvider;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Map;

public class AzureBlobRangeReaderProvider
extends AbstractRangeReaderProvider {
    public static final String ENABLED_KEY = "IO_TILEVERSE_RANGEREADER_AZURE";
    public static final String ID = "azure";
    public static final RangeReaderParameter<String> AZURE_BLOB_NAME = RangeReaderParameter.builder().key("io.tileverse.rangereader.azure.blob-name").title("Set the blob name if the endpoint points to the account url").description("Sets the blob path (e.g. /path/to/file.pmtiles).\n\nIf the endpoint URL is to a blob in the root container, parsing will fail as it will interpret the blob name as the container name. With only one path element, it is impossible to distinguish between a container name and a blob in the root container, so it is assumed to be the container name as this is much more common\n\nWhen working with blobs in the root container, it is best to set the endpoint to the account url and specify the blob name separately using this parameter.\n").type(String.class).group("azure").build();
    public static final RangeReaderParameter<String> AZURE_ACCOUNT_KEY = RangeReaderParameter.builder().key("io.tileverse.rangereader.azure.account-key").title("Account access key").description("The account access key used to authenticate the request.\n\nWhen specified, the account name obtained from the URI will be used with this access key to create a SharedKey credential policy that is put into a header to authorize requests\n").type(String.class).group("azure").subgroup("authentication").password(true).build();
    public static final RangeReaderParameter<String> AZURE_SAS_TOKEN = RangeReaderParameter.builder().key("io.tileverse.rangereader.azure.sas-token").title("SAS token to use for authenticating requests").description("Shared Access Signature, a security token generated on the client side to grant limited, delegated access to Azure resources.\n\nThis token can also be in the blob URL query string.\n").type(String.class).group("azure").subgroup("authentication").password(true).build();
    private static final List<RangeReaderParameter<?>> PARAMS = List.of(AZURE_BLOB_NAME, AZURE_ACCOUNT_KEY, AZURE_SAS_TOKEN);

    public AzureBlobRangeReaderProvider() {
        super(true);
    }

    public String getId() {
        return ID;
    }

    public boolean isAvailable() {
        return RangeReaderProvider.isEnabled((String)ENABLED_KEY);
    }

    public String getDescription() {
        return "Azure Blob Storage Range Reader";
    }

    public int getOrder() {
        return -100;
    }

    protected List<RangeReaderParameter<?>> buildParameters() {
        return PARAMS;
    }

    public boolean canProcess(RangeReaderConfig config) {
        BlobUrlParts parts;
        if (!RangeReaderConfig.matches((RangeReaderConfig)config, (String)this.getId(), (String[])new String[]{"http", "https"})) {
            return false;
        }
        URI endpointUrl = config.uri();
        try {
            parts = BlobUrlParts.parse((String)endpointUrl.toString());
        }
        catch (Exception e) {
            return false;
        }
        if (parts.getHost() == null || parts.getBlobContainerName() == null) {
            return false;
        }
        String blobName = parts.getBlobName();
        if (blobName == null) {
            return config.getParameter(AZURE_BLOB_NAME).isPresent();
        }
        return true;
    }

    public boolean canProcessHeaders(URI uri, Map<String, List<String>> headers) {
        return headers.containsKey("x-ms-request-id");
    }

    protected RangeReader createInternal(RangeReaderConfig opts) throws IOException {
        URI uri = opts.uri();
        AzureBlobRangeReader.Builder builder = AzureBlobRangeReader.builder().endpoint(uri);
        opts.getParameter(AZURE_BLOB_NAME).ifPresent(builder::blobName);
        opts.getParameter(AZURE_ACCOUNT_KEY).ifPresent(builder::accountKey);
        opts.getParameter(AZURE_SAS_TOKEN).ifPresent(builder::sasToken);
        return builder.build();
    }
}

