/*
 * Decompiled with CFR 0.152.
 */
package io.tileverse.pmtiles.store;

import io.tileverse.tiling.common.BoundingBox2D;
import io.tileverse.tiling.common.Coordinate;
import io.tileverse.tiling.pyramid.TileIndex;

final class WebMercatorTransform {
    private static final double EARTH_RADIUS = 6378137.0;
    private static final double ORIGIN_SHIFT = 2.0037508342789244E7;
    private static final double MAX_LATITUDE = 85.0511287798;

    private WebMercatorTransform() {
    }

    public static Coordinate latLonToWebMercator(double longitude, double latitude) {
        double clampedLat = Math.max(-85.0511287798, Math.min(85.0511287798, latitude));
        double lonRad = Math.toRadians(longitude);
        double latRad = Math.toRadians(clampedLat);
        double x = 6378137.0 * lonRad;
        double y = 6378137.0 * Math.log(Math.tan(0.7853981633974483 + latRad / 2.0));
        return Coordinate.of((double)x, (double)y);
    }

    public static Coordinate webMercatorToLatLon(double x, double y) {
        double longitude = Math.toDegrees(x / 6378137.0);
        double latitude = Math.toDegrees(1.5707963267948966 - 2.0 * Math.atan(Math.exp(-y / 6378137.0)));
        return Coordinate.of((double)longitude, (double)latitude);
    }

    public static BoundingBox2D latLonToWebMercator(BoundingBox2D geographicExtent) {
        Coordinate min = WebMercatorTransform.latLonToWebMercator(geographicExtent.minX(), geographicExtent.minY());
        Coordinate max = WebMercatorTransform.latLonToWebMercator(geographicExtent.maxX(), geographicExtent.maxY());
        return BoundingBox2D.extent((double)min.x(), (double)min.y(), (double)max.x(), (double)max.y());
    }

    public static TileIndex webMercatorToTile(double x, double y, int zoom) {
        double normalizedX = (x + 2.0037508342789244E7) / 4.007501668557849E7;
        double normalizedY = (2.0037508342789244E7 - y) / 4.007501668557849E7;
        long tilesAtZoom = 1L << zoom;
        long tileX = (long)Math.floor(normalizedX * (double)tilesAtZoom);
        long tileY = (long)Math.floor(normalizedY * (double)tilesAtZoom);
        tileX = Math.max(0L, Math.min(tilesAtZoom - 1L, tileX));
        tileY = Math.max(0L, Math.min(tilesAtZoom - 1L, tileY));
        return TileIndex.xyz((long)tileX, (long)tileY, (int)zoom);
    }

    public static TileIndex latLonToTile(double longitude, double latitude, int zoom) {
        Coordinate webMercator = WebMercatorTransform.latLonToWebMercator(longitude, latitude);
        return WebMercatorTransform.webMercatorToTile(webMercator.x(), webMercator.y(), zoom);
    }

    public static BoundingBox2D tileToWebMercatorExtent(TileIndex tileIndex) {
        int zoom = tileIndex.z();
        long x = tileIndex.x();
        long y = tileIndex.y();
        long tilesAtZoom = 1L << zoom;
        double tileSize = 4.007501668557849E7 / (double)tilesAtZoom;
        double minX = -2.0037508342789244E7 + (double)x * tileSize;
        double maxX = minX + tileSize;
        double maxY = 2.0037508342789244E7 - (double)y * tileSize;
        double minY = maxY - tileSize;
        return BoundingBox2D.extent((double)minX, (double)minY, (double)maxX, (double)maxY);
    }

    public static BoundingBox2D tileToGeographicExtent(TileIndex tileIndex) {
        BoundingBox2D webMercatorExtent = WebMercatorTransform.tileToWebMercatorExtent(tileIndex);
        Coordinate min = WebMercatorTransform.webMercatorToLatLon(webMercatorExtent.minX(), webMercatorExtent.minY());
        Coordinate max = WebMercatorTransform.webMercatorToLatLon(webMercatorExtent.maxX(), webMercatorExtent.maxY());
        return BoundingBox2D.extent((double)min.x(), (double)min.y(), (double)max.x(), (double)max.y());
    }

    public static BoundingBox2D getWebMercatorBounds() {
        return BoundingBox2D.extent((double)-2.0037508342789244E7, (double)-2.0037508342789244E7, (double)2.0037508342789244E7, (double)2.0037508342789244E7);
    }

    public static double getEarthRadius() {
        return 6378137.0;
    }

    public static double getMaxLatitude() {
        return 85.0511287798;
    }
}

