/*
 * Decompiled with CFR 0.152.
 */
package io.tileverse.pmtiles.store;

import io.tileverse.tiling.common.BoundingBox2D;
import io.tileverse.tiling.store.TileStore;
import io.tileverse.vectortile.model.VectorTile;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;

public class VectorTilesQuery {
    private List<String> layerIds;
    private GeometryFactory geometryFactory;
    private boolean transformToCrs;
    private Predicate<VectorTile.Layer.Feature> filter;
    private UnaryOperator<Geometry> geometryOperation;
    private Integer zoomLevel;
    private List<BoundingBox2D> queryExtent = List.of();
    private Double resolution;
    private TileStore.Strategy strategy = TileStore.Strategy.SPEED;

    public VectorTilesQuery layers(String ... layerIds) {
        this.layerIds = Stream.of(layerIds).filter(Objects::nonNull).toList();
        if (this.layerIds.isEmpty()) {
            throw new IllegalArgumentException("layerIds can't be empty. To retrieve all layers, don't call layers(String... layerIds)");
        }
        return this;
    }

    public Optional<List<String>> layers() {
        return Optional.ofNullable(this.layerIds);
    }

    public VectorTilesQuery zoomLevel(Integer zoomLevel) {
        this.zoomLevel = zoomLevel;
        return this;
    }

    public OptionalInt zoomLevel() {
        return this.zoomLevel == null ? OptionalInt.empty() : OptionalInt.of(this.zoomLevel);
    }

    public VectorTilesQuery resolution(double resolution) {
        this.resolution = resolution;
        return this;
    }

    public OptionalDouble resolution() {
        return this.resolution == null ? OptionalDouble.empty() : OptionalDouble.of(this.resolution);
    }

    public VectorTilesQuery strategy(TileStore.Strategy strategy) {
        this.strategy = Objects.requireNonNull(strategy);
        return this;
    }

    public TileStore.Strategy strategy() {
        return this.strategy;
    }

    public VectorTilesQuery extent(BoundingBox2D ... queryExtent) {
        return this.extent(Arrays.asList(queryExtent));
    }

    public VectorTilesQuery extent(List<BoundingBox2D> queryExtent) {
        this.queryExtent = List.copyOf(queryExtent);
        return this;
    }

    public List<BoundingBox2D> extent() {
        return this.queryExtent;
    }

    public VectorTilesQuery geometryFactory(GeometryFactory geometryFactory) {
        this.geometryFactory = geometryFactory;
        return this;
    }

    public Optional<GeometryFactory> geometryFactory() {
        return Optional.ofNullable(this.geometryFactory);
    }

    public VectorTilesQuery transformToCrs(boolean transformToCrs) {
        this.transformToCrs = transformToCrs;
        return this;
    }

    public boolean transformToCrs() {
        return this.transformToCrs;
    }

    public VectorTilesQuery filter(Predicate<VectorTile.Layer.Feature> filter) {
        this.filter = filter;
        return this;
    }

    public Optional<Predicate<VectorTile.Layer.Feature>> filter() {
        return Optional.ofNullable(this.filter);
    }

    public VectorTilesQuery geometryTransformation(UnaryOperator<Geometry> geometryOperation) {
        this.geometryOperation = geometryOperation;
        return this;
    }

    public Optional<UnaryOperator<Geometry>> geometryTransformation() {
        return Optional.ofNullable(this.geometryOperation);
    }
}

