/*
 * Decompiled with CFR 0.152.
 */
package io.tileverse.pmtiles.store;

import io.tileverse.jackson.databind.tilejson.v3.VectorLayer;
import io.tileverse.pmtiles.store.VectorTileReader;
import io.tileverse.pmtiles.store.VectorTilesQuery;
import io.tileverse.tiling.common.BoundingBox2D;
import io.tileverse.tiling.matrix.TileMatrixSet;
import io.tileverse.tiling.store.AbstractTileStore;
import io.tileverse.tiling.store.TileData;
import io.tileverse.tiling.store.TileStore;
import io.tileverse.vectortile.model.VectorTile;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;

public abstract class VectorTileStore
extends AbstractTileStore<VectorTile> {
    public VectorTileStore(TileMatrixSet matrixSet) {
        super(matrixSet);
    }

    public abstract List<VectorLayer> getVectorLayersMetadata();

    public Optional<VectorLayer> getLayerMetadata(String layerId) {
        return this.getVectorLayersMetadata().stream().filter(l -> layerId.equals(l.id())).findFirst();
    }

    public abstract BoundingBox2D getExtent();

    public Stream<VectorTile.Layer.Feature> getFeatures(VectorTilesQuery query) {
        Stream<TileData<VectorTile>> tilesInExtentAndZoomLevel = this.findTiles(query);
        Stream<VectorTileReader> tileReaders = tilesInExtentAndZoomLevel.map(tile -> new VectorTileReader((TileData<VectorTile>)tile, query));
        return tileReaders.flatMap(VectorTileReader::getFeatures);
    }

    protected Stream<TileData<VectorTile>> findTiles(VectorTilesQuery query) {
        int zoomLevel = this.determineZoomLevel(query);
        List<BoundingBox2D> queryExtent = query.extent();
        Stream matchingTiles = this.findTiles(queryExtent, zoomLevel);
        return matchingTiles;
    }

    protected int determineZoomLevel(VectorTilesQuery query) {
        if (query.zoomLevel().isPresent()) {
            return query.zoomLevel().getAsInt();
        }
        if (query.resolution().isPresent()) {
            return this.findBestZoomLevel(query.resolution().getAsDouble(), query.strategy());
        }
        if (query.strategy() == TileStore.Strategy.SPEED) {
            return this.matrixSet().minZoomLevel();
        }
        int maxMinZoom = this.getVectorLayersMetadata().stream().mapToInt(VectorLayer::minZoom).max().orElseGet(() -> ((TileMatrixSet)this.matrixSet()).minZoomLevel());
        return maxMinZoom;
    }
}

