/*
 * Decompiled with CFR 0.152.
 */
package io.tileverse.pmtiles.store;

import io.tileverse.pmtiles.store.VectorTileLayerReader;
import io.tileverse.pmtiles.store.VectorTilesQuery;
import io.tileverse.tiling.store.TileData;
import io.tileverse.vectortile.model.VectorTile;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;

record VectorTileReader(TileData<VectorTile> tileData, VectorTilesQuery query) {
    public Stream<VectorTile.Layer.Feature> getFeatures() {
        Stream<VectorTileLayerReader> layers = this.extractLayers(this.tileData, this.query);
        return layers.flatMap(VectorTileLayerReader::getFeatures);
    }

    private Stream<VectorTileLayerReader> extractLayers(TileData<VectorTile> vectortile, VectorTilesQuery query) {
        Stream<Object> layers;
        boolean allLayers = query.layers().isEmpty();
        VectorTile vectorTile = (VectorTile)vectortile.data();
        if (allLayers) {
            layers = vectorTile.getLayers().stream();
        } else {
            List<String> layerNames = query.layers().orElseThrow();
            layers = layerNames.stream().map(arg_0 -> ((VectorTile)vectorTile).getLayer(arg_0)).flatMap(Optional::stream);
        }
        return layers.map(layer -> new VectorTileLayerReader((VectorTile.Layer)layer, this.tileData, query));
    }
}

