/*
 * Decompiled with CFR 0.152.
 */
package io.tileverse.pmtiles.store;

import io.tileverse.pmtiles.store.VectorTilesQuery;
import io.tileverse.tiling.common.BoundingBox2D;
import io.tileverse.tiling.store.TileData;
import io.tileverse.vectortile.model.GeometryReader;
import io.tileverse.vectortile.model.VectorTile;
import io.tileverse.vectortile.mvt.VectorTileCodec;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import org.locationtech.jts.geom.CoordinateSequenceFilter;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.util.AffineTransformation;

record VectorTileLayerReader(VectorTile.Layer layer, TileData<VectorTile> tileData, VectorTilesQuery query) {
    public Stream<VectorTile.Layer.Feature> getFeatures() {
        if (this.layer.count() == 0) {
            return Stream.empty();
        }
        Predicate<VectorTile.Layer.Feature> filter = this.query.filter().orElse(f -> true);
        GeometryReader decoder = this.buildTileGeometryDecoder();
        Stream features = this.layer.getFeatures(filter, decoder);
        return features;
    }

    public GeometryReader buildTileGeometryDecoder() {
        GeometryFactory geometryFactory = this.query.geometryFactory().orElse(null);
        UnaryOperator<Geometry> transform = this.buildGeometryTransform();
        GeometryReader geometryReader = VectorTileCodec.newGeometryReader();
        if (geometryFactory != null) {
            geometryReader = geometryReader.withGeometryFactory(geometryFactory);
        }
        if (transform != null) {
            geometryReader = geometryReader.withGeometryTransformation(transform);
        }
        return geometryReader;
    }

    private UnaryOperator<Geometry> buildGeometryTransform() {
        UnaryOperator<Geometry> toCrs = this.transformToCrs();
        return this.query.geometryTransformation().map(post -> GeometryReader.concat((UnaryOperator[])new UnaryOperator[]{toCrs, post})).orElse(toCrs);
    }

    private UnaryOperator<Geometry> transformToCrs() {
        if (!this.query.transformToCrs()) {
            return UnaryOperator.identity();
        }
        BoundingBox2D nativeCrsExtent = this.tileData.tile().extent();
        int tileExtent = this.layer.getExtent();
        AffineTransformation at = VectorTileLayerReader.createTileToCrsTransformation(tileExtent, nativeCrsExtent);
        return GeometryReader.toFunction((CoordinateSequenceFilter)at);
    }

    public static AffineTransformation createTileToCrsTransformation(int tileExtent, BoundingBox2D tileEnvelope) {
        double scaleX = tileEnvelope.width() / (double)tileExtent;
        double scaleY = -1.0 * (tileEnvelope.height() / (double)tileExtent);
        double translateX = tileEnvelope.minX();
        double translateY = tileEnvelope.maxY();
        return AffineTransformation.scaleInstance((double)scaleX, (double)scaleY).translate(translateX, translateY);
    }
}

