/*
 * Decompiled with CFR 0.152.
 */
package io.tileverse.pmtiles.store;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import io.tileverse.jackson.databind.pmtiles.v3.PMTilesMetadata;
import io.tileverse.jackson.databind.tilejson.v3.VectorLayer;
import io.tileverse.pmtiles.PMTilesReader;
import io.tileverse.pmtiles.store.PMTilesTileMatrixSet;
import io.tileverse.pmtiles.store.VectorTileStore;
import io.tileverse.pmtiles.store.WebMercatorTransform;
import io.tileverse.tiling.common.BoundingBox2D;
import io.tileverse.tiling.matrix.Tile;
import io.tileverse.tiling.pyramid.TileIndex;
import io.tileverse.tiling.store.TileData;
import io.tileverse.vectortile.model.VectorTile;
import io.tileverse.vectortile.mvt.VectorTileCodec;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.locationtech.jts.geom.Envelope;

public class PMTilesVectorTileStore
extends VectorTileStore {
    private final PMTilesReader reader;
    private static final Duration expireAfterAccess = Duration.ofSeconds(10L);
    private final LoadingCache<TileIndex, Optional<VectorTile>> vectorTileCache;
    private final VectorTileCodec vectorTileDecoder = new VectorTileCodec();

    public PMTilesVectorTileStore(PMTilesReader reader) {
        super(PMTilesTileMatrixSet.fromWebMercator(reader));
        this.reader = Objects.requireNonNull(reader);
        this.vectorTileCache = Caffeine.newBuilder().softValues().expireAfterAccess(expireAfterAccess).build(this::loadVectorTile);
    }

    @Override
    public List<VectorLayer> getVectorLayersMetadata() {
        try {
            return this.getMetadata().vectorLayers();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public PMTilesMetadata getMetadata() throws IOException {
        return this.reader.getMetadata();
    }

    @Override
    public BoundingBox2D getExtent() {
        BoundingBox2D geographicBoundingBox = this.reader.getHeader().geographicBoundingBox();
        return WebMercatorTransform.latLonToWebMercator(geographicBoundingBox);
    }

    public Optional<TileData<VectorTile>> loadTile(Tile tile) {
        try {
            Optional<VectorTile> decoded = this.getVectorTile(tile);
            Envelope bounds = this.toEnvelope(tile.extent());
            decoded = decoded.map(vt -> vt.withBoundingBox(bounds));
            return decoded.map(vt -> new TileData(tile, vt));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private Optional<VectorTile> getVectorTile(Tile tile) throws IOException {
        TileIndex tileIndex = tile.tileIndex();
        return (Optional)this.vectorTileCache.get((Object)tileIndex);
    }

    private Optional<VectorTile> loadVectorTile(TileIndex tileIndex) throws IOException {
        return this.reader.getTile(tileIndex, this::decodeVectorTile);
    }

    private Envelope toEnvelope(BoundingBox2D extent) {
        return new Envelope(extent.minX(), extent.maxX(), extent.minY(), extent.maxY());
    }

    private VectorTile decodeVectorTile(ByteBuffer rawTile) {
        try {
            return this.vectorTileDecoder.decode(rawTile);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

