/*
 * Decompiled with CFR 0.152.
 */
package io.tileverse.pmtiles.store;

import io.tileverse.pmtiles.PMTilesHeader;
import io.tileverse.pmtiles.PMTilesReader;
import io.tileverse.pmtiles.store.WebMercatorTransform;
import io.tileverse.tiling.common.BoundingBox2D;
import io.tileverse.tiling.matrix.DefaultTileMatrixSets;
import io.tileverse.tiling.matrix.TileMatrixSet;

public class PMTilesTileMatrixSet {
    public static TileMatrixSet fromWebMercator(PMTilesReader pmtilesReader) {
        return PMTilesTileMatrixSet.fromWebMercator(pmtilesReader.getHeader());
    }

    public static TileMatrixSet fromWebMercator(PMTilesHeader pmtilesHeader) {
        BoundingBox2D webMercatorExtent = WebMercatorTransform.latLonToWebMercator(pmtilesHeader.geographicBoundingBox());
        TileMatrixSet baseTms = DefaultTileMatrixSets.WEB_MERCATOR_QUAD.toBuilder().zoomRange((int)pmtilesHeader.minZoom(), (int)pmtilesHeader.maxZoom()).build();
        return baseTms.intersection(webMercatorExtent).orElse(baseTms);
    }

    public static TileMatrixSet fromWebMercator512(PMTilesHeader pmtilesHeader) {
        BoundingBox2D webMercatorExtent = WebMercatorTransform.latLonToWebMercator(pmtilesHeader.geographicBoundingBox());
        TileMatrixSet baseTms = DefaultTileMatrixSets.WEB_MERCATOR_QUADx2.toBuilder().zoomRange((int)pmtilesHeader.minZoom(), (int)pmtilesHeader.maxZoom()).build();
        return baseTms.intersection(webMercatorExtent).orElse(baseTms);
    }

    public static TileMatrixSet fromCRS84(PMTilesHeader pmtilesHeader) {
        BoundingBox2D latLonExtent = pmtilesHeader.geographicBoundingBox();
        TileMatrixSet baseTms = DefaultTileMatrixSets.WORLD_CRS84_QUAD.toBuilder().zoomRange((int)pmtilesHeader.minZoom(), (int)pmtilesHeader.maxZoom()).build();
        return baseTms.intersection(latLonExtent).orElse(baseTms);
    }

    public static TileMatrixSet fromCRS84(PMTilesReader pmtilesReader) {
        return PMTilesTileMatrixSet.fromCRS84(pmtilesReader.getHeader());
    }
}

