/*
 * Decompiled with CFR 0.152.
 */
package io.tileverse.pmtiles;

import io.tileverse.io.ByteBufferPool;
import io.tileverse.io.ByteRange;
import io.tileverse.pmtiles.InvalidHeaderException;
import io.tileverse.pmtiles.PMTilesEntry;
import io.tileverse.tiling.common.BoundingBox2D;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public record PMTilesHeader(long rootDirOffset, long rootDirBytes, long jsonMetadataOffset, long jsonMetadataBytes, long leafDirsOffset, long leafDirsBytes, long tileDataOffset, long tileDataBytes, long addressedTilesCount, long tileEntriesCount, long tileContentsCount, boolean clustered, byte internalCompression, byte tileCompression, byte tileType, byte minZoom, byte maxZoom, int minLonE7, int minLatE7, int maxLonE7, int maxLatE7, byte centerZoom, int centerLonE7, int centerLatE7) {
    public static final byte COMPRESSION_UNKNOWN = 0;
    public static final byte COMPRESSION_NONE = 1;
    public static final byte COMPRESSION_GZIP = 2;
    public static final byte COMPRESSION_BROTLI = 3;
    public static final byte COMPRESSION_ZSTD = 4;
    public static final byte TILETYPE_UNKNOWN = 0;
    public static final byte TILETYPE_MVT = 1;
    public static final byte TILETYPE_PNG = 2;
    public static final byte TILETYPE_JPEG = 3;
    public static final byte TILETYPE_WEBP = 4;
    private static final byte[] MAGIC = "PMTiles".getBytes(StandardCharsets.UTF_8);
    public static final byte VERSION_3 = 3;
    private static final byte VERSION = 3;
    private static final int HEADER_SIZE = 127;

    public byte version() {
        return 3;
    }

    public double minLon() {
        return (double)this.minLonE7 / 1.0E7;
    }

    public double minLat() {
        return (double)this.minLatE7 / 1.0E7;
    }

    public double maxLon() {
        return (double)this.maxLonE7 / 1.0E7;
    }

    public double maxLat() {
        return (double)this.maxLatE7 / 1.0E7;
    }

    public double centerLon() {
        return (double)this.centerLonE7 / 1.0E7;
    }

    public double centerLat() {
        return (double)this.centerLatE7 / 1.0E7;
    }

    public BoundingBox2D geographicBoundingBox() {
        return BoundingBox2D.extent((double)this.minLon(), (double)this.minLat(), (double)this.maxLon(), (double)this.maxLat());
    }

    public byte[] serialize() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(127);
        out.write(MAGIC);
        out.write(3);
        ByteBuffer buffer = ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN);
        this.writeInt64(out, buffer, this.rootDirOffset);
        this.writeInt64(out, buffer, this.rootDirBytes);
        this.writeInt64(out, buffer, this.jsonMetadataOffset);
        this.writeInt64(out, buffer, this.jsonMetadataBytes);
        this.writeInt64(out, buffer, this.leafDirsOffset);
        this.writeInt64(out, buffer, this.leafDirsBytes);
        this.writeInt64(out, buffer, this.tileDataOffset);
        this.writeInt64(out, buffer, this.tileDataBytes);
        this.writeInt64(out, buffer, this.addressedTilesCount);
        this.writeInt64(out, buffer, this.tileEntriesCount);
        this.writeInt64(out, buffer, this.tileContentsCount);
        out.write(this.clustered ? 1 : 0);
        out.write(this.internalCompression);
        out.write(this.tileCompression);
        out.write(this.tileType);
        out.write(this.minZoom);
        out.write(this.maxZoom);
        this.writeInt32(out, buffer, this.minLonE7);
        this.writeInt32(out, buffer, this.minLatE7);
        this.writeInt32(out, buffer, this.maxLonE7);
        this.writeInt32(out, buffer, this.maxLatE7);
        out.write(this.centerZoom);
        this.writeInt32(out, buffer, this.centerLonE7);
        this.writeInt32(out, buffer, this.centerLatE7);
        return out.toByteArray();
    }

    private void writeInt64(ByteArrayOutputStream out, ByteBuffer buffer, long value) throws IOException {
        buffer.clear();
        buffer.putLong(value);
        out.write(buffer.array(), 0, 8);
    }

    private void writeInt32(ByteArrayOutputStream out, ByteBuffer buffer, int value) throws IOException {
        buffer.clear();
        buffer.putInt(value);
        out.write(buffer.array(), 0, 4);
    }

    public static PMTilesHeader deserialize(ByteBuffer buffer) throws InvalidHeaderException {
        if (buffer.remaining() != 127) {
            throw new InvalidHeaderException("Header must be exactly 127 bytes");
        }
        int originalPosition = buffer.position();
        byte[] magic = new byte[7];
        buffer.get(magic);
        if (!Arrays.equals(magic, MAGIC)) {
            throw new InvalidHeaderException("Invalid magic number");
        }
        byte version = buffer.get();
        if (version != 3) {
            throw new InvalidHeaderException("Unsupported version: " + version);
        }
        ByteBuffer dup = buffer.duplicate().order(ByteOrder.LITTLE_ENDIAN);
        dup.position(originalPosition + 8);
        return new PMTilesHeader(dup.getLong(), dup.getLong(), dup.getLong(), dup.getLong(), dup.getLong(), dup.getLong(), dup.getLong(), dup.getLong(), dup.getLong(), dup.getLong(), dup.getLong(), dup.get() == 1, dup.get(), dup.get(), dup.get(), dup.get(), dup.get(), dup.getInt(), dup.getInt(), dup.getInt(), dup.getInt(), dup.get(), dup.getInt(), dup.getInt());
    }

    public static PMTilesHeader deserialize(byte[] bytes) throws InvalidHeaderException {
        if (bytes.length != 127) {
            throw new InvalidHeaderException("Header must be exactly 127 bytes");
        }
        return PMTilesHeader.deserialize(ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN));
    }

    public static Builder builder() {
        return new Builder();
    }

    ByteRange leafDirDataRange(PMTilesEntry dirEntry) {
        long offset = this.leafDirsOffset() + dirEntry.offset();
        int length = dirEntry.length();
        return ByteRange.of((long)offset, (int)length);
    }

    ByteRange tileDataRange(PMTilesEntry tileEntry) {
        long offset = this.tileDataOffset() + tileEntry.offset();
        int length = tileEntry.length();
        return ByteRange.of((long)offset, (int)length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static PMTilesHeader readHeader(ReadableByteChannel channel) throws IOException, InvalidHeaderException {
        ByteBuffer headerBuffer = ByteBufferPool.getDefault().borrowHeap(127);
        try {
            int bytesRead = channel.read(headerBuffer);
            if (bytesRead != 127) {
                throw new InvalidHeaderException("Failed to read complete header. Read " + bytesRead + " bytes");
            }
            headerBuffer.flip();
            PMTilesHeader pMTilesHeader = PMTilesHeader.deserialize(headerBuffer);
            return pMTilesHeader;
        }
        finally {
            ByteBufferPool.getDefault().returnBuffer(headerBuffer);
        }
    }

    public static class Builder {
        private long rootDirOffset = 127L;
        private long rootDirBytes = 0L;
        private long jsonMetadataOffset = 0L;
        private long jsonMetadataBytes = 0L;
        private long leafDirsOffset = 0L;
        private long leafDirsBytes = 0L;
        private long tileDataOffset = 0L;
        private long tileDataBytes = 0L;
        private long addressedTilesCount = 0L;
        private long tileEntriesCount = 0L;
        private long tileContentsCount = 0L;
        private boolean clustered = false;
        private byte internalCompression = (byte)2;
        private byte tileCompression = (byte)2;
        private byte tileType = 1;
        private byte minZoom = 0;
        private byte maxZoom = 0;
        private int minLonE7 = -1800000000;
        private int minLatE7 = -850000000;
        private int maxLonE7 = 1800000000;
        private int maxLatE7 = 850000000;
        private byte centerZoom = 0;
        private int centerLonE7 = 0;
        private int centerLatE7 = 0;

        public Builder rootDirOffset(long rootDirOffset) {
            this.rootDirOffset = rootDirOffset;
            return this;
        }

        public Builder rootDirBytes(long rootDirBytes) {
            this.rootDirBytes = rootDirBytes;
            return this;
        }

        public Builder jsonMetadataOffset(long jsonMetadataOffset) {
            this.jsonMetadataOffset = jsonMetadataOffset;
            return this;
        }

        public Builder jsonMetadataBytes(long jsonMetadataBytes) {
            this.jsonMetadataBytes = jsonMetadataBytes;
            return this;
        }

        public Builder leafDirsOffset(long leafDirsOffset) {
            this.leafDirsOffset = leafDirsOffset;
            return this;
        }

        public Builder leafDirsBytes(long leafDirsBytes) {
            this.leafDirsBytes = leafDirsBytes;
            return this;
        }

        public Builder tileDataOffset(long tileDataOffset) {
            this.tileDataOffset = tileDataOffset;
            return this;
        }

        public Builder tileDataBytes(long tileDataBytes) {
            this.tileDataBytes = tileDataBytes;
            return this;
        }

        public Builder addressedTilesCount(long addressedTilesCount) {
            this.addressedTilesCount = addressedTilesCount;
            return this;
        }

        public Builder tileEntriesCount(long tileEntriesCount) {
            this.tileEntriesCount = tileEntriesCount;
            return this;
        }

        public Builder tileContentsCount(long tileContentsCount) {
            this.tileContentsCount = tileContentsCount;
            return this;
        }

        public Builder clustered(boolean clustered) {
            this.clustered = clustered;
            return this;
        }

        public Builder internalCompression(byte internalCompression) {
            this.internalCompression = internalCompression;
            return this;
        }

        public Builder tileCompression(byte tileCompression) {
            this.tileCompression = tileCompression;
            return this;
        }

        public Builder tileType(byte tileType) {
            this.tileType = tileType;
            return this;
        }

        public Builder minZoom(byte minZoom) {
            this.minZoom = minZoom;
            return this;
        }

        public Builder maxZoom(byte maxZoom) {
            this.maxZoom = maxZoom;
            return this;
        }

        public Builder minLonE7(int minLonE7) {
            this.minLonE7 = minLonE7;
            return this;
        }

        public Builder minLatE7(int minLatE7) {
            this.minLatE7 = minLatE7;
            return this;
        }

        public Builder maxLonE7(int maxLonE7) {
            this.maxLonE7 = maxLonE7;
            return this;
        }

        public Builder maxLatE7(int maxLatE7) {
            this.maxLatE7 = maxLatE7;
            return this;
        }

        public Builder centerZoom(byte centerZoom) {
            this.centerZoom = centerZoom;
            return this;
        }

        public Builder centerLonE7(int centerLonE7) {
            this.centerLonE7 = centerLonE7;
            return this;
        }

        public Builder centerLatE7(int centerLatE7) {
            this.centerLatE7 = centerLatE7;
            return this;
        }

        public Builder minLon(double minLon) {
            this.minLonE7 = (int)(minLon * 1.0E7);
            return this;
        }

        public Builder minLat(double minLat) {
            this.minLatE7 = (int)(minLat * 1.0E7);
            return this;
        }

        public Builder maxLon(double maxLon) {
            this.maxLonE7 = (int)(maxLon * 1.0E7);
            return this;
        }

        public Builder maxLat(double maxLat) {
            this.maxLatE7 = (int)(maxLat * 1.0E7);
            return this;
        }

        public Builder centerLon(double centerLon) {
            this.centerLonE7 = (int)(centerLon * 1.0E7);
            return this;
        }

        public Builder centerLat(double centerLat) {
            this.centerLatE7 = (int)(centerLat * 1.0E7);
            return this;
        }

        public PMTilesHeader build() {
            return new PMTilesHeader(this.rootDirOffset, this.rootDirBytes, this.jsonMetadataOffset, this.jsonMetadataBytes, this.leafDirsOffset, this.leafDirsBytes, this.tileDataOffset, this.tileDataBytes, this.addressedTilesCount, this.tileEntriesCount, this.tileContentsCount, this.clustered, this.internalCompression, this.tileCompression, this.tileType, this.minZoom, this.maxZoom, this.minLonE7, this.minLatE7, this.maxLonE7, this.maxLatE7, this.centerZoom, this.centerLonE7, this.centerLatE7);
        }
    }
}

