/*
 * Decompiled with CFR 0.152.
 */
package io.tileverse.pmtiles;

import java.nio.ByteBuffer;

public record PMTilesEntry(long tileId, long offset, int length, int runLength) implements Comparable<PMTilesEntry>
{
    static final int SERIALIZED_SIZE = 24;

    static void setId(ByteBuffer entry, long tileId) {
        entry.putLong(0, tileId);
    }

    static long getId(ByteBuffer entry) {
        return entry.getLong(0);
    }

    static void setOffset(ByteBuffer entry, long tileId) {
        entry.putLong(8, tileId);
    }

    static long getOffset(ByteBuffer entry) {
        return entry.getLong(8);
    }

    static void setLength(ByteBuffer entry, int length) {
        entry.putInt(16, length);
    }

    static int getLength(ByteBuffer entry) {
        return entry.getInt(16);
    }

    static void setRunLength(ByteBuffer entry, int runLength) {
        entry.putInt(20, runLength);
    }

    static int getRunLength(ByteBuffer entry) {
        return entry.getInt(20);
    }

    public static PMTilesEntry of(long tileId, long offset, int length) {
        return new PMTilesEntry(tileId, offset, length, 1);
    }

    public static PMTilesEntry of(long tileId, long offset, int length, int runLength) {
        return new PMTilesEntry(tileId, offset, length, runLength);
    }

    public static PMTilesEntry leaf(long tileId, long offset, int length) {
        return new PMTilesEntry(tileId, offset, length, 0);
    }

    public boolean isLeaf() {
        return this.runLength == 0;
    }

    public boolean isEmpty() {
        return this.length == 0;
    }

    @Override
    public int compareTo(PMTilesEntry other) {
        return Long.compare(this.tileId, other.tileId);
    }
}

