/*
 * Decompiled with CFR 0.152.
 */
package io.tileverse.pmtiles;

import io.tileverse.pmtiles.PMTilesEntry;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

class PMTilesDirectory
implements Iterable<PMTilesEntry> {
    private final int size;
    private final ByteBuffer unpacked;

    PMTilesDirectory(int size, ByteBuffer unpackedEntries) {
        this.size = size;
        this.unpacked = unpackedEntries;
    }

    static Builder builder(int numEntries) {
        return new Builder(numEntries);
    }

    public int size() {
        return this.size;
    }

    public PMTilesEntry get(int index) {
        ByteBuffer entry = PMTilesDirectory.entry(this.unpacked, index);
        long tileId = PMTilesEntry.getId(entry);
        long offset = PMTilesEntry.getOffset(entry);
        int length = PMTilesEntry.getLength(entry);
        int runLength = PMTilesEntry.getRunLength(entry);
        return new PMTilesEntry(tileId, offset, length, runLength);
    }

    @Override
    public Iterator<PMTilesEntry> iterator() {
        return IntStream.range(0, this.size).mapToObj(this::get).iterator();
    }

    public String toString() {
        String ids = IntStream.range(0, Math.min(this.size, 10)).mapToObj(i -> PMTilesDirectory.entry(this.unpacked, i)).mapToLong(PMTilesEntry::getId).mapToObj(String::valueOf).collect(Collectors.joining(","));
        return "%s[size: %,d, unpacked size: %,d, tileIds: %s]".formatted(this.getClass().getSimpleName(), this.size, this.unpacked.capacity(), ids);
    }

    static ByteBuffer entry(ByteBuffer unpacked, int index) {
        int len = 24;
        int offset = len * index;
        return unpacked.slice(offset, len);
    }

    static class Builder {
        private final int numEntries;
        private final ByteBuffer unpacked;

        public Builder(int numEntries) {
            this.numEntries = numEntries;
            this.unpacked = ByteBuffer.allocate(numEntries * 24);
        }

        public Builder tileId(int index, long tileId) {
            ByteBuffer entry = PMTilesDirectory.entry(this.unpacked, index);
            PMTilesEntry.setId(entry, tileId);
            return this;
        }

        public Builder runLength(int index, int runLength) {
            ByteBuffer entry = PMTilesDirectory.entry(this.unpacked, index);
            PMTilesEntry.setRunLength(entry, runLength);
            return this;
        }

        public Builder offset(int index, long offset) {
            ByteBuffer entry = PMTilesDirectory.entry(this.unpacked, index);
            PMTilesEntry.setOffset(entry, offset);
            return this;
        }

        public Builder length(int index, int length) {
            ByteBuffer entry = PMTilesDirectory.entry(this.unpacked, index);
            PMTilesEntry.setLength(entry, length);
            return this;
        }

        public long getOffset(int index) {
            ByteBuffer entry = PMTilesDirectory.entry(this.unpacked, index);
            return PMTilesEntry.getOffset(entry);
        }

        public int getLength(int index) {
            ByteBuffer entry = PMTilesDirectory.entry(this.unpacked, index);
            return PMTilesEntry.getLength(entry);
        }

        public PMTilesDirectory build() {
            return new PMTilesDirectory(this.numEntries, this.unpacked);
        }
    }
}

