/*
 * Decompiled with CFR 0.152.
 */
package io.tileverse.pmtiles;

import io.tileverse.tiling.pyramid.TileIndex;

class HilbertCurve {
    private static final long[] TZ_VALUES = new long[]{0L, 1L, 5L, 21L, 85L, 341L, 1365L, 5461L, 21845L, 87381L, 349525L, 0x155555L, 0x555555L, 0x1555555L, 0x5555555L, 0x15555555L, 0x55555555L, 0x155555555L, 0x555555555L, 0x1555555555L, 0x5555555555L, 0x15555555555L, 0x55555555555L, 0x155555555555L, 0x555555555555L, 0x1555555555555L, 0x5555555555555L};

    private HilbertCurve() {
    }

    public static long tileIndexToTileId(TileIndex tileIndex) {
        return HilbertCurve.zxyToTileId(tileIndex.z(), tileIndex.x(), tileIndex.y());
    }

    public static TileIndex tileIdToTileIndex(long tileId) {
        long[] zxy = HilbertCurve.tileIdToZxy(tileId);
        return TileIndex.xyz((long)zxy[1], (long)zxy[2], (int)((int)zxy[0]));
    }

    public static long zxyToTileId(int z, long x, long y) {
        if (z > 26) {
            throw new IllegalArgumentException("Tile zoom level exceeds max safe number limit (26)");
        }
        if ((double)x > Math.pow(2.0, z) - 1.0 || (double)y > Math.pow(2.0, z) - 1.0) {
            throw new IllegalArgumentException("tile x/y outside zoom level bounds");
        }
        long acc = TZ_VALUES[z];
        long n = 1L << z;
        long d = 0L;
        long[] xy = new long[]{x, y};
        for (long s = n / 2L; s > 0L; s /= 2L) {
            long rx = (xy[0] & s) > 0L ? 1L : 0L;
            long ry = (xy[1] & s) > 0L ? 1L : 0L;
            d += s * s * (3L * rx ^ ry);
            HilbertCurve.rotate(s, xy, rx, ry);
        }
        return acc + d;
    }

    public static long[] tileIdToZxy(long tileId) {
        if (tileId < 0L) {
            throw new IllegalArgumentException("Tile ID cannot be negative: " + tileId);
        }
        long acc = 0L;
        for (int z = 0; z < 27; ++z) {
            long numTiles = (1L << z) * (1L << z);
            if (acc + numTiles > tileId) {
                return HilbertCurve.idOnLevel(z, tileId - acc);
            }
            acc += numTiles;
        }
        throw new IllegalArgumentException("Tile zoom level exceeds max safe number limit (26)");
    }

    private static long[] idOnLevel(int z, long pos) {
        long n = 1L << z;
        long t = pos;
        long[] xy = new long[]{0L, 0L};
        for (long s = 1L; s < n; s *= 2L) {
            long rx = 1L & t / 2L;
            long ry = 1L & (t ^ rx);
            HilbertCurve.rotate(s, xy, rx, ry);
            xy[0] = xy[0] + s * rx;
            xy[1] = xy[1] + s * ry;
            t /= 4L;
        }
        return new long[]{z, xy[0], xy[1]};
    }

    private static void rotate(long n, long[] xy, long rx, long ry) {
        if (ry == 0L) {
            if (rx == 1L) {
                xy[0] = n - 1L - xy[0];
                xy[1] = n - 1L - xy[1];
            }
            long t = xy[0];
            xy[0] = xy[1];
            xy[1] = t;
        }
    }
}

