/*
 * Decompiled with CFR 0.152.
 */
package io.tileverse.pmtiles;

import io.tileverse.pmtiles.CompressionUtil;
import io.tileverse.pmtiles.PMTilesDirectory;
import io.tileverse.pmtiles.PMTilesEntry;
import io.tileverse.pmtiles.UnsupportedCompressionException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

final class DirectoryUtil {
    private DirectoryUtil() {
    }

    public static byte[] serializeDirectory(List<PMTilesEntry> entries) throws IOException {
        ArrayList<PMTilesEntry> sortedEntries = new ArrayList<PMTilesEntry>(entries);
        Collections.sort(sortedEntries);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DirectoryUtil.writeVarint(baos, entries.size());
        long lastId = 0L;
        for (PMTilesEntry entry : sortedEntries) {
            DirectoryUtil.writeVarint(baos, entry.tileId() - lastId);
            lastId = entry.tileId();
        }
        for (PMTilesEntry entry : sortedEntries) {
            DirectoryUtil.writeVarint(baos, entry.runLength());
        }
        for (PMTilesEntry entry : sortedEntries) {
            DirectoryUtil.writeVarint(baos, entry.length());
        }
        for (int i = 0; i < sortedEntries.size(); ++i) {
            if (i > 0 && ((PMTilesEntry)sortedEntries.get(i)).offset() == ((PMTilesEntry)sortedEntries.get(i - 1)).offset() + (long)((PMTilesEntry)sortedEntries.get(i - 1)).length()) {
                DirectoryUtil.writeVarint(baos, 0L);
                continue;
            }
            DirectoryUtil.writeVarint(baos, ((PMTilesEntry)sortedEntries.get(i)).offset() + 1L);
        }
        return baos.toByteArray();
    }

    public static PMTilesDirectory deserializeDirectory(ByteBuffer buffer) throws IOException {
        int i;
        int numEntries = (int)DirectoryUtil.readVarint(buffer);
        PMTilesDirectory.Builder builder = PMTilesDirectory.builder(numEntries);
        long lastId = 0L;
        for (i = 0; i < numEntries; ++i) {
            long tileId;
            lastId = tileId = lastId + DirectoryUtil.readVarint(buffer);
            builder.tileId(i, tileId);
        }
        for (i = 0; i < numEntries; ++i) {
            int runLength = (int)DirectoryUtil.readVarint(buffer);
            builder.runLength(i, runLength);
        }
        for (i = 0; i < numEntries; ++i) {
            int length = (int)DirectoryUtil.readVarint(buffer);
            builder.length(i, length);
        }
        for (i = 0; i < numEntries; ++i) {
            long offset;
            long tmp = DirectoryUtil.readVarint(buffer);
            if (i > 0 && tmp == 0L) {
                long previousOffset = builder.getOffset(i - 1);
                int previousLength = builder.getLength(i - 1);
                offset = previousOffset + (long)previousLength;
            } else {
                offset = tmp - 1L;
            }
            builder.offset(i, offset);
        }
        if (buffer.hasRemaining()) {
            throw new IOException("Malformed PMTiles directory: additional data at end of buffer");
        }
        return builder.build();
    }

    public static DirectoryResult buildRootLeaves(List<PMTilesEntry> entries, byte compressionType, int maxRootDirSize) throws IOException, UnsupportedCompressionException {
        byte[] uncompressedDir = DirectoryUtil.serializeDirectory(entries);
        byte[] compressedDir = CompressionUtil.compress(uncompressedDir, compressionType);
        if (compressedDir.length <= maxRootDirSize) {
            return new DirectoryResult(compressedDir, new byte[0], 0);
        }
        int leafSize = 4096;
        DirectoryResult result;
        while ((result = DirectoryUtil.buildRootLeavesWithSize(entries, compressionType, leafSize)).rootDirectory().length > maxRootDirSize) {
            leafSize *= 2;
        }
        return result;
    }

    private static DirectoryResult buildRootLeavesWithSize(List<PMTilesEntry> entries, byte compressionType, int leafSize) throws IOException, UnsupportedCompressionException {
        ArrayList<PMTilesEntry> rootEntries = new ArrayList<PMTilesEntry>();
        ByteArrayOutputStream leafDirsStream = new ByteArrayOutputStream();
        int numLeaves = 0;
        for (int i = 0; i < entries.size(); i += leafSize) {
            ++numLeaves;
            int end = Math.min(i + leafSize, entries.size());
            List<PMTilesEntry> subentries = entries.subList(i, end);
            byte[] uncompressedLeaf = DirectoryUtil.serializeDirectory(subentries);
            byte[] compressedLeaf = CompressionUtil.compress(uncompressedLeaf, compressionType);
            rootEntries.add(PMTilesEntry.leaf(subentries.get(0).tileId(), leafDirsStream.size(), compressedLeaf.length));
            leafDirsStream.write(compressedLeaf);
        }
        byte[] uncompressedRoot = DirectoryUtil.serializeDirectory(rootEntries);
        byte[] compressedRoot = CompressionUtil.compress(uncompressedRoot, compressionType);
        byte[] leafDirs = leafDirsStream.toByteArray();
        return new DirectoryResult(compressedRoot, leafDirs, numLeaves);
    }

    private static void writeVarint(ByteArrayOutputStream out, long value) throws IOException {
        while (value >= 128L) {
            out.write((int)(value & 0x7FL | 0x80L));
            value >>>= 7;
        }
        out.write((int)value);
    }

    private static long readVarint(ByteBuffer buffer) throws IOException {
        byte b;
        long value = 0L;
        int shift = 0;
        do {
            if (!buffer.hasRemaining()) {
                throw new IOException("Unexpected end of buffer while reading varint");
            }
            if (shift >= 64) {
                throw new IOException("Varint too long");
            }
            b = buffer.get();
            value |= (long)(b & 0x7F) << shift;
            shift += 7;
        } while ((b & 0x80) != 0);
        return value;
    }

    public record DirectoryResult(byte[] rootDirectory, byte[] leafDirectories, int numLeaves) {
    }
}

