/*
 * Decompiled with CFR 0.152.
 */
package io.tileverse.pmtiles;

import io.tileverse.pmtiles.UnsupportedCompressionException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.compressors.brotli.BrotliCompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.apache.commons.compress.compressors.zstandard.ZstdCompressorInputStream;
import org.apache.commons.compress.compressors.zstandard.ZstdCompressorOutputStream;
import org.apache.commons.io.IOUtils;

public final class CompressionUtil {
    private CompressionUtil() {
    }

    public static byte[] compress(byte[] data, byte compressionType) throws IOException, UnsupportedCompressionException {
        if (compressionType == 1) {
            return data;
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try (OutputStream compressor = CompressionUtil.createCompressor(outputStream, compressionType);){
            compressor.write(data);
            compressor.flush();
        }
        return outputStream.toByteArray();
    }

    public static ByteBuffer decompress(ByteBuffer buffer, byte compression) throws UnsupportedCompressionException, IOException {
        int compressedLength = buffer.remaining();
        if (buffer.hasArray() && compression != 1) {
            int offset = buffer.position();
            byte[] compressed = buffer.array();
            return CompressionUtil.decompress(compressed, offset, compressedLength, compression);
        }
        byte[] compressed = new byte[compressedLength];
        buffer.get(compressed);
        return CompressionUtil.decompress(compressed, 0, compressedLength, compression);
    }

    public static ByteBuffer decompress(byte[] data, int offset, int length, byte compressionType) throws IOException, UnsupportedCompressionException {
        if (compressionType == 1) {
            return ByteBuffer.wrap(data, offset, length);
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(data, offset, length);
        ByteArrayOutputStreamInternal outputStream = new ByteArrayOutputStreamInternal(4 * length);
        try (InputStream decompressor = CompressionUtil.createDecompressor(inputStream, compressionType);){
            IOUtils.copy((InputStream)decompressor, (OutputStream)outputStream);
        }
        catch (CompressorException e) {
            throw new IOException("Failed to create decompressor", e);
        }
        return ByteBuffer.wrap(outputStream.bytes()).limit(outputStream.size());
    }

    private static OutputStream createCompressor(OutputStream outputStream, byte compressionType) throws IOException, UnsupportedCompressionException {
        return switch (compressionType) {
            case 1 -> outputStream;
            case 2 -> new GzipCompressorOutputStream(outputStream);
            case 4 -> new ZstdCompressorOutputStream(outputStream);
            case 3 -> throw new UnsupportedCompressionException("Compression type not supported: " + compressionType);
            default -> throw new UnsupportedCompressionException("Compression type not supported: " + compressionType);
        };
    }

    private static InputStream createDecompressor(InputStream inputStream, byte compressionType) throws IOException, CompressorException, UnsupportedCompressionException {
        return switch (compressionType) {
            case 1 -> throw new IllegalArgumentException("Cannot create decompressor for COMPRESSION_NONE");
            case 2 -> new GzipCompressorInputStream(inputStream);
            case 4 -> new ZstdCompressorInputStream(inputStream);
            case 3 -> new BrotliCompressorInputStream(inputStream);
            default -> throw new UnsupportedCompressionException("Compression type not supported: " + compressionType);
        };
    }

    private static class ByteArrayOutputStreamInternal
    extends ByteArrayOutputStream {
        ByteArrayOutputStreamInternal(int initialSize) {
            super(initialSize);
        }

        public byte[] bytes() {
            return this.buf;
        }
    }
}

