/*
 * Decompiled with CFR 0.152.
 */
package io.tileverse.pmtiles;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.InvalidMarkException;

final class ByteBufferInputStream
extends InputStream {
    private final int size;
    private ByteBuffer byteBuffer;

    public ByteBufferInputStream(int size, ByteBuffer byteBuffer) {
        if (size < 0) {
            throw new IllegalArgumentException("Size cannot be negative: " + size);
        }
        if (byteBuffer == null) {
            throw new IllegalArgumentException("ByteBuffer cannot be null");
        }
        this.size = size;
        this.byteBuffer = byteBuffer;
    }

    public ByteBufferInputStream(ByteBuffer byteBuffer) {
        this(byteBuffer != null ? byteBuffer.remaining() : 0, byteBuffer);
    }

    @Override
    public synchronized void close() {
        this.byteBuffer = null;
    }

    public synchronized boolean isOpen() {
        return this.byteBuffer != null;
    }

    private void verifyOpen() throws IOException {
        if (this.byteBuffer == null) {
            throw new IOException("Stream is closed");
        }
    }

    private void checkIsOpen() {
        if (!this.isOpen()) {
            throw new IllegalStateException("Stream is closed");
        }
    }

    @Override
    public synchronized int read() throws IOException {
        if (this.available() > 0) {
            return this.byteBuffer.get() & 0xFF;
        }
        return -1;
    }

    @Override
    public synchronized long skip(long offset) throws IOException {
        this.verifyOpen();
        long newPos = (long)this.position() + offset;
        if (newPos < 0L) {
            throw new EOFException("Cannot seek to negative position: " + newPos);
        }
        if (newPos > (long)this.size) {
            throw new EOFException("Cannot seek past end of buffer: " + newPos + " > " + this.size);
        }
        this.byteBuffer.position((int)newPos);
        return offset;
    }

    @Override
    public synchronized int available() {
        this.checkIsOpen();
        return this.byteBuffer.remaining();
    }

    public synchronized int position() {
        this.checkIsOpen();
        return this.byteBuffer.position();
    }

    public synchronized boolean hasRemaining() {
        this.checkIsOpen();
        return this.byteBuffer.hasRemaining();
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.checkIsOpen();
        this.byteBuffer.mark();
    }

    @Override
    public synchronized void reset() throws IOException {
        this.checkIsOpen();
        try {
            this.byteBuffer.reset();
        }
        catch (InvalidMarkException e) {
            throw new IOException("Invalid mark", e);
        }
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public synchronized int read(byte[] b, int offset, int length) throws IOException {
        if (length < 0) {
            throw new IllegalArgumentException("Length cannot be negative: " + length);
        }
        if (b == null) {
            throw new IllegalArgumentException("Destination buffer cannot be null");
        }
        if (offset < 0 || offset > b.length) {
            throw new IndexOutOfBoundsException("Offset out of bounds: " + offset);
        }
        if (b.length - offset < length) {
            throw new IndexOutOfBoundsException("Not enough space in destination buffer: request length=" + length + ", with offset=" + offset + "; buffer capacity=" + (b.length - offset));
        }
        this.verifyOpen();
        if (!this.hasRemaining()) {
            return -1;
        }
        int toRead = Math.min(length, this.available());
        this.byteBuffer.get(b, offset, toRead);
        return toRead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        ByteBufferInputStream byteBufferInputStream = this;
        synchronized (byteBufferInputStream) {
            return "ByteBufferInputStream{size=" + this.size + ", byteBuffer=" + String.valueOf(this.byteBuffer) + (String)(this.byteBuffer != null ? ", available=" + this.byteBuffer.remaining() : "") + "} " + super.toString();
        }
    }
}

