/*
 * Decompiled with CFR 0.152.
 */
package io.tileverse.jackson.databind.tilejson.v3;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public record VectorLayer(@JsonProperty(value="id") String id, @JsonProperty(value="fields") Map<String, String> fields, @JsonProperty(value="description") String description, @JsonProperty(value="minzoom") Integer minZoom, @JsonProperty(value="maxzoom") Integer maxZoom) {
    public static VectorLayer of(String id, Map<String, String> fields) {
        if (id == null || id.isBlank()) {
            throw new IllegalArgumentException("Layer id is required and cannot be null or blank");
        }
        if (fields == null) {
            throw new IllegalArgumentException("Fields map is required and cannot be null");
        }
        return new VectorLayer(id, fields, null, null, null);
    }

    public static VectorLayer of(String id, Map<String, String> fields, String description) {
        if (id == null || id.isBlank()) {
            throw new IllegalArgumentException("Layer id is required and cannot be null or blank");
        }
        if (fields == null) {
            throw new IllegalArgumentException("Fields map is required and cannot be null");
        }
        return new VectorLayer(id, fields, description, null, null);
    }

    public static VectorLayer of(String id, Map<String, String> fields, String description, Integer minZoom, Integer maxZoom) {
        if (id == null || id.isBlank()) {
            throw new IllegalArgumentException("Layer id is required and cannot be null or blank");
        }
        if (fields == null) {
            throw new IllegalArgumentException("Fields map is required and cannot be null");
        }
        VectorLayer.validateZoomLevel(minZoom, "minZoom");
        VectorLayer.validateZoomLevel(maxZoom, "maxZoom");
        if (minZoom != null && maxZoom != null && minZoom > maxZoom) {
            throw new IllegalArgumentException("minZoom cannot be greater than maxZoom");
        }
        return new VectorLayer(id, fields, description, minZoom, maxZoom);
    }

    public VectorLayer withDescription(String description) {
        return new VectorLayer(this.id, this.fields, description, this.minZoom, this.maxZoom);
    }

    public VectorLayer withZoomRange(Integer minZoom, Integer maxZoom) {
        VectorLayer.validateZoomLevel(minZoom, "minZoom");
        VectorLayer.validateZoomLevel(maxZoom, "maxZoom");
        if (minZoom != null && maxZoom != null && minZoom > maxZoom) {
            throw new IllegalArgumentException("minZoom cannot be greater than maxZoom");
        }
        return new VectorLayer(this.id, this.fields, this.description, minZoom, maxZoom);
    }

    public VectorLayer withFields(Map<String, String> fields) {
        if (fields == null) {
            throw new IllegalArgumentException("Fields map is required and cannot be null");
        }
        return new VectorLayer(this.id, fields, this.description, this.minZoom, this.maxZoom);
    }

    private static void validateZoomLevel(Integer zoom, String fieldName) {
        if (zoom != null && (zoom < 0 || zoom > 30)) {
            throw new IllegalArgumentException(fieldName + " must be between 0 and 30, got: " + zoom);
        }
    }
}

