/*
 * Decompiled with CFR 0.152.
 */
package io.tileverse.jackson.databind.tilejson.v3;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum TilesetType {
    BASELAYER("baselayer"),
    OVERLAY("overlay");

    private final String value;

    private TilesetType(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    @JsonCreator
    public static TilesetType fromValue(String value) {
        if (value == null) {
            return null;
        }
        String normalized = value.toLowerCase().trim();
        for (TilesetType type : TilesetType.values()) {
            if (!type.value.equals(normalized)) continue;
            return type;
        }
        return null;
    }

    public String toString() {
        return this.value;
    }
}

