/*
 * Decompiled with CFR 0.152.
 */
package io.tileverse.jackson.databind.tilejson.v3;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.tileverse.jackson.databind.tilejson.v3.VectorLayer;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public record TileJSON(@JsonProperty(value="tilejson") String tilejson, @JsonProperty(value="tiles") List<String> tiles, @JsonProperty(value="vector_layers") List<VectorLayer> vectorLayers, @JsonProperty(value="attribution") String attribution, @JsonProperty(value="bounds") List<Double> bounds, @JsonProperty(value="center") List<Double> center, @JsonProperty(value="description") String description, @JsonProperty(value="fillzoom") Integer fillzoom, @JsonProperty(value="grids") List<String> grids, @JsonProperty(value="legend") String legend, @JsonProperty(value="maxzoom") Integer maxzoom, @JsonProperty(value="minzoom") Integer minzoom, @JsonProperty(value="name") String name, @JsonProperty(value="scheme") String scheme, @JsonProperty(value="template") String template, @JsonProperty(value="version") String version) {
    public static TileJSON of(String tilejson, List<String> tiles, List<VectorLayer> vectorLayers) {
        TileJSON.validateRequired(tilejson, tiles, vectorLayers);
        return new TileJSON(tilejson, tiles, vectorLayers, null, null, null, null, null, null, null, null, null, null, null, null, null);
    }

    public static TileJSON of(String tilejson, List<String> tiles, List<VectorLayer> vectorLayers, String name, String description, String attribution) {
        TileJSON.validateRequired(tilejson, tiles, vectorLayers);
        return new TileJSON(tilejson, tiles, vectorLayers, attribution, null, null, description, null, null, null, null, null, name, null, null, null);
    }

    public TileJSON withAttribution(String attribution) {
        return new TileJSON(this.tilejson, this.tiles, this.vectorLayers, attribution, this.bounds, this.center, this.description, this.fillzoom, this.grids, this.legend, this.maxzoom, this.minzoom, this.name, this.scheme, this.template, this.version);
    }

    public TileJSON withBounds(double west, double south, double east, double north) {
        if (west >= east) {
            throw new IllegalArgumentException("West bound must be less than east bound");
        }
        if (south >= north) {
            throw new IllegalArgumentException("South bound must be less than north bound");
        }
        if (west < -180.0 || east > 180.0 || south < -90.0 || north > 90.0) {
            throw new IllegalArgumentException("Bounds must be within valid longitude/latitude ranges");
        }
        List<Double> boundsCoords = List.of(Double.valueOf(west), Double.valueOf(south), Double.valueOf(east), Double.valueOf(north));
        return new TileJSON(this.tilejson, this.tiles, this.vectorLayers, this.attribution, boundsCoords, this.center, this.description, this.fillzoom, this.grids, this.legend, this.maxzoom, this.minzoom, this.name, this.scheme, this.template, this.version);
    }

    public TileJSON withCenter(double longitude, double latitude, Double zoom) {
        if (longitude < -180.0 || longitude > 180.0) {
            throw new IllegalArgumentException("Longitude must be between -180 and 180");
        }
        if (latitude < -90.0 || latitude > 90.0) {
            throw new IllegalArgumentException("Latitude must be between -90 and 90");
        }
        if (zoom != null && (zoom < 0.0 || zoom > 30.0)) {
            throw new IllegalArgumentException("Zoom level must be between 0 and 30");
        }
        List<Double> centerCoords = zoom != null ? List.of(Double.valueOf(longitude), Double.valueOf(latitude), zoom) : List.of(Double.valueOf(longitude), Double.valueOf(latitude));
        return new TileJSON(this.tilejson, this.tiles, this.vectorLayers, this.attribution, this.bounds, centerCoords, this.description, this.fillzoom, this.grids, this.legend, this.maxzoom, this.minzoom, this.name, this.scheme, this.template, this.version);
    }

    public TileJSON withDescription(String description) {
        return new TileJSON(this.tilejson, this.tiles, this.vectorLayers, this.attribution, this.bounds, this.center, description, this.fillzoom, this.grids, this.legend, this.maxzoom, this.minzoom, this.name, this.scheme, this.template, this.version);
    }

    public TileJSON withZoomRange(Integer minzoom, Integer maxzoom) {
        TileJSON.validateZoomLevel(minzoom, "minzoom");
        TileJSON.validateZoomLevel(maxzoom, "maxzoom");
        if (minzoom != null && maxzoom != null && minzoom > maxzoom) {
            throw new IllegalArgumentException("minzoom cannot be greater than maxzoom");
        }
        return new TileJSON(this.tilejson, this.tiles, this.vectorLayers, this.attribution, this.bounds, this.center, this.description, this.fillzoom, this.grids, this.legend, maxzoom, minzoom, this.name, this.scheme, this.template, this.version);
    }

    public TileJSON withName(String name) {
        return new TileJSON(this.tilejson, this.tiles, this.vectorLayers, this.attribution, this.bounds, this.center, this.description, this.fillzoom, this.grids, this.legend, this.maxzoom, this.minzoom, name, this.scheme, this.template, this.version);
    }

    public TileJSON withVersion(String version) {
        return new TileJSON(this.tilejson, this.tiles, this.vectorLayers, this.attribution, this.bounds, this.center, this.description, this.fillzoom, this.grids, this.legend, this.maxzoom, this.minzoom, this.name, this.scheme, this.template, version);
    }

    public TileJSON withVectorLayers(List<VectorLayer> vectorLayers) {
        if (vectorLayers == null) {
            throw new IllegalArgumentException("Vector layers list is required and cannot be null");
        }
        return new TileJSON(this.tilejson, this.tiles, vectorLayers, this.attribution, this.bounds, this.center, this.description, this.fillzoom, this.grids, this.legend, this.maxzoom, this.minzoom, this.name, this.scheme, this.template, this.version);
    }

    private static void validateRequired(String tilejson, List<String> tiles, List<VectorLayer> vectorLayers) {
        if (tilejson == null || tilejson.isBlank()) {
            throw new IllegalArgumentException("TileJSON version is required and cannot be null or blank");
        }
        if (tiles == null || tiles.isEmpty()) {
            throw new IllegalArgumentException("Tiles array is required and cannot be null or empty");
        }
        if (vectorLayers == null) {
            throw new IllegalArgumentException("Vector layers list is required and cannot be null");
        }
        for (int i = 0; i < tiles.size(); ++i) {
            String tile = tiles.get(i);
            if (tile != null && !tile.isBlank()) continue;
            throw new IllegalArgumentException("Tile URL at index " + i + " cannot be null or blank");
        }
    }

    private static void validateZoomLevel(Integer zoom, String fieldName) {
        if (zoom != null && (zoom < 0 || zoom > 30)) {
            throw new IllegalArgumentException(fieldName + " must be between 0 and 30, got: " + zoom);
        }
    }
}

