/*
 * Decompiled with CFR 0.152.
 */
package io.tileverse.jackson.databind.pmtiles.v3;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.tileverse.jackson.databind.tilejson.v3.TilesetType;
import io.tileverse.jackson.databind.tilejson.v3.VectorLayer;
import java.util.List;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public record PMTilesMetadata(@JsonProperty(value="name") String name, @JsonProperty(value="description") String description, @JsonProperty(value="attribution") String attribution, @JsonProperty(value="type") TilesetType type, @JsonProperty(value="version") String version, @JsonProperty(value="vector_layers") List<VectorLayer> vectorLayers, @JsonProperty(value="extras") Map<String, Object> extras) {
    public static PMTilesMetadata of(String name) {
        return new PMTilesMetadata(name, null, null, null, null, null, null);
    }

    public static PMTilesMetadata of(String name, String description, String attribution) {
        return new PMTilesMetadata(name, description, attribution, null, null, null, null);
    }

    public PMTilesMetadata withName(String name) {
        return new PMTilesMetadata(name, this.description, this.attribution, this.type, this.version, this.vectorLayers, this.extras);
    }

    public PMTilesMetadata withDescription(String description) {
        return new PMTilesMetadata(this.name, description, this.attribution, this.type, this.version, this.vectorLayers, this.extras);
    }

    public PMTilesMetadata withVersion(String version) {
        return new PMTilesMetadata(this.name, this.description, this.attribution, this.type, version, this.vectorLayers, this.extras);
    }

    public PMTilesMetadata withAttribution(String attribution) {
        return new PMTilesMetadata(this.name, this.description, attribution, this.type, this.version, this.vectorLayers, this.extras);
    }

    public PMTilesMetadata withVectorLayers(List<VectorLayer> vectorLayers) {
        return new PMTilesMetadata(this.name, this.description, this.attribution, this.type, this.version, vectorLayers, this.extras);
    }

    public PMTilesMetadata withType(TilesetType type) {
        return new PMTilesMetadata(this.name, this.description, this.attribution, type, this.version, this.vectorLayers, this.extras);
    }

    public PMTilesMetadata withExtras(Map<String, Object> extras) {
        return new PMTilesMetadata(this.name, this.description, this.attribution, this.type, this.version, this.vectorLayers, extras);
    }
}

