/*
 * Decompiled with CFR 0.152.
 */
package io.tileverse.pmtiles.store;

import io.tileverse.pmtiles.store.WebMercatorTransform;
import io.tileverse.tiling.common.BoundingBox2D;
import io.tileverse.tiling.common.Coordinate;
import io.tileverse.tiling.pyramid.TileIndex;
import java.nio.file.Path;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class WebMercatorTransformTest {
    @TempDir
    private Path tmpFolder;

    WebMercatorTransformTest() {
    }

    @Test
    void testLatLonToWebMercatorRoundTrip() {
        double[][] testCoords;
        for (double[] coord : testCoords = new double[][]{{0.0, 0.0}, {-180.0, -85.0511}, {180.0, 85.0511}, {1.412368, 42.4276}, {1.787481, 42.65717}, {-122.4194, 37.7749}, {2.3522, 48.8566}}) {
            double lon = coord[0];
            double lat = coord[1];
            Coordinate webMercator = WebMercatorTransform.latLonToWebMercator((double)lon, (double)lat);
            Coordinate latLonBack = WebMercatorTransform.webMercatorToLatLon((double)webMercator.x(), (double)webMercator.y());
            Assertions.assertThat((double)latLonBack.x()).isCloseTo(lon, Assertions.within((Double)1.0E-10));
            Assertions.assertThat((double)latLonBack.y()).isCloseTo(lat, Assertions.within((Double)1.0E-10));
        }
    }

    @Test
    void testTileCoordinateConversion() {
        TileIndex tile00 = TileIndex.xyz((long)0L, (long)0L, (int)0);
        BoundingBox2D geographicExtent = WebMercatorTransform.tileToGeographicExtent((TileIndex)tile00);
        Assertions.assertThat((double)geographicExtent.minX()).isCloseTo(-180.0, Assertions.within((Double)0.1));
        Assertions.assertThat((double)geographicExtent.maxX()).isCloseTo(180.0, Assertions.within((Double)0.1));
        Assertions.assertThat((double)geographicExtent.minY()).isCloseTo(-85.051, Assertions.within((Double)0.1));
        Assertions.assertThat((double)geographicExtent.maxY()).isCloseTo(85.051, Assertions.within((Double)0.1));
    }

    @Test
    void testLatLonToTileConversion() {
        int zoom = 10;
        TileIndex sfTile = WebMercatorTransform.latLonToTile((double)-122.4194, (double)37.7749, (int)zoom);
        Assertions.assertThat((long)sfTile.x()).isBetween(Long.valueOf(160L), Long.valueOf(170L));
        Assertions.assertThat((long)sfTile.y()).isBetween(Long.valueOf(390L), Long.valueOf(400L));
        Assertions.assertThat((int)sfTile.z()).isEqualTo(zoom);
        BoundingBox2D tileExtent = WebMercatorTransform.tileToGeographicExtent((TileIndex)sfTile);
        Assertions.assertThat((boolean)tileExtent.contains(Coordinate.of((double)-122.4194, (double)37.7749))).isTrue();
    }

    @Test
    void testWebMercatorBounds() {
        BoundingBox2D bounds = WebMercatorTransform.getWebMercatorBounds();
        double expectedBound = Math.PI * WebMercatorTransform.getEarthRadius();
        Assertions.assertThat((double)bounds.minX()).isCloseTo(-expectedBound, Assertions.within((Double)1.0));
        Assertions.assertThat((double)bounds.maxX()).isCloseTo(expectedBound, Assertions.within((Double)1.0));
        Assertions.assertThat((double)bounds.minY()).isCloseTo(-expectedBound, Assertions.within((Double)1.0));
        Assertions.assertThat((double)bounds.maxY()).isCloseTo(expectedBound, Assertions.within((Double)1.0));
    }
}

