/*
 * Decompiled with CFR 0.152.
 */
package io.tileverse.pmtiles.store;

import io.tileverse.jackson.databind.pmtiles.v3.PMTilesMetadata;
import io.tileverse.jackson.databind.tilejson.v3.VectorLayer;
import io.tileverse.pmtiles.InvalidHeaderException;
import io.tileverse.pmtiles.PMTilesHeader;
import io.tileverse.pmtiles.PMTilesReader;
import io.tileverse.pmtiles.PMTilesTestData;
import io.tileverse.pmtiles.store.PMTilesVectorTileStore;
import io.tileverse.pmtiles.store.WebMercatorTransform;
import io.tileverse.tiling.common.BoundingBox2D;
import io.tileverse.tiling.common.Coordinate;
import io.tileverse.tiling.common.CornerOfOrigin;
import io.tileverse.tiling.matrix.DefaultTileMatrixSets;
import io.tileverse.tiling.matrix.Tile;
import io.tileverse.tiling.matrix.TileMatrix;
import io.tileverse.tiling.matrix.TileMatrixSet;
import io.tileverse.tiling.pyramid.TileIndex;
import io.tileverse.tiling.pyramid.TileRange;
import io.tileverse.vectortile.model.VectorTile;
import io.tileverse.vectortile.mvt.VectorTileCodec;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class PMTilesVectorTileStoreTest {
    @TempDir
    private Path tmpFolder;
    private PMTilesReader andorraReader;
    private PMTilesVectorTileStore andorraStore;

    PMTilesVectorTileStoreTest() {
    }

    @BeforeEach
    void setup() throws IOException, InvalidHeaderException {
        Path file = PMTilesTestData.andorra(this.tmpFolder);
        this.andorraReader = new PMTilesReader(file);
        this.andorraStore = new PMTilesVectorTileStore(this.andorraReader);
    }

    @Test
    void layerNames() throws IOException, InvalidHeaderException {
        PMTilesMetadata metadata = this.andorraStore.getMetadata();
        List vectorLayers = metadata.vectorLayers();
        List<String> layerNames = vectorLayers.stream().map(VectorLayer::id).toList();
        Assertions.assertThat(layerNames).containsExactlyElementsOf(PMTilesTestData.andorraLayerNames());
    }

    @Test
    void getLayerMetadata() {
        Assertions.assertThat((Optional)this.andorraStore.getLayerMetadata("badname")).isEmpty();
        ((MapAssert)((MapAssert)Assertions.assertThat((Map)((VectorLayer)this.andorraStore.getLayerMetadata("addresses").orElseThrow()).fields()).hasSize(2)).containsEntry((Object)"housenumber", (Object)"String")).containsEntry((Object)"housename", (Object)"String");
        ((MapAssert)Assertions.assertThat((Map)((VectorLayer)this.andorraStore.getLayerMetadata("aerialways").orElseThrow()).fields()).hasSize(1)).containsEntry((Object)"kind", (Object)"String");
        ((MapAssert)((MapAssert)((MapAssert)Assertions.assertThat((Map)((VectorLayer)this.andorraStore.getLayerMetadata("boundaries").orElseThrow()).fields()).hasSize(3)).containsEntry((Object)"admin_level", (Object)"Number")).containsEntry((Object)"maritime", (Object)"Boolean")).containsEntry((Object)"disputed", (Object)"Boolean");
        ((MapAssert)((MapAssert)((MapAssert)((MapAssert)Assertions.assertThat((Map)((VectorLayer)this.andorraStore.getLayerMetadata("boundary_labels").orElseThrow()).fields()).hasSize(4)).containsEntry((Object)"name_en", (Object)"String")).containsEntry((Object)"name_de", (Object)"String")).containsEntry((Object)"way_area", (Object)"Number")).containsEntry((Object)"name", (Object)"String");
        ((MapAssert)Assertions.assertThat((Map)((VectorLayer)this.andorraStore.getLayerMetadata("dam_lines").orElseThrow()).fields()).hasSize(1)).containsEntry((Object)"kind", (Object)"String");
        ((MapAssert)Assertions.assertThat((Map)((VectorLayer)this.andorraStore.getLayerMetadata("land").orElseThrow()).fields()).hasSize(1)).containsEntry((Object)"kind", (Object)"String");
        ((MapAssert)((MapAssert)((MapAssert)((MapAssert)((MapAssert)Assertions.assertThat((Map)((VectorLayer)this.andorraStore.getLayerMetadata("place_labels").orElseThrow()).fields()).hasSize(5)).containsEntry((Object)"kind", (Object)"String")).containsEntry((Object)"name_de", (Object)"String")).containsEntry((Object)"population", (Object)"Number")).containsEntry((Object)"name", (Object)"String")).containsEntry((Object)"name_en", (Object)"String");
        Assertions.assertThat((Optional)this.andorraStore.getLayerMetadata("pois")).isPresent();
        ((MapAssert)((MapAssert)((MapAssert)((MapAssert)((MapAssert)((MapAssert)((MapAssert)((MapAssert)((MapAssert)((MapAssert)((MapAssert)((MapAssert)((MapAssert)((MapAssert)((MapAssert)((MapAssert)((MapAssert)((MapAssert)((MapAssert)((MapAssert)((MapAssert)((MapAssert)((MapAssert)((MapAssert)Assertions.assertThat((Map)((VectorLayer)this.andorraStore.getLayerMetadata("pois").orElseThrow()).fields()).hasSize(24)).containsEntry((Object)"man_made", (Object)"String")).containsEntry((Object)"tower:type", (Object)"String")).containsEntry((Object)"emergency", (Object)"String")).containsEntry((Object)"sport", (Object)"String")).containsEntry((Object)"denomination", (Object)"String")).containsEntry((Object)"amenity", (Object)"String")).containsEntry((Object)"atm", (Object)"Boolean")).containsEntry((Object)"name_en", (Object)"String")).containsEntry((Object)"historic", (Object)"String")).containsEntry((Object)"recycling:glass_bottles", (Object)"Boolean")).containsEntry((Object)"cuisine", (Object)"String")).containsEntry((Object)"name_de", (Object)"String")).containsEntry((Object)"shop", (Object)"String")).containsEntry((Object)"leisure", (Object)"String")).containsEntry((Object)"tourism", (Object)"String")).containsEntry((Object)"office", (Object)"String")).containsEntry((Object)"vending", (Object)"String")).containsEntry((Object)"recycling:clothes", (Object)"Boolean")).containsEntry((Object)"recycling:scrap_metal", (Object)"Boolean")).containsEntry((Object)"name", (Object)"String")).containsEntry((Object)"religion", (Object)"String")).containsEntry((Object)"recycling:paper", (Object)"Boolean")).containsEntry((Object)"information", (Object)"String")).containsEntry((Object)"housenumber", (Object)"String");
    }

    @Test
    void matrixSet() {
        TileMatrixSet webMercatorMatrixSet = DefaultTileMatrixSets.WEB_MERCATOR_QUAD;
        TileMatrixSet andorraMatrixSet = this.andorraStore.matrixSet();
        PMTilesHeader pmtilesHeader = this.andorraReader.getHeader();
        BoundingBox2D geographicBoundingBox = pmtilesHeader.geographicBoundingBox();
        BoundingBox2D andorraBoundingBox = WebMercatorTransform.latLonToWebMercator((BoundingBox2D)geographicBoundingBox);
        Assertions.assertThat((Object)andorraBoundingBox).isEqualTo((Object)this.andorraStore.getExtent());
        Assertions.assertThat((int)andorraMatrixSet.minZoomLevel()).isZero();
        Assertions.assertThat((int)andorraMatrixSet.maxZoomLevel()).isEqualTo(14);
        andorraMatrixSet.getTileMatrix(0).boundingBox();
        for (int z = andorraMatrixSet.minZoomLevel(); z <= andorraMatrixSet.maxZoomLevel(); ++z) {
            TileMatrix zMatrix = andorraMatrixSet.getTileMatrix(z);
            Assertions.assertThat((Object)zMatrix.boundingBox()).isNotEqualTo((Object)andorraBoundingBox);
            Assertions.assertThat((boolean)zMatrix.boundingBox().contains(andorraBoundingBox)).isTrue();
            TileMatrix fullMatrix = webMercatorMatrixSet.getTileMatrix(z);
            if (z == 0) {
                Assertions.assertThat((Object)zMatrix.boundingBox()).isEqualTo((Object)fullMatrix.boundingBox());
            } else {
                Assertions.assertThat((Object)zMatrix.boundingBox()).isNotEqualTo((Object)fullMatrix.boundingBox());
            }
            Assertions.assertThat((boolean)fullMatrix.boundingBox().contains(zMatrix.boundingBox())).isTrue();
        }
    }

    @Test
    void getWithTileIndex() throws IOException {
        TileMatrixSet andorraMatrixSet = this.andorraStore.matrixSet();
        Assertions.assertThat((Comparable)andorraMatrixSet.tilePyramid().cornerOfOrigin()).isEqualTo((Object)CornerOfOrigin.TOP_LEFT);
        System.out.println("Total available indices: " + this.andorraReader.getTileIndices().count());
        for (int z = andorraMatrixSet.minZoomLevel(); z <= 12; ++z) {
            System.out.println("--------------------------------------");
            System.out.println("Zoom level " + z);
            System.out.println("Available indices: " + this.andorraReader.getTileIndicesByZoomLevel(z).count());
            this.andorraReader.getTileIndicesByZoomLevel(z).forEach(index -> {
                try {
                    Optional tile = this.andorraReader.getTile(index);
                    Optional<VectorTile> vectorTile = this.decode(tile);
                    System.out.printf("%s -> tile found: %s, decoded: %s %n", index, tile.isPresent(), vectorTile.isPresent());
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
            TileMatrix zMatrix = andorraMatrixSet.getTileMatrix(z);
            TileRange zRange = zMatrix.tileRange();
            System.out.println("Matrix at z=%d (%s to %s): ".formatted(z, zRange.first(), zRange.last()));
            System.out.println("Available indices: %d".formatted(zRange.count()));
            System.out.printf("Covers PMTiles indices: %s%n", this.andorraReader.getTileIndicesByZoomLevel(z).noneMatch(i -> !zMatrix.contains(i)));
            TileIndex index2 = zRange.first();
            do {
                this.assertExists(index2);
            } while ((index2 = (TileIndex)zRange.next(index2).orElse(null)) != null);
        }
    }

    private Optional<VectorTile> decode(Optional<ByteBuffer> tile) {
        if (tile.isEmpty()) {
            return Optional.empty();
        }
        ByteBuffer buff = tile.orElseThrow();
        try {
            return Optional.of(new VectorTileCodec().decode(buff));
        }
        catch (Exception e) {
            e.printStackTrace();
            return Optional.empty();
        }
    }

    private void assertExists(TileIndex tileIndex) {
        Optional tileOpt = this.andorraStore.findTile(tileIndex);
        System.out.printf(" -> tile found: %s%n", tileOpt.isPresent());
    }

    @Test
    void debugCoordinateConversion() throws IOException {
        PMTilesHeader header = this.andorraReader.getHeader();
        System.out.println("=== PMTiles Header Info ===");
        System.out.println("Geographic bounds: " + String.valueOf(header.geographicBoundingBox()));
        System.out.println("Min zoom: " + header.minZoom() + ", Max zoom: " + header.maxZoom());
        BoundingBox2D webMercatorExtent = WebMercatorTransform.latLonToWebMercator((BoundingBox2D)header.geographicBoundingBox());
        System.out.println("WebMercator extent: " + String.valueOf(webMercatorExtent));
        TileMatrixSet baseTms = DefaultTileMatrixSets.WEB_MERCATOR_QUAD.toBuilder().zoomRange((int)header.minZoom(), (int)header.maxZoom()).build();
        for (int z = 0; z <= 5; ++z) {
            System.out.println("\n--- Zoom Level " + z + " ---");
            TileMatrix matrix = baseTms.getTileMatrix(z);
            Optional expectedRange = matrix.extentToRange(webMercatorExtent);
            System.out.println("Geographic extent suggests tile range: " + String.valueOf(expectedRange.isPresent() ? (Comparable)expectedRange.get() : "NONE"));
            if (expectedRange.isPresent()) {
                TileRange range = (TileRange)expectedRange.get();
                System.out.println("  Range bounds: (" + range.minx() + "," + range.miny() + ") to (" + range.maxx() + "," + range.maxy() + ")");
                System.out.println("  First tile would be: (" + range.minx() + "," + range.miny() + "," + z + ")");
            }
            List<TileIndex> actualTiles = this.andorraReader.getTileIndicesByZoomLevel(z).collect(Collectors.toList());
            System.out.println("Actual PMTiles tiles: " + actualTiles.size() + " tiles");
            actualTiles.forEach(tile -> System.out.println("  " + String.valueOf(tile)));
            if (!expectedRange.isPresent() || actualTiles.isEmpty()) continue;
            TileRange range = (TileRange)expectedRange.get();
            for (TileIndex tile2 : actualTiles) {
                boolean inRange = tile2.x() >= range.minx() && tile2.x() <= range.maxx() && tile2.y() >= range.miny() && tile2.y() <= range.maxy();
                System.out.println("  " + String.valueOf(tile2) + " in expected range: " + inRange);
            }
        }
    }

    @Test
    void debugZoomLevel11TileRange() {
        TileMatrixSet andorraMatrixSet = this.andorraStore.matrixSet();
        int targetZoom = 11;
        System.out.println("=== Debugging Zoom Level " + targetZoom + " ===");
        TileMatrix zMatrix = andorraMatrixSet.getTileMatrix(targetZoom);
        TileRange zRange = zMatrix.tileRange();
        System.out.println("TileMatrix: " + String.valueOf(zMatrix));
        System.out.println("TileRange: " + String.valueOf(zRange));
        System.out.println("Axis Origin: " + String.valueOf(zRange.cornerOfOrigin()));
        System.out.println("Range bounds: (" + zRange.minx() + "," + zRange.miny() + ") to (" + zRange.maxx() + "," + zRange.maxy() + ")");
        System.out.println("Expected count: " + zRange.count() + " tiles");
        System.out.println("First tile: " + String.valueOf(zRange.first()));
        System.out.println("Last tile: " + String.valueOf(zRange.last()));
        System.out.println("\n--- Manual Traversal ---");
        ArrayList<TileIndex> traversed = new ArrayList<TileIndex>();
        TileIndex index = zRange.min();
        int count = 0;
        do {
            traversed.add(index);
            System.out.println("Tile " + ++count + ": " + String.valueOf(index));
            Optional nextOpt = zRange.next(index);
            if (!nextOpt.isPresent()) {
                System.out.println("No next tile - traversal complete");
                break;
            }
            index = (TileIndex)nextOpt.get();
        } while (count < 20);
        System.out.println("\nTraversed " + count + " tiles, expected " + zRange.count() + " tiles");
        if ((long)count != zRange.count()) {
            System.out.println("ERROR: Traversal count mismatch!");
            System.out.println("\nExpected tiles in range:");
            for (long x = zRange.minx(); x <= zRange.maxx(); ++x) {
                for (long y = zRange.miny(); y <= zRange.maxy(); ++y) {
                    TileIndex expected = TileIndex.xyz((long)x, (long)y, (int)targetZoom);
                    boolean wasTraversed = traversed.contains(expected);
                    System.out.println("  " + String.valueOf(expected) + " - traversed: " + wasTraversed);
                }
            }
        }
    }

    @Test
    @Disabled(value="implement!")
    void findBestZoomLevelResolutionStrategy() {
        Assertions.fail();
    }

    @Test
    void testLatLonToWebMercatorAccuracy() {
        PMTilesHeader header = this.andorraReader.getHeader();
        BoundingBox2D geoExtent = header.geographicBoundingBox();
        System.out.println("=== Testing LatLon to WebMercator Accuracy ===");
        System.out.println("Geographic extent: " + String.valueOf(geoExtent));
        BoundingBox2D wmExtent = WebMercatorTransform.latLonToWebMercator((BoundingBox2D)geoExtent);
        System.out.println("WebMercator extent: " + String.valueOf(wmExtent));
        TileMatrixSet baseTms = DefaultTileMatrixSets.WEB_MERCATOR_QUAD;
        for (int zoom = 0; zoom <= 8; ++zoom) {
            System.out.println("\n--- Zoom " + zoom + " ---");
            TileMatrix matrix = baseTms.getTileMatrix(zoom);
            Coordinate minCorner = wmExtent.lowerLeft();
            Coordinate maxCorner = wmExtent.upperRight();
            Optional minTileOpt = matrix.coordinateToTile(minCorner);
            Optional maxTileOpt = matrix.coordinateToTile(maxCorner);
            if (!minTileOpt.isPresent() || !maxTileOpt.isPresent()) continue;
            Tile minTile = (Tile)minTileOpt.get();
            Tile maxTile = (Tile)maxTileOpt.get();
            System.out.printf("Coordinate (%f, %f) -> Tile (%d, %d)%n", minCorner.x(), minCorner.y(), minTile.x(), minTile.y());
            System.out.printf("Coordinate (%f, %f) -> Tile (%d, %d)%n", maxCorner.x(), maxCorner.y(), maxTile.x(), maxTile.y());
            System.out.printf("Min tile extent: %s%n", minTile.extent());
            System.out.printf("Max tile extent: %s%n", maxTile.extent());
            BoundingBox2D combinedTileExtent = minTile.extent().union(maxTile.extent());
            System.out.printf("Combined tile extent: %s%n", combinedTileExtent);
            double deltaMinX = Math.abs(wmExtent.minX() - combinedTileExtent.minX());
            double deltaMaxX = Math.abs(wmExtent.maxX() - combinedTileExtent.maxX());
            double deltaMinY = Math.abs(wmExtent.minY() - combinedTileExtent.minY());
            double deltaMaxY = Math.abs(wmExtent.maxY() - combinedTileExtent.maxY());
            System.out.printf("Extent deltas: minX=%.6f, maxX=%.6f, minY=%.6f, maxY=%.6f%n", deltaMinX, deltaMaxX, deltaMinY, deltaMaxY);
            List actualTiles = this.andorraReader.getTileIndicesByZoomLevel(zoom).collect(Collectors.toList());
            if (actualTiles.isEmpty()) continue;
            System.out.println("Actual PMTiles tiles: " + String.valueOf(actualTiles));
            for (TileIndex actualTile : actualTiles) {
                boolean inRange = actualTile.x() >= minTile.x() && actualTile.x() <= maxTile.x() && actualTile.y() >= minTile.y() && actualTile.y() <= maxTile.y();
                System.out.printf("  %s in predicted range: %s%n", actualTile, inRange);
                Optional actualTileObj = matrix.tile(actualTile);
                if (!actualTileObj.isPresent()) continue;
                BoundingBox2D actualExtent = ((Tile)actualTileObj.get()).extent();
                System.out.printf("    Actual tile extent: %s%n", actualExtent);
                boolean intersects = actualExtent.intersects(wmExtent);
                System.out.printf("    Intersects WM extent: %s%n", intersects);
            }
        }
    }
}

