/*
 * Decompiled with CFR 0.152.
 */
package io.tileverse.pmtiles.store;

import io.tileverse.pmtiles.PMTilesHeader;
import io.tileverse.pmtiles.store.PMTilesTileMatrixSet;
import io.tileverse.tiling.matrix.TileMatrixSet;
import io.tileverse.tiling.pyramid.TileRange;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class PMTilesTileMatrixSetTest {
    PMTilesTileMatrixSetTest() {
    }

    @Test
    void testFromWebMercator() {
        PMTilesHeader header = PMTilesHeader.builder().minZoom((byte)5).maxZoom((byte)15).minLon(-74.1).minLat(40.6).maxLon(-73.9).maxLat(40.8).build();
        TileMatrixSet tms = PMTilesTileMatrixSet.fromWebMercator((PMTilesHeader)header);
        Assertions.assertNotNull((Object)tms);
        Assertions.assertEquals((Object)"EPSG:3857", (Object)tms.crsId());
        Assertions.assertEquals((int)256, (int)tms.tileWidth());
        Assertions.assertEquals((int)256, (int)tms.tileHeight());
        Assertions.assertEquals((int)5, (int)tms.tilePyramid().minZoomLevel());
        Assertions.assertEquals((int)15, (int)tms.tilePyramid().maxZoomLevel());
        Assertions.assertEquals((int)11, (int)tms.tilePyramid().levels().size());
        TileRange level5Range = tms.tilePyramid().tileRange(5);
        Assertions.assertTrue((level5Range.count() < 1024L ? 1 : 0) != 0, (String)"NYC bounds should result in fewer tiles than full world");
        Assertions.assertTrue((level5Range.count() > 0L ? 1 : 0) != 0, (String)"Should have some tiles in the bounded area");
    }

    @Test
    void testFromWebMercator512() {
        PMTilesHeader header = PMTilesHeader.builder().minZoom((byte)3).maxZoom((byte)10).minLon(-1.0).minLat(51.0).maxLon(1.0).maxLat(52.0).build();
        TileMatrixSet tms = PMTilesTileMatrixSet.fromWebMercator512((PMTilesHeader)header);
        Assertions.assertNotNull((Object)tms);
        Assertions.assertEquals((Object)"EPSG:3857", (Object)tms.crsId());
        Assertions.assertEquals((int)512, (int)tms.tileWidth());
        Assertions.assertEquals((int)512, (int)tms.tileHeight());
        Assertions.assertEquals((int)3, (int)tms.tilePyramid().minZoomLevel());
        Assertions.assertEquals((int)10, (int)tms.tilePyramid().maxZoomLevel());
        Assertions.assertEquals((int)8, (int)tms.tilePyramid().levels().size());
    }

    @Test
    void testFromCRS84() {
        PMTilesHeader header = PMTilesHeader.builder().minZoom((byte)2).maxZoom((byte)8).build();
        TileMatrixSet tms = PMTilesTileMatrixSet.fromCRS84((PMTilesHeader)header);
        Assertions.assertNotNull((Object)tms);
        Assertions.assertEquals((Object)"EPSG:4326", (Object)tms.crsId());
        Assertions.assertEquals((int)256, (int)tms.tileWidth());
        Assertions.assertEquals((int)256, (int)tms.tileHeight());
        Assertions.assertEquals((int)2, (int)tms.tilePyramid().minZoomLevel());
        Assertions.assertEquals((int)8, (int)tms.tilePyramid().maxZoomLevel());
        Assertions.assertEquals((int)7, (int)tms.tilePyramid().levels().size());
    }

    @Test
    void testResolutionsAreCorrect() {
        PMTilesHeader header = PMTilesHeader.builder().minZoom((byte)0).maxZoom((byte)2).build();
        TileMatrixSet tms = PMTilesTileMatrixSet.fromWebMercator((PMTilesHeader)header);
        double res0 = tms.resolution(0);
        double res1 = tms.resolution(1);
        double res2 = tms.resolution(2);
        Assertions.assertTrue((res0 > res1 ? 1 : 0) != 0, (String)"Resolution should decrease from zoom 0 to 1");
        Assertions.assertTrue((res1 > res2 ? 1 : 0) != 0, (String)"Resolution should decrease from zoom 1 to 2");
        double ratio1 = res0 / res1;
        double ratio2 = res1 / res2;
        Assertions.assertTrue((Math.abs(ratio1 - 2.0) < 0.001 ? 1 : 0) != 0, (String)("Resolution ratio should be close to 2.0, was: " + ratio1));
        Assertions.assertTrue((Math.abs(ratio2 - 2.0) < 0.001 ? 1 : 0) != 0, (String)("Resolution ratio should be close to 2.0, was: " + ratio2));
    }

    @Test
    void testInvalidZoomRange() {
        PMTilesHeader header = PMTilesHeader.builder().minZoom((byte)30).maxZoom((byte)35).build();
        Assertions.assertThrows(IllegalArgumentException.class, () -> PMTilesTileMatrixSet.fromWebMercator((PMTilesHeader)header));
    }
}

