/*
 * Decompiled with CFR 0.152.
 */
package io.tileverse.pmtiles;

import io.tileverse.pmtiles.InvalidHeaderException;
import io.tileverse.pmtiles.PMTilesHeader;
import io.tileverse.pmtiles.PMTilesReader;
import io.tileverse.pmtiles.PMTilesWriter;
import io.tileverse.pmtiles.UnsupportedCompressionException;
import io.tileverse.tiling.pyramid.TileIndex;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class PMTilesWriterTest {
    @TempDir
    Path tempDir;
    private Path outputPath;

    @BeforeEach
    void setup() {
        this.outputPath = this.tempDir.resolve("test.pmtiles");
    }

    @AfterEach
    void cleanup() throws IOException {
        Files.deleteIfExists(this.outputPath);
    }

    @Test
    void testWriteEmptyFile() throws IOException {
        PMTilesWriter writer = PMTilesWriter.builder().outputPath(this.outputPath).build();
        Assertions.assertThrows(IllegalStateException.class, () -> ((PMTilesWriter)writer).complete());
    }

    @Test
    void testWriteAndReadSingleTile() throws IOException, UnsupportedCompressionException, InvalidHeaderException {
        byte[] tileData = "Sample tile data".getBytes(StandardCharsets.UTF_8);
        try (PMTilesWriter writer = PMTilesWriter.builder().outputPath(this.outputPath).minZoom(0).maxZoom(0).tileCompression((byte)1).build();){
            writer.addTile(TileIndex.zxy((int)0, (long)0L, (long)0L), tileData);
            writer.complete();
        }
        Assertions.assertTrue((boolean)Files.exists(this.outputPath, new LinkOption[0]));
        Assertions.assertTrue((Files.size(this.outputPath) > 0L ? 1 : 0) != 0);
        PMTilesReader reader = new PMTilesReader(this.outputPath);
        PMTilesHeader header = reader.getHeader();
        Assertions.assertEquals((int)0, (int)header.minZoom());
        Assertions.assertEquals((int)0, (int)header.maxZoom());
        Assertions.assertEquals((byte)1, (byte)header.tileCompression());
        Assertions.assertEquals((byte)1, (byte)header.tileType());
        Assertions.assertEquals((long)1L, (long)header.addressedTilesCount());
        Optional readTileData = reader.getTile(0, 0, 0);
        Assertions.assertTrue((boolean)readTileData.isPresent());
        this.assertArrayEquals(tileData, (ByteBuffer)readTileData.get());
    }

    @Test
    void testWriteAndReadMultipleTiles() throws IOException, UnsupportedCompressionException, InvalidHeaderException {
        byte[] tileData1 = "Tile data 1".getBytes(StandardCharsets.UTF_8);
        byte[] tileData2 = "Tile data 2".getBytes(StandardCharsets.UTF_8);
        byte[] tileData3 = tileData1;
        try (PMTilesWriter writer = PMTilesWriter.builder().outputPath(this.outputPath).minZoom(0).maxZoom(1).tileCompression((byte)1).build();){
            writer.addTile(TileIndex.zxy((int)0, (long)0L, (long)0L), tileData1);
            writer.addTile(TileIndex.zxy((int)1, (long)0L, (long)0L), tileData2);
            writer.addTile(TileIndex.zxy((int)1, (long)0L, (long)1L), tileData3);
            writer.complete();
        }
        PMTilesReader reader = new PMTilesReader(this.outputPath);
        PMTilesHeader header = reader.getHeader();
        Assertions.assertEquals((int)0, (int)header.minZoom());
        Assertions.assertEquals((int)1, (int)header.maxZoom());
        Assertions.assertEquals((long)3L, (long)header.addressedTilesCount());
        Assertions.assertEquals((long)2L, (long)header.tileContentsCount());
        Optional readTileData1 = reader.getTile(0, 0, 0);
        Optional readTileData2 = reader.getTile(1, 0, 0);
        Optional readTileData3 = reader.getTile(1, 0, 1);
        Assertions.assertTrue((boolean)readTileData1.isPresent());
        Assertions.assertTrue((boolean)readTileData2.isPresent());
        Assertions.assertTrue((boolean)readTileData3.isPresent());
        this.assertArrayEquals(tileData1, (ByteBuffer)readTileData1.get());
        this.assertArrayEquals(tileData2, (ByteBuffer)readTileData2.get());
        this.assertArrayEquals(tileData3, (ByteBuffer)readTileData3.get());
        this.assertArrayEquals((ByteBuffer)readTileData1.get(), (ByteBuffer)readTileData3.get());
    }

    @Test
    void testSetMetadata() throws IOException, UnsupportedCompressionException, InvalidHeaderException {
        byte[] tileData = "Sample tile data".getBytes(StandardCharsets.UTF_8);
        String metadata = "{\"name\":\"Test Tileset\",\"version\":\"1.0\"}";
        try (PMTilesWriter writer = PMTilesWriter.builder().outputPath(this.outputPath).minZoom(0).maxZoom(0).tileCompression((byte)1).internalCompression((byte)1).build();){
            writer.addTile(TileIndex.zxy((int)0, (long)0L, (long)0L), tileData);
            writer.setMetadata(metadata);
            writer.complete();
        }
        PMTilesReader reader = new PMTilesReader(this.outputPath);
        String metadataString = reader.getMetadataAsString();
        Assertions.assertEquals((Object)metadata, (Object)metadataString);
    }

    @Test
    void testProgressTracking() throws IOException {
        byte[] tileData = "Sample tile data".getBytes(StandardCharsets.UTF_8);
        final AtomicBoolean progressReported = new AtomicBoolean(false);
        final AtomicReference<Double> lastProgress = new AtomicReference<Double>(0.0);
        try (PMTilesWriter writer = PMTilesWriter.builder().outputPath(this.outputPath).build();){
            writer.setProgressListener(new PMTilesWriter.ProgressListener(){

                public void onProgress(double progress) {
                    progressReported.set(true);
                    lastProgress.set(progress);
                }

                public boolean isCancelled() {
                    return false;
                }
            });
            writer.addTile(TileIndex.zxy((int)0, (long)0L, (long)0L), tileData);
            writer.complete();
        }
        Assertions.assertTrue((boolean)progressReported.get());
        Assertions.assertEquals((double)1.0, (double)lastProgress.get(), (double)0.001);
    }

    private void assertArrayEquals(ByteBuffer expected, ByteBuffer actual) {
        this.assertArrayEquals(this.bytes(expected), actual);
    }

    private void assertArrayEquals(byte[] expected, ByteBuffer actual) {
        byte[] byteBuffer = this.bytes(actual);
        Assertions.assertArrayEquals((byte[])expected, (byte[])byteBuffer);
    }

    private byte[] bytes(ByteBuffer buffer) {
        byte[] byteBuffer = new byte[buffer.remaining()];
        buffer.get(byteBuffer);
        return byteBuffer;
    }
}

