/*
 * Decompiled with CFR 0.152.
 */
package io.tileverse.pmtiles;

import io.tileverse.pmtiles.InvalidHeaderException;
import io.tileverse.pmtiles.PMTilesHeader;
import io.tileverse.pmtiles.PMTilesReader;
import io.tileverse.pmtiles.PMTilesWriter;
import io.tileverse.pmtiles.UnsupportedCompressionException;
import io.tileverse.tiling.pyramid.TileIndex;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Optional;

public class PMTilesWriterExample {
    public static void createExamplePMTiles(Path outputPath) throws IOException {
        byte[] emptyTile = PMTilesWriterExample.createSampleTileData("Empty tile");
        byte[] landTile = PMTilesWriterExample.createSampleTileData("Land tile with features");
        byte[] oceanTile = PMTilesWriterExample.createSampleTileData("Ocean tile");
        try (PMTilesWriter writer = PMTilesWriter.builder().outputPath(outputPath).minZoom(0).maxZoom(2).tileCompression((byte)2).tileType((byte)1).bounds(-180.0, -85.05113, 180.0, 85.05113).center(0.0, 0.0, (byte)0).build();){
            writer.addTile(TileIndex.zxy((int)0, (long)0L, (long)0L), emptyTile);
            writer.addTile(TileIndex.zxy((int)1, (long)0L, (long)0L), oceanTile);
            writer.addTile(TileIndex.zxy((int)1, (long)0L, (long)1L), oceanTile);
            writer.addTile(TileIndex.zxy((int)1, (long)1L, (long)0L), landTile);
            writer.addTile(TileIndex.zxy((int)1, (long)1L, (long)1L), landTile);
            writer.addTile(TileIndex.zxy((int)2, (long)0L, (long)0L), oceanTile);
            writer.addTile(TileIndex.zxy((int)2, (long)0L, (long)1L), oceanTile);
            writer.addTile(TileIndex.zxy((int)2, (long)1L, (long)0L), landTile);
            writer.addTile(TileIndex.zxy((int)2, (long)1L, (long)1L), landTile);
            writer.addTile(TileIndex.zxy((int)2, (long)2L, (long)2L), landTile);
            writer.addTile(TileIndex.zxy((int)2, (long)3L, (long)3L), emptyTile);
            writer.setMetadata("{\n  \"name\": \"Example Tileset\",\n  \"format\": \"pbf\",\n  \"description\": \"A simple example tileset\",\n  \"version\": \"1.0.0\",\n  \"attribution\": \"\u00a9 Example Contributors\",\n  \"vector_layers\": [\n    {\n      \"id\": \"land\",\n      \"description\": \"Land features\",\n      \"minzoom\": 0,\n      \"maxzoom\": 2,\n      \"fields\": {\n        \"type\": \"string\",\n        \"area\": \"number\"\n      }\n    }\n  ]\n}\n");
            writer.setProgressListener(new PMTilesWriter.ProgressListener(){

                public void onProgress(double progress) {
                    System.out.printf("Progress: %.1f%%\n", progress * 100.0);
                }

                public boolean isCancelled() {
                    return false;
                }
            });
            writer.complete();
        }
        System.out.println("PMTiles file created successfully at: " + String.valueOf(outputPath));
        try {
            PMTilesReader reader = new PMTilesReader(outputPath);
            PMTilesHeader header = reader.getHeader();
            System.out.println("\nPMTiles file information:");
            System.out.println("Tile count: " + header.addressedTilesCount());
            System.out.println("Unique tile contents: " + header.tileContentsCount());
            System.out.println("Zoom levels: " + header.minZoom() + " to " + header.maxZoom());
            System.out.println("Bounds: " + (double)header.minLonE7() / 1.0E7 + "," + (double)header.minLatE7() / 1.0E7 + "," + (double)header.maxLonE7() / 1.0E7 + "," + (double)header.maxLatE7() / 1.0E7);
            String metadata = reader.getMetadataAsString();
            System.out.println("\nMetadata: " + metadata);
            Optional tileData = reader.getTile(0, 0, 0);
            if (tileData.isPresent()) {
                String stringData = PMTilesReader.toString((ByteBuffer)((ByteBuffer)tileData.get()));
                System.out.println("\nRoot tile data: " + stringData);
            }
        }
        catch (InvalidHeaderException | UnsupportedCompressionException e) {
            e.printStackTrace();
        }
    }

    private static byte[] createSampleTileData(String content) {
        return content.getBytes(StandardCharsets.UTF_8);
    }

    public static void main(String[] args) {
        try {
            Path outputPath = Path.of("example.pmtiles", new String[0]);
            PMTilesWriterExample.createExamplePMTiles(outputPath);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

