/*
 * Decompiled with CFR 0.152.
 */
package io.tileverse.pmtiles;

import io.tileverse.pmtiles.PMTilesReaderTest;
import io.tileverse.rangereader.RangeReader;
import io.tileverse.rangereader.file.FileRangeReader;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class PMTilesTestData {
    public static Path andorra(Path tmpFolder) throws IOException {
        Path andorraPmTiles = tmpFolder.resolve("andorra.pmtiles");
        if (!Files.isRegularFile(andorraPmTiles, new LinkOption[0])) {
            try (InputStream in = Objects.requireNonNull(PMTilesReaderTest.class.getResourceAsStream("/io/tileverse/pmtiles/andorra.pmtiles"));){
                Files.copy(in, andorraPmTiles, new CopyOption[0]);
            }
        }
        return andorraPmTiles;
    }

    public static RangeReader andorraFileRangeReader(Path tmpFolder) throws IOException {
        return FileRangeReader.of((Path)PMTilesTestData.andorra(tmpFolder));
    }

    public static List<String> andorraLayerNames() {
        return Arrays.asList("addresses", "aerialways", "boundaries", "boundary_labels", "bridges", "buildings", "dam_lines", "dam_polygons", "land", "place_labels", "pois", "public_transport", "sites", "street_labels", "street_polygons", "streets", "streets_polygons_labels", "water_lines", "water_lines_labels", "water_polygons", "water_polygons_labels");
    }
}

