/*
 * Decompiled with CFR 0.152.
 */
package io.tileverse.pmtiles;

import io.tileverse.jackson.databind.pmtiles.v3.PMTilesMetadata;
import io.tileverse.pmtiles.PMTilesHeader;
import io.tileverse.pmtiles.PMTilesReader;
import io.tileverse.pmtiles.PMTilesTestData;
import io.tileverse.rangereader.RangeReader;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.Optional;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class PMTilesReaderTest {
    protected Path tmpFolder;

    PMTilesReaderTest() {
    }

    @BeforeEach
    void setup(@TempDir Path tmpFolder) {
        this.tmpFolder = tmpFolder;
    }

    protected RangeReader getAndorraRangeReader() throws IOException {
        return PMTilesTestData.andorraFileRangeReader(this.tmpFolder);
    }

    @Test
    void testPMTilesShowInfo() throws Exception {
        try (RangeReader rangeReader = this.getAndorraRangeReader();){
            PMTilesReader reader = new PMTilesReader(() -> ((RangeReader)rangeReader).asByteChannel());
            PMTilesHeader header = reader.getHeader();
            org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)header.version());
            org.junit.jupiter.api.Assertions.assertEquals((byte)1, (byte)header.tileType());
            org.junit.jupiter.api.Assertions.assertEquals((double)1.412368, (double)header.minLon(), (double)1.0E-6);
            org.junit.jupiter.api.Assertions.assertEquals((double)42.4276, (double)header.minLat(), (double)1.0E-6);
            org.junit.jupiter.api.Assertions.assertEquals((double)1.787481, (double)header.maxLon(), (double)1.0E-6);
            org.junit.jupiter.api.Assertions.assertEquals((double)42.65717, (double)header.maxLat(), (double)1.0E-6);
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)header.minZoom());
            org.junit.jupiter.api.Assertions.assertEquals((int)14, (int)header.maxZoom());
            org.junit.jupiter.api.Assertions.assertEquals((double)1.599924, (double)header.centerLon(), (double)1.0E-6);
            org.junit.jupiter.api.Assertions.assertEquals((double)42.542385, (double)header.centerLat(), (double)1.0E-6);
            org.junit.jupiter.api.Assertions.assertEquals((int)10, (int)header.centerZoom());
            org.junit.jupiter.api.Assertions.assertEquals((long)329L, (long)header.addressedTilesCount());
            org.junit.jupiter.api.Assertions.assertEquals((long)329L, (long)header.tileEntriesCount());
            org.junit.jupiter.api.Assertions.assertEquals((long)329L, (long)header.tileContentsCount());
            org.junit.jupiter.api.Assertions.assertTrue((boolean)header.clustered());
            org.junit.jupiter.api.Assertions.assertEquals((byte)2, (byte)header.internalCompression());
            org.junit.jupiter.api.Assertions.assertEquals((byte)2, (byte)header.tileCompression());
            String metadata = reader.getMetadataAsString();
            org.junit.jupiter.api.Assertions.assertNotNull((Object)metadata);
            org.junit.jupiter.api.Assertions.assertFalse((boolean)metadata.isEmpty());
            org.junit.jupiter.api.Assertions.assertTrue((boolean)metadata.contains("OpenStreetMap contributors"));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)metadata.contains("Shortbread"));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)metadata.contains("baselayer"));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)metadata.contains("planetiler"));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)metadata.contains("vector_layers"));
            PMTilesMetadata metadataObj = reader.getMetadata();
            org.junit.jupiter.api.Assertions.assertNotNull((Object)metadataObj);
            org.junit.jupiter.api.Assertions.assertNotNull((Object)metadataObj.attribution());
            org.junit.jupiter.api.Assertions.assertTrue((boolean)metadataObj.attribution().contains("OpenStreetMap contributors"));
            org.junit.jupiter.api.Assertions.assertNotNull((Object)metadataObj.vectorLayers());
            org.junit.jupiter.api.Assertions.assertFalse((boolean)metadataObj.vectorLayers().isEmpty());
            boolean hasLandLayer = metadataObj.vectorLayers().stream().anyMatch(layer -> "land".equals(layer.id()));
            boolean hasWaterLayer = metadataObj.vectorLayers().stream().anyMatch(layer -> "water".equals(layer.id()) || "ocean".equals(layer.id()));
            org.junit.jupiter.api.Assertions.assertTrue((hasLandLayer || hasWaterLayer ? 1 : 0) != 0, (String)"Should have land or water layer");
        }
    }

    @Test
    void testTileFetching() throws Exception {
        try (RangeReader rangeReader = this.getAndorraRangeReader();){
            PMTilesReader reader = new PMTilesReader(() -> ((RangeReader)rangeReader).asByteChannel());
            Optional tile000 = reader.getTile(0, 0, 0);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)tile000.isPresent(), (String)"Tile 0/0/0 should exist");
            org.junit.jupiter.api.Assertions.assertTrue((((ByteBuffer)tile000.get()).remaining() > 0 ? 1 : 0) != 0, (String)"Tile 0/0/0 should have data");
            Optional tile110 = reader.getTile(1, 1, 0);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)tile110.isPresent(), (String)"Tile 1/1/0 should exist");
            org.junit.jupiter.api.Assertions.assertTrue((((ByteBuffer)tile110.get()).remaining() > 0 ? 1 : 0) != 0, (String)"Tile 1/1/0 should have data");
        }
    }

    @Test
    void testNonExistentTiles() throws Exception {
        try (RangeReader rangeReader = this.getAndorraRangeReader();){
            PMTilesReader reader = new PMTilesReader(() -> ((RangeReader)rangeReader).asByteChannel());
            Optional tileBeyondMax = reader.getTile(15, 0, 0);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)tileBeyondMax.isEmpty(), (String)"Tile beyond max zoom should not exist");
            Optional tileNotFound = reader.getTile(1, 0, 0);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)tileNotFound.isEmpty(), (String)"Tile 1/0/0 should not exist");
            Optional tileOutOfBounds = reader.getTile(10, 0, 0);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)tileOutOfBounds.isEmpty(), (String)"Tile outside geographic bounds should not exist");
        }
    }

    @Test
    void testEdgeCases() throws Exception {
        try (RangeReader rangeReader = this.getAndorraRangeReader();){
            PMTilesReader reader = new PMTilesReader(() -> ((RangeReader)rangeReader).asByteChannel());
            org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> reader.getTile(5, -1, 10), (String)"Tile with negative X should throw IllegalArgumentException");
            org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> reader.getTile(5, 10, -1), (String)"Tile with negative Y should throw IllegalArgumentException");
            int zoom = 5;
            int maxCoord = 1 << zoom;
            org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> reader.getTile(zoom, maxCoord, 0), (String)"Tile with X beyond grid bounds should throw IllegalArgumentException");
            org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> reader.getTile(zoom, 0, maxCoord), (String)"Tile with Y beyond grid bounds should throw IllegalArgumentException");
        }
    }

    @Test
    void testDifferentZoomLevels() throws Exception {
        try (RangeReader rangeReader = this.getAndorraRangeReader();){
            byte centerZoom;
            PMTilesReader reader = new PMTilesReader(() -> ((RangeReader)rangeReader).asByteChannel());
            PMTilesHeader header = reader.getHeader();
            byte minZoom = header.minZoom();
            Optional minZoomTile = reader.getTile((int)minZoom, 0, 0);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)minZoomTile.isPresent(), (String)"Tile at min zoom should exist");
            if (minZoom > 0) {
                Optional belowMinZoom = reader.getTile(minZoom - 1, 0, 0);
                org.junit.jupiter.api.Assertions.assertTrue((boolean)belowMinZoom.isEmpty(), (String)"Tile below min zoom should not exist");
            }
            if ((centerZoom = header.centerZoom()) >= minZoom && centerZoom <= header.maxZoom()) {
                double centerLon = header.centerLon();
                double centerLat = header.centerLat();
                int tilesAtZoom = 1 << centerZoom;
                int centerX = (int)((centerLon + 180.0) / 360.0 * (double)tilesAtZoom);
                int centerY = (int)((1.0 - Math.log(Math.tan(Math.toRadians(centerLat)) + 1.0 / Math.cos(Math.toRadians(centerLat))) / Math.PI) / 2.0 * (double)tilesAtZoom);
                Optional centerTile = reader.getTile((int)centerZoom, centerX, centerY);
                org.junit.jupiter.api.Assertions.assertNotNull((Object)centerTile, (String)"Center tile query should return a result (even if empty)");
            }
        }
    }

    @Test
    void testCoordinateUtilityMethods() throws Exception {
        try (RangeReader rangeReader = this.getAndorraRangeReader();){
            PMTilesReader reader = new PMTilesReader(() -> ((RangeReader)rangeReader).asByteChannel());
            PMTilesHeader header = reader.getHeader();
            org.junit.jupiter.api.Assertions.assertEquals((double)((double)header.minLonE7() / 1.0E7), (double)header.minLon(), (double)1.0E-7);
            org.junit.jupiter.api.Assertions.assertEquals((double)((double)header.minLatE7() / 1.0E7), (double)header.minLat(), (double)1.0E-7);
            org.junit.jupiter.api.Assertions.assertEquals((double)((double)header.maxLonE7() / 1.0E7), (double)header.maxLon(), (double)1.0E-7);
            org.junit.jupiter.api.Assertions.assertEquals((double)((double)header.maxLatE7() / 1.0E7), (double)header.maxLat(), (double)1.0E-7);
            org.junit.jupiter.api.Assertions.assertEquals((double)((double)header.centerLonE7() / 1.0E7), (double)header.centerLon(), (double)1.0E-7);
            org.junit.jupiter.api.Assertions.assertEquals((double)((double)header.centerLatE7() / 1.0E7), (double)header.centerLat(), (double)1.0E-7);
            org.junit.jupiter.api.Assertions.assertTrue((header.minLon() > 0.0 && header.minLon() < 3.0 ? 1 : 0) != 0, (String)"Min longitude should be reasonable for Andorra");
            org.junit.jupiter.api.Assertions.assertTrue((header.minLat() > 40.0 && header.minLat() < 45.0 ? 1 : 0) != 0, (String)"Min latitude should be reasonable for Andorra");
            org.junit.jupiter.api.Assertions.assertTrue((header.maxLon() > header.minLon() ? 1 : 0) != 0, (String)"Max longitude should be greater than min");
            org.junit.jupiter.api.Assertions.assertTrue((header.maxLat() > header.minLat() ? 1 : 0) != 0, (String)"Max latitude should be greater than min");
            org.junit.jupiter.api.Assertions.assertTrue((header.centerLon() >= header.minLon() && header.centerLon() <= header.maxLon() ? 1 : 0) != 0, (String)"Center longitude should be within bounds");
            org.junit.jupiter.api.Assertions.assertTrue((header.centerLat() >= header.minLat() && header.centerLat() <= header.maxLat() ? 1 : 0) != 0, (String)"Center latitude should be within bounds");
        }
    }

    @Test
    void testTileDecompression() throws Exception {
        try (RangeReader rangeReader = this.getAndorraRangeReader();){
            PMTilesReader reader = new PMTilesReader(() -> ((RangeReader)rangeReader).asByteChannel());
            PMTilesHeader header = reader.getHeader();
            org.junit.jupiter.api.Assertions.assertEquals((byte)2, (byte)header.tileCompression());
            Optional tile = reader.getTile(0, 0, 0);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)tile.isPresent(), (String)"Root tile should exist");
            ByteBuffer tileData = (ByteBuffer)tile.get();
            org.junit.jupiter.api.Assertions.assertTrue((tileData.remaining() > 0 ? 1 : 0) != 0, (String)"Tile should have data");
            org.junit.jupiter.api.Assertions.assertNotNull((Object)tileData, (String)"Decompressed tile data should not be null");
            org.junit.jupiter.api.Assertions.assertTrue((tileData.remaining() > 10 ? 1 : 0) != 0, (String)"Decompressed tile should be reasonably sized");
        }
    }

    @Test
    void testParseMetadataException() throws IOException {
        String rawMetadata = "{\n  \"name\": \"Shortbread\",\n  \"description\": \"A basic, lean, general-purpose vector tile schema for OpenStreetMap data. See https://shortbread.geofabrik.de/\",\n  \"attribution\": \"<a href=\"https://www.openstreetmap.org/copyright\" target=\"_blank\">&copy; OpenStreetMap contributors</a>\",\n  \"type\": \"baselayer\",\n  \"format\": \"pbf\",\n  \"bounds\": \"-34.49296,29.63555,46.75348,81.47299\",\n  \"center\": \"6.13026,55.55427,2\"\n}\n";
        IOException e = (IOException)org.junit.jupiter.api.Assertions.assertThrows(IOException.class, () -> PMTilesReader.parseMetadata((String)"{\n  \"name\": \"Shortbread\",\n  \"description\": \"A basic, lean, general-purpose vector tile schema for OpenStreetMap data. See https://shortbread.geofabrik.de/\",\n  \"attribution\": \"<a href=\"https://www.openstreetmap.org/copyright\" target=\"_blank\">&copy; OpenStreetMap contributors</a>\",\n  \"type\": \"baselayer\",\n  \"format\": \"pbf\",\n  \"bounds\": \"-34.49296,29.63555,46.75348,81.47299\",\n  \"center\": \"6.13026,55.55427,2\"\n}\n"));
        ((AbstractStringAssert)((AbstractStringAssert)Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"Failed to parse PMTiles metadata JSON:"})).contains(new CharSequence[]{"Unexpected character ('h' (code 104)): was expecting comma to separate Object entries"})).contains(new CharSequence[]{"{\n  \"name\": \"Shortbread\",\n  \"description\": \"A basic, lean, general-purpose vector tile schema for OpenStreetMap data. See https://shortbread.geofabrik.de/\",\n  \"attribution\": \"<a href=\"https://www.openstreetmap.org/copyright\" target=\"_blank\">&copy; OpenStreetMap contributors</a>\",\n  \"type\": \"baselayer\",\n  \"format\": \"pbf\",\n  \"bounds\": \"-34.49296,29.63555,46.75348,81.47299\",\n  \"center\": \"6.13026,55.55427,2\"\n}\n"});
    }
}

