/*
 * Decompiled with CFR 0.152.
 */
package io.tileverse.pmtiles;

import io.tileverse.pmtiles.HilbertCurve;
import io.tileverse.tiling.pyramid.TileIndex;
import java.util.HashSet;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;

class HilbertCurveTest {
    HilbertCurveTest() {
    }

    @ParameterizedTest
    @CsvSource(value={"0, 0, 0", "1, 0, 0", "1, 0, 1", "1, 1, 0", "1, 1, 1", "5, 16, 16", "7, 64, 47", "10, 512, 512", "12, 2048, 2048"})
    void testRoundTripConversion(int z, long x, long y) {
        TileIndex original = TileIndex.xyz((long)x, (long)y, (int)z);
        long tileId = HilbertCurve.tileIndexToTileId((TileIndex)original);
        TileIndex converted = HilbertCurve.tileIdToTileIndex((long)tileId);
        Assertions.assertEquals((int)original.z(), (int)converted.z(), (String)"Zoom level should match after round-trip");
        Assertions.assertEquals((long)original.x(), (long)converted.x(), (String)"X coordinate should match after round-trip");
        Assertions.assertEquals((long)original.y(), (long)converted.y(), (String)"Y coordinate should match after round-trip");
        Assertions.assertEquals((Object)original, (Object)converted, (String)"Complete TileIndex should match after round-trip");
    }

    @Test
    void testActualAndorraTilesWithHilbertCurve() {
        TileIndex[] actualTiles = new TileIndex[]{TileIndex.xyz((long)4L, (long)2L, (int)3), TileIndex.xyz((long)8L, (long)5L, (int)4), TileIndex.xyz((long)16L, (long)11L, (int)5), TileIndex.xyz((long)32L, (long)23L, (int)6), TileIndex.xyz((long)64L, (long)47L, (int)7), TileIndex.xyz((long)129L, (long)94L, (int)8), TileIndex.xyz((long)258L, (long)188L, (int)9), TileIndex.xyz((long)258L, (long)189L, (int)9), TileIndex.xyz((long)516L, (long)377L, (int)10), TileIndex.xyz((long)517L, (long)377L, (int)10), TileIndex.xyz((long)516L, (long)378L, (int)10), TileIndex.xyz((long)517L, (long)378L, (int)10)};
        System.out.println("=== Testing Actual Andorra Tiles with HilbertCurve ===");
        for (TileIndex expected : actualTiles) {
            System.out.printf("Testing tile %s%n", expected);
            long tileId = HilbertCurve.tileIndexToTileId((TileIndex)expected);
            TileIndex roundTrip = HilbertCurve.tileIdToTileIndex((long)tileId);
            System.out.printf("  Tile ID: %d%n", tileId);
            System.out.printf("  Round trip: %s%n", roundTrip);
            Assertions.assertEquals((int)expected.z(), (int)roundTrip.z(), (String)"Zoom level should match");
            Assertions.assertEquals((long)expected.x(), (long)roundTrip.x(), (String)"X coordinate should match");
            Assertions.assertEquals((long)expected.y(), (long)roundTrip.y(), (String)"Y coordinate should match");
        }
    }

    @Test
    void testTileIdEdgeCases() {
        TileIndex z0 = TileIndex.xyz((long)0L, (long)0L, (int)0);
        Assertions.assertEquals((long)0L, (long)HilbertCurve.tileIndexToTileId((TileIndex)z0), (String)"Zoom 0 tile should have ID 0");
        TileIndex z1first = TileIndex.xyz((long)0L, (long)0L, (int)1);
        Assertions.assertEquals((long)1L, (long)HilbertCurve.tileIndexToTileId((TileIndex)z1first), (String)"First tile at zoom 1 should have ID 1");
        long prevMaxTileId = 0L;
        for (int z = 1; z <= 10; ++z) {
            TileIndex firstTileAtZoom = TileIndex.xyz((long)0L, (long)0L, (int)z);
            long firstTileId = HilbertCurve.tileIndexToTileId((TileIndex)firstTileAtZoom);
            Assertions.assertTrue((firstTileId > prevMaxTileId ? 1 : 0) != 0, (String)("First tile at zoom " + z + " should have ID greater than previous zoom's max"));
            prevMaxTileId = firstTileId;
        }
    }

    @Test
    void testTileIdToTileIndexInvalidInputs() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> HilbertCurve.tileIdToTileIndex((long)-1L));
        Assertions.assertThrows(IllegalArgumentException.class, () -> HilbertCurve.tileIdToTileIndex((long)Long.MAX_VALUE));
    }

    @Test
    void testTileIdZoomTooLarge() {
        TileIndex invalidZoom = TileIndex.xyz((long)0L, (long)0L, (int)27);
        Assertions.assertThrows(IllegalArgumentException.class, () -> HilbertCurve.tileIndexToTileId((TileIndex)invalidZoom));
        TileIndex validMaxZoom = TileIndex.xyz((long)0L, (long)0L, (int)26);
        long tileId = HilbertCurve.tileIndexToTileId((TileIndex)validMaxZoom);
        Assertions.assertTrue((tileId >= 0L ? 1 : 0) != 0, (String)"Valid tile ID should be non-negative");
    }

    @Test
    void testSpatialLocality() {
        int z = 5;
        TileIndex center = TileIndex.xyz((long)16L, (long)16L, (int)z);
        TileIndex right = TileIndex.xyz((long)17L, (long)16L, (int)z);
        TileIndex down = TileIndex.xyz((long)16L, (long)17L, (int)z);
        long centerId = HilbertCurve.tileIndexToTileId((TileIndex)center);
        long rightId = HilbertCurve.tileIndexToTileId((TileIndex)right);
        long downId = HilbertCurve.tileIndexToTileId((TileIndex)down);
        Assertions.assertNotEquals((long)centerId, (long)rightId);
        Assertions.assertNotEquals((long)centerId, (long)downId);
        Assertions.assertNotEquals((long)rightId, (long)downId);
        long maxTilesAtZoom = (1L << z) * (1L << z);
        Assertions.assertTrue((Math.abs(rightId - centerId) < maxTilesAtZoom ? 1 : 0) != 0, (String)"Adjacent tiles should have reasonably close IDs");
        Assertions.assertTrue((Math.abs(downId - centerId) < maxTilesAtZoom ? 1 : 0) != 0, (String)"Adjacent tiles should have reasonably close IDs");
    }

    @Test
    void testUniqueTileIds() {
        int z = 3;
        long maxCoord = (1L << z) - 1L;
        HashSet<Long> tileIds = new HashSet<Long>();
        for (long x = 0L; x <= maxCoord; ++x) {
            for (long y = 0L; y <= maxCoord; ++y) {
                TileIndex tileIndex = TileIndex.xyz((long)x, (long)y, (int)z);
                long tileId = HilbertCurve.tileIndexToTileId((TileIndex)tileIndex);
                Assertions.assertTrue((boolean)tileIds.add(tileId), (String)("Tile ID " + tileId + " for coordinates (" + x + "," + y + ") should be unique"));
            }
        }
        long expectedTileCount = (1L << z) * (1L << z);
        Assertions.assertEquals((long)expectedTileCount, (long)tileIds.size(), (String)("Should have exactly " + expectedTileCount + " unique tile IDs at zoom " + z));
    }

    @Test
    void testCoordinateValidation() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> HilbertCurve.tileIndexToTileId((TileIndex)TileIndex.xyz((long)1L, (long)0L, (int)0)));
        Assertions.assertThrows(IllegalArgumentException.class, () -> HilbertCurve.tileIndexToTileId((TileIndex)TileIndex.xyz((long)32L, (long)0L, (int)5)));
        Assertions.assertThrows(IllegalArgumentException.class, () -> HilbertCurve.tileIndexToTileId((TileIndex)TileIndex.xyz((long)0L, (long)32L, (int)5)));
    }

    @Test
    void testSpecificProblemCases() {
        TileIndex problematic1 = TileIndex.xyz((long)34L, (long)51L, (int)7);
        long tileId1 = HilbertCurve.tileIndexToTileId((TileIndex)problematic1);
        TileIndex roundTrip1 = HilbertCurve.tileIdToTileIndex((long)tileId1);
        Assertions.assertEquals((Object)problematic1, (Object)roundTrip1);
        TileIndex problematic2 = TileIndex.xyz((long)64L, (long)64L, (int)7);
        long tileId2 = HilbertCurve.tileIndexToTileId((TileIndex)problematic2);
        TileIndex roundTrip2 = HilbertCurve.tileIdToTileIndex((long)tileId2);
        Assertions.assertEquals((Object)problematic2, (Object)roundTrip2);
    }
}

