/*
 * Decompiled with CFR 0.152.
 */
package io.tileverse.pmtiles;

import io.tileverse.pmtiles.InvalidHeaderException;
import io.tileverse.pmtiles.PMTilesHeader;
import io.tileverse.pmtiles.PMTilesReader;
import io.tileverse.pmtiles.UnsupportedCompressionException;
import io.tileverse.rangereader.RangeReader;
import io.tileverse.rangereader.azure.AzureBlobRangeReader;
import io.tileverse.rangereader.cache.CachingRangeReader;
import io.tileverse.rangereader.http.HttpRangeReader;
import io.tileverse.rangereader.s3.S3RangeReader;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.Optional;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.regions.Region;

@Tag(value="integration")
public class CloudStorageIntegrationTest {
    private static String s3Bucket;
    private static String s3Key;
    private static String s3Region;
    private static String azureConnectionString;
    private static String azureContainer;
    private static String azureBlob;
    private static String httpUrl;

    @BeforeAll
    public static void setup() {
        s3Bucket = System.getenv("TEST_S3_BUCKET");
        s3Key = System.getenv("TEST_S3_KEY");
        s3Region = System.getenv("TEST_S3_REGION");
        azureConnectionString = System.getenv("TEST_AZURE_CONNECTION_STRING");
        azureContainer = System.getenv("TEST_AZURE_CONTAINER");
        azureBlob = System.getenv("TEST_AZURE_BLOB");
        httpUrl = System.getenv("TEST_HTTP_URL");
    }

    @Test
    void testReadPMTilesFromS3() throws IOException, InvalidHeaderException, UnsupportedCompressionException {
        Assumptions.assumeTrue((s3Bucket != null && s3Key != null && s3Region != null ? 1 : 0) != 0, (String)"S3 test configuration not found in environment variables");
        URI s3Uri = URI.create("s3://" + s3Bucket + "/" + s3Key);
        try (S3RangeReader s3Reader = S3RangeReader.builder().uri(s3Uri).region(Region.of((String)s3Region)).credentialsProvider((AwsCredentialsProvider)DefaultCredentialsProvider.builder().build()).build();
             CachingRangeReader rangeReader = CachingRangeReader.builder((RangeReader)s3Reader).blockSize(16384).build();){
            PMTilesReader pmTilesReader = new PMTilesReader(() -> ((RangeReader)rangeReader).asByteChannel());
            PMTilesHeader header = pmTilesReader.getHeader();
            Assertions.assertNotNull((Object)header);
            System.out.println("PMTiles header: version=" + header.version() + ", minZoom=" + header.minZoom() + ", maxZoom=" + header.maxZoom());
            byte z = header.minZoom();
            Optional tileData = pmTilesReader.getTile((int)z, 0, 0);
            Assertions.assertTrue((boolean)tileData.isPresent(), (String)"Should be able to read a tile at minimum zoom level");
            System.out.println("Successfully read tile at z=" + z + " with size " + ((ByteBuffer)tileData.get()).remaining() + " bytes");
        }
    }

    @Test
    void testReadPMTilesFromAzure() throws IOException, InvalidHeaderException, UnsupportedCompressionException {
        Assumptions.assumeTrue((azureConnectionString != null && azureContainer != null && azureBlob != null ? 1 : 0) != 0, (String)"Azure test configuration not found in environment variables");
        try (AzureBlobRangeReader azureRangeReader = AzureBlobRangeReader.builder().connectionString(azureConnectionString).containerName(azureContainer).blobName(azureBlob).build();
             CachingRangeReader reader = CachingRangeReader.builder((RangeReader)azureRangeReader).blockSize(32768).build();){
            PMTilesReader pmTilesReader = new PMTilesReader(() -> ((RangeReader)reader).asByteChannel());
            PMTilesHeader header = pmTilesReader.getHeader();
            Assertions.assertNotNull((Object)header);
            System.out.println("PMTiles header: version=" + header.version() + ", minZoom=" + header.minZoom() + ", maxZoom=" + header.maxZoom());
            ByteBuffer metadata = pmTilesReader.getRawMetadata();
            Assertions.assertNotNull((Object)metadata);
            Assertions.assertTrue((metadata.remaining() > 0 ? 1 : 0) != 0, (String)"Metadata should not be empty");
            System.out.println("Successfully read metadata with size " + metadata.remaining() + " bytes");
            System.out.println("Metadata preview: " + pmTilesReader.getMetadataAsString() + "...");
        }
    }

    @Test
    void testReadPMTilesFromHttp() throws IOException, InvalidHeaderException, UnsupportedCompressionException {
        Assumptions.assumeTrue((httpUrl != null ? 1 : 0) != 0, (String)"HTTP test configuration not found in environment variables");
        URI httpUri = URI.create(httpUrl);
        try (HttpRangeReader httpRangeReader = HttpRangeReader.builder((URI)httpUri).trustAllCertificates().build();
             CachingRangeReader rangeReader = CachingRangeReader.builder((RangeReader)httpRangeReader).build();){
            PMTilesReader pmTilesReader = new PMTilesReader(() -> ((RangeReader)rangeReader).asByteChannel());
            PMTilesHeader header = pmTilesReader.getHeader();
            Assertions.assertNotNull((Object)header);
            System.out.println("PMTiles header: version=" + header.version() + ", minZoom=" + header.minZoom() + ", maxZoom=" + header.maxZoom());
            int z = header.minZoom() + 1;
            if (z <= header.maxZoom()) {
                Optional tileData = pmTilesReader.getTile(z, 0, 0);
                Assertions.assertTrue((boolean)tileData.isPresent(), (String)("Should be able to read a tile at zoom level " + z));
                System.out.println("Successfully read tile at z=" + z + " with size " + ((ByteBuffer)tileData.get()).remaining() + " bytes");
            }
        }
    }
}

