/*
 * Decompiled with CFR 0.152.
 */
package io.tileverse.pmtiles;

import io.tileverse.pmtiles.ByteBufferInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ByteBufferInputStreamTest {
    private static final byte[] TEST_DATA = "Hello, World! This is test data for ByteBufferInputStream.".getBytes();

    ByteBufferInputStreamTest() {
    }

    @Test
    void testBasicConstruction() {
        ByteBuffer buffer = ByteBuffer.wrap(TEST_DATA);
        try (ByteBufferInputStream stream = new ByteBufferInputStream(TEST_DATA.length, buffer);){
            Assertions.assertTrue((boolean)stream.isOpen());
            Assertions.assertEquals((int)TEST_DATA.length, (int)stream.available());
            Assertions.assertEquals((int)0, (int)stream.position());
            Assertions.assertTrue((boolean)stream.hasRemaining());
        }
    }

    @Test
    void testSimplifiedConstruction() {
        ByteBuffer buffer = ByteBuffer.wrap(TEST_DATA);
        try (ByteBufferInputStream stream = new ByteBufferInputStream(buffer);){
            Assertions.assertTrue((boolean)stream.isOpen());
            Assertions.assertEquals((int)TEST_DATA.length, (int)stream.available());
            Assertions.assertEquals((int)0, (int)stream.position());
            Assertions.assertTrue((boolean)stream.hasRemaining());
        }
    }

    @Test
    void testConstructorValidation() {
        ByteBuffer buffer = ByteBuffer.wrap(TEST_DATA);
        Assertions.assertThrows(IllegalArgumentException.class, () -> new ByteBufferInputStream(-1, buffer));
        Assertions.assertThrows(IllegalArgumentException.class, () -> new ByteBufferInputStream(10, null));
        Assertions.assertThrows(IllegalArgumentException.class, () -> new ByteBufferInputStream(null));
    }

    @Test
    void testSingleByteRead() throws IOException {
        ByteBuffer buffer = ByteBuffer.wrap(TEST_DATA);
        try (ByteBufferInputStream stream = new ByteBufferInputStream(buffer);){
            int firstByte = stream.read();
            Assertions.assertEquals((int)(TEST_DATA[0] & 0xFF), (int)firstByte);
            Assertions.assertEquals((int)(TEST_DATA.length - 1), (int)stream.available());
            Assertions.assertEquals((int)1, (int)stream.position());
        }
    }

    @Test
    void testReadUntilEOF() throws IOException {
        ByteBuffer buffer = ByteBuffer.wrap(TEST_DATA);
        try (ByteBufferInputStream stream = new ByteBufferInputStream(buffer);){
            int b;
            int bytesRead = 0;
            while ((b = stream.read()) != -1) {
                Assertions.assertEquals((int)(TEST_DATA[bytesRead] & 0xFF), (int)b);
                ++bytesRead;
            }
            Assertions.assertEquals((int)TEST_DATA.length, (int)bytesRead);
            Assertions.assertEquals((int)-1, (int)stream.read());
        }
    }

    @Test
    void testArrayRead() throws IOException {
        ByteBuffer buffer = ByteBuffer.wrap(TEST_DATA);
        try (ByteBufferInputStream stream = new ByteBufferInputStream(buffer);){
            byte[] readBuffer = new byte[10];
            int bytesRead = stream.read(readBuffer, 0, 10);
            Assertions.assertEquals((int)10, (int)bytesRead);
            for (int i = 0; i < 10; ++i) {
                Assertions.assertEquals((byte)TEST_DATA[i], (byte)readBuffer[i]);
            }
            Assertions.assertEquals((int)(TEST_DATA.length - 10), (int)stream.available());
        }
    }

    @Test
    void testArrayReadAtEOF() throws IOException {
        ByteBuffer buffer = ByteBuffer.wrap(TEST_DATA);
        try (ByteBufferInputStream stream = new ByteBufferInputStream(buffer);){
            byte[] allData = new byte[TEST_DATA.length];
            int bytesRead = stream.read(allData);
            Assertions.assertEquals((int)TEST_DATA.length, (int)bytesRead);
            byte[] extra = new byte[10];
            Assertions.assertEquals((int)-1, (int)stream.read(extra));
        }
    }

    @Test
    void testArrayReadValidation() throws IOException {
        ByteBuffer buffer = ByteBuffer.wrap(TEST_DATA);
        try (ByteBufferInputStream stream = new ByteBufferInputStream(buffer);){
            byte[] readBuffer = new byte[10];
            Assertions.assertThrows(IllegalArgumentException.class, () -> stream.read(readBuffer, 0, -1));
            Assertions.assertThrows(IllegalArgumentException.class, () -> stream.read(null, 0, 5));
            Assertions.assertThrows(IndexOutOfBoundsException.class, () -> stream.read(readBuffer, -1, 5));
            Assertions.assertThrows(IndexOutOfBoundsException.class, () -> stream.read(readBuffer, 15, 5));
            Assertions.assertThrows(IndexOutOfBoundsException.class, () -> stream.read(readBuffer, 5, 10));
        }
    }

    @Test
    void testSkip() throws IOException {
        ByteBuffer buffer = ByteBuffer.wrap(TEST_DATA);
        try (ByteBufferInputStream stream = new ByteBufferInputStream(buffer);){
            Assertions.assertEquals((int)0, (int)stream.position());
            long skipped = stream.skip(5L);
            Assertions.assertEquals((long)5L, (long)skipped);
            Assertions.assertEquals((int)5, (int)stream.position());
            int nextByte = stream.read();
            Assertions.assertEquals((int)(TEST_DATA[5] & 0xFF), (int)nextByte);
        }
    }

    @Test
    void testSkipValidation() throws IOException {
        ByteBuffer buffer = ByteBuffer.wrap(TEST_DATA);
        try (ByteBufferInputStream stream = new ByteBufferInputStream(buffer);){
            Assertions.assertThrows(EOFException.class, () -> stream.skip(-1L));
            Assertions.assertThrows(EOFException.class, () -> stream.skip((long)(TEST_DATA.length + 1)));
        }
    }

    @Test
    void testMarkAndReset() throws IOException {
        ByteBuffer buffer = ByteBuffer.wrap(TEST_DATA);
        try (ByteBufferInputStream stream = new ByteBufferInputStream(buffer);){
            Assertions.assertTrue((boolean)stream.markSupported());
            stream.read();
            stream.read();
            Assertions.assertEquals((int)2, (int)stream.position());
            stream.mark(100);
            int markedPosition = stream.position();
            stream.read();
            stream.read();
            Assertions.assertEquals((int)4, (int)stream.position());
            stream.reset();
            Assertions.assertEquals((int)markedPosition, (int)stream.position());
            int nextByte = stream.read();
            Assertions.assertEquals((int)(TEST_DATA[2] & 0xFF), (int)nextByte);
        }
    }

    @Test
    void testResetWithoutMark() throws IOException {
        ByteBuffer buffer = ByteBuffer.wrap(TEST_DATA);
        try (ByteBufferInputStream stream = new ByteBufferInputStream(buffer);){
            Assertions.assertThrows(IOException.class, () -> ((ByteBufferInputStream)stream).reset());
        }
    }

    @Test
    void testClose() throws IOException {
        ByteBuffer buffer = ByteBuffer.wrap(TEST_DATA);
        ByteBufferInputStream stream = new ByteBufferInputStream(buffer);
        Assertions.assertTrue((boolean)stream.isOpen());
        stream.close();
        Assertions.assertFalse((boolean)stream.isOpen());
        Assertions.assertThrows(IllegalStateException.class, () -> ((ByteBufferInputStream)stream).read());
        Assertions.assertThrows(IOException.class, () -> stream.read(new byte[10]));
        Assertions.assertThrows(IOException.class, () -> stream.skip(5L));
        Assertions.assertThrows(IllegalStateException.class, () -> ((ByteBufferInputStream)stream).available());
        Assertions.assertThrows(IllegalStateException.class, () -> ((ByteBufferInputStream)stream).position());
        Assertions.assertThrows(IllegalStateException.class, () -> ((ByteBufferInputStream)stream).hasRemaining());
        Assertions.assertThrows(IllegalStateException.class, () -> stream.mark(10));
        Assertions.assertThrows(IllegalStateException.class, () -> ((ByteBufferInputStream)stream).reset());
    }

    @Test
    void testPartialBufferRead() throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(100);
        buffer.put(TEST_DATA);
        buffer.flip();
        try (ByteBufferInputStream stream = new ByteBufferInputStream(buffer);){
            Assertions.assertEquals((int)TEST_DATA.length, (int)stream.available());
            byte[] readData = new byte[TEST_DATA.length];
            int bytesRead = stream.read(readData);
            Assertions.assertEquals((int)TEST_DATA.length, (int)bytesRead);
            Assertions.assertArrayEquals((byte[])TEST_DATA, (byte[])readData);
            Assertions.assertEquals((int)0, (int)stream.available());
        }
    }

    @Test
    void testToString() {
        ByteBuffer buffer = ByteBuffer.wrap(TEST_DATA);
        try (ByteBufferInputStream stream = new ByteBufferInputStream(buffer);){
            String str = stream.toString();
            Assertions.assertTrue((boolean)str.contains("ByteBufferInputStream"));
            Assertions.assertTrue((boolean)str.contains("size=" + TEST_DATA.length));
            Assertions.assertTrue((boolean)str.contains("available=" + TEST_DATA.length));
        }
    }

    @Test
    void testToStringAfterClose() {
        ByteBuffer buffer = ByteBuffer.wrap(TEST_DATA);
        ByteBufferInputStream stream = new ByteBufferInputStream(buffer);
        stream.close();
        String str = stream.toString();
        Assertions.assertTrue((boolean)str.contains("ByteBufferInputStream"));
        Assertions.assertTrue((boolean)str.contains("size=" + TEST_DATA.length));
        Assertions.assertFalse((boolean)str.contains("available="));
    }

    @Test
    void testThreadSafety() throws InterruptedException {
        ByteBuffer buffer = ByteBuffer.wrap(TEST_DATA);
        ByteBufferInputStream stream = new ByteBufferInputStream(buffer);
        Thread[] threads = new Thread[5];
        Exception[] exceptions = new Exception[5];
        for (int i = 0; i < threads.length; ++i) {
            int threadIndex = i;
            threads[i] = new Thread(() -> {
                try {
                    stream.available();
                    stream.position();
                    stream.hasRemaining();
                    stream.mark(10);
                }
                catch (Exception e) {
                    exceptions[threadIndex] = e;
                }
            });
        }
        for (Thread thread : threads) {
            thread.start();
        }
        for (Thread thread : threads) {
            thread.join();
        }
        for (Exception e : exceptions) {
            if (e == null) continue;
            Assertions.fail((String)"Thread safety test failed", (Throwable)e);
        }
        stream.close();
    }
}

