/*
 * Decompiled with CFR 0.152.
 */
package io.tileverse.jackson.databind.tilejson.v3;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.tileverse.jackson.databind.tilejson.v3.VectorLayer;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class VectorLayerTest {
    private final ObjectMapper objectMapper = new ObjectMapper();

    VectorLayerTest() {
    }

    @Test
    void testMinimalVectorLayer() throws Exception {
        Map<String, String> fields = Map.of("name", "String", "type", "String");
        VectorLayer layer = VectorLayer.of((String)"buildings", fields);
        Assertions.assertEquals((Object)"buildings", (Object)layer.id());
        Assertions.assertEquals(fields, (Object)layer.fields());
        Assertions.assertNull((Object)layer.description());
        Assertions.assertNull((Object)layer.minZoom());
        Assertions.assertNull((Object)layer.maxZoom());
        String json = this.objectMapper.writeValueAsString((Object)layer);
        Assertions.assertTrue((boolean)json.contains("\"id\":\"buildings\""));
        Assertions.assertTrue((boolean)json.contains("\"fields\":{"));
        Assertions.assertTrue((boolean)json.contains("\"name\":\"String\""));
        VectorLayer deserialized = (VectorLayer)this.objectMapper.readValue(json, VectorLayer.class);
        Assertions.assertEquals((Object)layer.id(), (Object)deserialized.id());
        Assertions.assertEquals((Object)layer.fields(), (Object)deserialized.fields());
    }

    @Test
    void testCompleteVectorLayer() throws Exception {
        Map<String, String> fields = Map.of("name", "String", "height", "Number", "residential", "Boolean");
        VectorLayer layer = VectorLayer.of((String)"buildings", fields, (String)"Building footprints", (Integer)12, (Integer)18);
        Assertions.assertEquals((Object)"buildings", (Object)layer.id());
        Assertions.assertEquals(fields, (Object)layer.fields());
        Assertions.assertEquals((Object)"Building footprints", (Object)layer.description());
        Assertions.assertEquals((Integer)12, (Integer)layer.minZoom());
        Assertions.assertEquals((Integer)18, (Integer)layer.maxZoom());
        String json = this.objectMapper.writeValueAsString((Object)layer);
        VectorLayer deserialized = (VectorLayer)this.objectMapper.readValue(json, VectorLayer.class);
        Assertions.assertEquals((Object)layer.id(), (Object)deserialized.id());
        Assertions.assertEquals((Object)layer.fields(), (Object)deserialized.fields());
        Assertions.assertEquals((Object)layer.description(), (Object)deserialized.description());
        Assertions.assertEquals((Integer)layer.minZoom(), (Integer)deserialized.minZoom());
        Assertions.assertEquals((Integer)layer.maxZoom(), (Integer)deserialized.maxZoom());
    }

    @Test
    void testRequiredFieldValidation() {
        Map<String, String> fields = Map.of("name", "String");
        Assertions.assertThrows(IllegalArgumentException.class, () -> VectorLayer.of(null, (Map)fields));
        Assertions.assertThrows(IllegalArgumentException.class, () -> VectorLayer.of((String)"", (Map)fields));
        Assertions.assertThrows(IllegalArgumentException.class, () -> VectorLayer.of((String)"   ", (Map)fields));
        Assertions.assertThrows(IllegalArgumentException.class, () -> VectorLayer.of((String)"test", null));
        Assertions.assertDoesNotThrow(() -> VectorLayer.of((String)"test", (Map)fields));
    }

    @Test
    void testZoomValidation() {
        Map<String, String> fields = Map.of("name", "String");
        Assertions.assertThrows(IllegalArgumentException.class, () -> VectorLayer.of((String)"test", (Map)fields, null, (Integer)-1, (Integer)10));
        Assertions.assertThrows(IllegalArgumentException.class, () -> VectorLayer.of((String)"test", (Map)fields, null, (Integer)31, (Integer)10));
        Assertions.assertThrows(IllegalArgumentException.class, () -> VectorLayer.of((String)"test", (Map)fields, null, (Integer)5, (Integer)-1));
        Assertions.assertThrows(IllegalArgumentException.class, () -> VectorLayer.of((String)"test", (Map)fields, null, (Integer)5, (Integer)31));
        Assertions.assertThrows(IllegalArgumentException.class, () -> VectorLayer.of((String)"test", (Map)fields, null, (Integer)10, (Integer)5));
        Assertions.assertDoesNotThrow(() -> VectorLayer.of((String)"test", (Map)fields, null, (Integer)0, (Integer)30));
        Assertions.assertDoesNotThrow(() -> VectorLayer.of((String)"test", (Map)fields, null, (Integer)5, (Integer)5));
        Assertions.assertDoesNotThrow(() -> VectorLayer.of((String)"test", (Map)fields, null, null, (Integer)10));
        Assertions.assertDoesNotThrow(() -> VectorLayer.of((String)"test", (Map)fields, null, (Integer)5, null));
    }

    @Test
    void testBuilderMethods() {
        Map<String, String> originalFields = Map.of("name", "String");
        Map<String, String> newFields = Map.of("name", "String", "type", "String");
        VectorLayer original = VectorLayer.of((String)"test", originalFields);
        VectorLayer modified = original.withDescription("Test description").withZoomRange(Integer.valueOf(5), Integer.valueOf(15)).withFields(newFields);
        Assertions.assertEquals((Object)"test", (Object)modified.id());
        Assertions.assertEquals((Object)"Test description", (Object)modified.description());
        Assertions.assertEquals((Integer)5, (Integer)modified.minZoom());
        Assertions.assertEquals((Integer)15, (Integer)modified.maxZoom());
        Assertions.assertEquals(newFields, (Object)modified.fields());
        Assertions.assertNull((Object)original.description());
        Assertions.assertNull((Object)original.minZoom());
        Assertions.assertNull((Object)original.maxZoom());
        Assertions.assertEquals(originalFields, (Object)original.fields());
    }

    @Test
    void testBuilderValidation() {
        Map<String, String> fields = Map.of("name", "String");
        VectorLayer layer = VectorLayer.of((String)"test", fields);
        Assertions.assertThrows(IllegalArgumentException.class, () -> layer.withZoomRange(Integer.valueOf(-1), Integer.valueOf(10)));
        Assertions.assertThrows(IllegalArgumentException.class, () -> layer.withZoomRange(Integer.valueOf(10), Integer.valueOf(31)));
        Assertions.assertThrows(IllegalArgumentException.class, () -> layer.withZoomRange(Integer.valueOf(15), Integer.valueOf(5)));
        Assertions.assertThrows(IllegalArgumentException.class, () -> layer.withFields(null));
    }

    @Test
    void testJSONDeserialization() throws Exception {
        String json = "{\n    \"id\": \"roads\",\n    \"fields\": {\n        \"name\": \"String\",\n        \"highway\": \"String\",\n        \"oneway\": \"Boolean\",\n        \"lanes\": \"Number\"\n    },\n    \"description\": \"Road network data\",\n    \"minzoom\": 6,\n    \"maxzoom\": 18,\n    \"unknown_property\": \"should be ignored\"\n}\n";
        VectorLayer layer = (VectorLayer)this.objectMapper.readValue(json, VectorLayer.class);
        Assertions.assertEquals((Object)"roads", (Object)layer.id());
        Assertions.assertEquals((Object)"Road network data", (Object)layer.description());
        Assertions.assertEquals((Integer)6, (Integer)layer.minZoom());
        Assertions.assertEquals((Integer)18, (Integer)layer.maxZoom());
        Assertions.assertNotNull((Object)layer.fields());
        Assertions.assertEquals((int)4, (int)layer.fields().size());
        Assertions.assertEquals((Object)"String", layer.fields().get("name"));
        Assertions.assertEquals((Object)"String", layer.fields().get("highway"));
        Assertions.assertEquals((Object)"Boolean", layer.fields().get("oneway"));
        Assertions.assertEquals((Object)"Number", layer.fields().get("lanes"));
    }

    @Test
    void testEmptyFields() throws Exception {
        Map emptyFields = Map.of();
        VectorLayer layer = VectorLayer.of((String)"buildings", emptyFields);
        Assertions.assertEquals((Object)"buildings", (Object)layer.id());
        Assertions.assertTrue((boolean)layer.fields().isEmpty());
        String json = this.objectMapper.writeValueAsString((Object)layer);
        VectorLayer deserialized = (VectorLayer)this.objectMapper.readValue(json, VectorLayer.class);
        Assertions.assertEquals((Object)layer.id(), (Object)deserialized.id());
        Assertions.assertTrue((boolean)deserialized.fields().isEmpty());
    }

    @Test
    void testFieldTypes() throws Exception {
        Map<String, String> fields = Map.of("id", "Number", "name", "String", "visible", "Boolean", "area", "Number", "tags", "String", "custom_type", "CustomType");
        VectorLayer layer = VectorLayer.of((String)"features", fields);
        String json = this.objectMapper.writeValueAsString((Object)layer);
        VectorLayer deserialized = (VectorLayer)this.objectMapper.readValue(json, VectorLayer.class);
        Assertions.assertEquals(fields, (Object)deserialized.fields());
        Assertions.assertEquals((Object)"Number", deserialized.fields().get("id"));
        Assertions.assertEquals((Object)"String", deserialized.fields().get("name"));
        Assertions.assertEquals((Object)"Boolean", deserialized.fields().get("visible"));
        Assertions.assertEquals((Object)"CustomType", deserialized.fields().get("custom_type"));
    }
}

