/*
 * Decompiled with CFR 0.152.
 */
package io.tileverse.jackson.databind.tilejson.v3;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.tileverse.jackson.databind.tilejson.v3.TilesetType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TilesetTypeTest {
    private final ObjectMapper objectMapper = new ObjectMapper();

    TilesetTypeTest() {
    }

    @Test
    void testEnumValues() {
        Assertions.assertEquals((Object)"baselayer", (Object)TilesetType.BASELAYER.getValue());
        Assertions.assertEquals((Object)"overlay", (Object)TilesetType.OVERLAY.getValue());
        Assertions.assertEquals((Object)"baselayer", (Object)TilesetType.BASELAYER.toString());
        Assertions.assertEquals((Object)"overlay", (Object)TilesetType.OVERLAY.toString());
    }

    @Test
    void testFromValueCaseSensitivity() {
        Assertions.assertEquals((Object)TilesetType.BASELAYER, (Object)TilesetType.fromValue((String)"baselayer"));
        Assertions.assertEquals((Object)TilesetType.OVERLAY, (Object)TilesetType.fromValue((String)"overlay"));
        Assertions.assertEquals((Object)TilesetType.BASELAYER, (Object)TilesetType.fromValue((String)"BASELAYER"));
        Assertions.assertEquals((Object)TilesetType.BASELAYER, (Object)TilesetType.fromValue((String)"BaseLayer"));
        Assertions.assertEquals((Object)TilesetType.OVERLAY, (Object)TilesetType.fromValue((String)"OVERLAY"));
        Assertions.assertEquals((Object)TilesetType.OVERLAY, (Object)TilesetType.fromValue((String)"Overlay"));
        Assertions.assertEquals((Object)TilesetType.BASELAYER, (Object)TilesetType.fromValue((String)"  baselayer  "));
        Assertions.assertEquals((Object)TilesetType.OVERLAY, (Object)TilesetType.fromValue((String)"  overlay  "));
    }

    @Test
    void testFromValueUnknownValues() {
        Assertions.assertNull((Object)TilesetType.fromValue((String)"unknown"));
        Assertions.assertNull((Object)TilesetType.fromValue((String)"custom"));
        Assertions.assertNull((Object)TilesetType.fromValue((String)"baselayers"));
        Assertions.assertNull((Object)TilesetType.fromValue((String)"overlays"));
        Assertions.assertNull((Object)TilesetType.fromValue((String)""));
        Assertions.assertNull((Object)TilesetType.fromValue((String)"   "));
        Assertions.assertNull((Object)TilesetType.fromValue(null));
    }

    @Test
    void testJacksonSerialization() throws Exception {
        String baselayerJson = this.objectMapper.writeValueAsString((Object)TilesetType.BASELAYER);
        Assertions.assertEquals((Object)"\"baselayer\"", (Object)baselayerJson);
        String overlayJson = this.objectMapper.writeValueAsString((Object)TilesetType.OVERLAY);
        Assertions.assertEquals((Object)"\"overlay\"", (Object)overlayJson);
    }

    @Test
    void testJacksonDeserialization() throws Exception {
        TilesetType baselayer = (TilesetType)this.objectMapper.readValue("\"baselayer\"", TilesetType.class);
        Assertions.assertEquals((Object)TilesetType.BASELAYER, (Object)baselayer);
        TilesetType overlay = (TilesetType)this.objectMapper.readValue("\"overlay\"", TilesetType.class);
        Assertions.assertEquals((Object)TilesetType.OVERLAY, (Object)overlay);
        TilesetType baselayerUpper = (TilesetType)this.objectMapper.readValue("\"BASELAYER\"", TilesetType.class);
        Assertions.assertEquals((Object)TilesetType.BASELAYER, (Object)baselayerUpper);
    }

    @Test
    void testJacksonDeserializationUnknownValues() throws Exception {
        TilesetType unknown = (TilesetType)this.objectMapper.readValue("\"unknown_type\"", TilesetType.class);
        Assertions.assertNull((Object)unknown);
        TilesetType empty = (TilesetType)this.objectMapper.readValue("\"\"", TilesetType.class);
        Assertions.assertNull((Object)empty);
    }

    @Test
    void testJacksonInObjectContext() throws Exception {
        String json = "{\n    \"name\": \"Test Map\",\n    \"type\": \"baselayer\"\n}\n";
        record TestMetadata(String name, TilesetType type) {
        }
        TestMetadata metadata = (TestMetadata)this.objectMapper.readValue(json, TestMetadata.class);
        Assertions.assertEquals((Object)"Test Map", (Object)metadata.name());
        Assertions.assertEquals((Object)TilesetType.BASELAYER, (Object)metadata.type());
        String serialized = this.objectMapper.writeValueAsString((Object)metadata);
        Assertions.assertTrue((boolean)serialized.contains("\"type\":\"baselayer\""));
    }

    @Test
    void testJacksonInObjectContextUnknownValue() throws Exception {
        String json = "{\n    \"name\": \"Test Map\",\n    \"type\": \"unknown_type\"\n}\n";
        record TestMetadata(String name, TilesetType type) {
        }
        TestMetadata metadata = (TestMetadata)this.objectMapper.readValue(json, TestMetadata.class);
        Assertions.assertEquals((Object)"Test Map", (Object)metadata.name());
        Assertions.assertNull((Object)metadata.type());
    }

    @Test
    void testAllEnumValues() {
        TilesetType[] values = TilesetType.values();
        Assertions.assertEquals((int)2, (int)values.length);
        boolean hasBaselayer = false;
        boolean hasOverlay = false;
        block4: for (TilesetType type : values) {
            switch (type) {
                case BASELAYER: {
                    hasBaselayer = true;
                    continue block4;
                }
                case OVERLAY: {
                    hasOverlay = true;
                }
            }
        }
        Assertions.assertTrue((boolean)hasBaselayer, (String)"Should have BASELAYER enum value");
        Assertions.assertTrue((boolean)hasOverlay, (String)"Should have OVERLAY enum value");
    }

    @Test
    void testRoundTripSerialization() throws Exception {
        for (TilesetType type : TilesetType.values()) {
            String json = this.objectMapper.writeValueAsString((Object)type);
            TilesetType deserialized = (TilesetType)this.objectMapper.readValue(json, TilesetType.class);
            Assertions.assertEquals((Object)type, (Object)deserialized, (String)("Round-trip serialization failed for " + String.valueOf(type)));
        }
    }
}

