/*
 * Decompiled with CFR 0.152.
 */
package io.tileverse.jackson.databind.tilejson.v3;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.tileverse.jackson.databind.tilejson.v3.TileJSON;
import io.tileverse.jackson.databind.tilejson.v3.VectorLayer;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TileJSONTest {
    private final ObjectMapper objectMapper = new ObjectMapper();

    TileJSONTest() {
    }

    @Test
    void testMinimalTileJSON() throws Exception {
        VectorLayer layer = VectorLayer.of((String)"test", Map.of("name", "string"));
        TileJSON tileJSON = TileJSON.of((String)"3.0.0", List.of("https://example.com/{z}/{x}/{y}.pbf"), List.of(layer));
        Assertions.assertEquals((Object)"3.0.0", (Object)tileJSON.tilejson());
        Assertions.assertEquals((int)1, (int)tileJSON.tiles().size());
        Assertions.assertEquals((Object)"https://example.com/{z}/{x}/{y}.pbf", tileJSON.tiles().get(0));
        Assertions.assertEquals((int)1, (int)tileJSON.vectorLayers().size());
        Assertions.assertEquals((Object)"test", (Object)((VectorLayer)tileJSON.vectorLayers().get(0)).id());
        String json = this.objectMapper.writeValueAsString((Object)tileJSON);
        Assertions.assertTrue((boolean)json.contains("\"tilejson\":\"3.0.0\""));
        Assertions.assertTrue((boolean)json.contains("\"tiles\":[\"https://example.com/{z}/{x}/{y}.pbf\"]"));
        Assertions.assertTrue((boolean)json.contains("\"vector_layers\""));
        TileJSON deserialized = (TileJSON)this.objectMapper.readValue(json, TileJSON.class);
        Assertions.assertEquals((Object)tileJSON.tilejson(), (Object)deserialized.tilejson());
        Assertions.assertEquals((Object)tileJSON.tiles(), (Object)deserialized.tiles());
        Assertions.assertEquals((Object)((VectorLayer)tileJSON.vectorLayers().get(0)).id(), (Object)((VectorLayer)deserialized.vectorLayers().get(0)).id());
    }

    @Test
    void testCompleteTileJSON() throws Exception {
        VectorLayer buildings = VectorLayer.of((String)"buildings", Map.of("height", "Number", "type", "String"), (String)"Building footprints").withZoomRange(Integer.valueOf(12), Integer.valueOf(18));
        VectorLayer roads = VectorLayer.of((String)"roads", Map.of("name", "String", "highway", "String"), (String)"Road network").withZoomRange(Integer.valueOf(6), Integer.valueOf(18));
        TileJSON tileJSON = TileJSON.of((String)"3.0.0", List.of("https://tile1.example.com/{z}/{x}/{y}.pbf", "https://tile2.example.com/{z}/{x}/{y}.pbf"), List.of(buildings, roads), (String)"Test Tileset", (String)"A comprehensive test tileset", (String)"\u00a9 Test Contributors").withBounds(-180.0, -85.0, 180.0, 85.0).withCenter(-74.0059, 40.7128, Double.valueOf(10.0)).withZoomRange(Integer.valueOf(0), Integer.valueOf(18)).withVersion("1.0.0");
        Assertions.assertEquals((Object)"3.0.0", (Object)tileJSON.tilejson());
        Assertions.assertEquals((Object)"Test Tileset", (Object)tileJSON.name());
        Assertions.assertEquals((Object)"A comprehensive test tileset", (Object)tileJSON.description());
        Assertions.assertEquals((Object)"\u00a9 Test Contributors", (Object)tileJSON.attribution());
        Assertions.assertEquals((Object)"1.0.0", (Object)tileJSON.version());
        Assertions.assertEquals((int)2, (int)tileJSON.tiles().size());
        Assertions.assertEquals((Object)"https://tile1.example.com/{z}/{x}/{y}.pbf", tileJSON.tiles().get(0));
        Assertions.assertEquals((Object)"https://tile2.example.com/{z}/{x}/{y}.pbf", tileJSON.tiles().get(1));
        Assertions.assertEquals((int)4, (int)tileJSON.bounds().size());
        Assertions.assertEquals((double)-180.0, (Double)((Double)tileJSON.bounds().get(0)));
        Assertions.assertEquals((double)-85.0, (Double)((Double)tileJSON.bounds().get(1)));
        Assertions.assertEquals((double)180.0, (Double)((Double)tileJSON.bounds().get(2)));
        Assertions.assertEquals((double)85.0, (Double)((Double)tileJSON.bounds().get(3)));
        Assertions.assertEquals((int)3, (int)tileJSON.center().size());
        Assertions.assertEquals((double)-74.0059, (Double)((Double)tileJSON.center().get(0)));
        Assertions.assertEquals((double)40.7128, (Double)((Double)tileJSON.center().get(1)));
        Assertions.assertEquals((double)10.0, (Double)((Double)tileJSON.center().get(2)));
        Assertions.assertEquals((Integer)0, (Integer)tileJSON.minzoom());
        Assertions.assertEquals((Integer)18, (Integer)tileJSON.maxzoom());
        Assertions.assertEquals((int)2, (int)tileJSON.vectorLayers().size());
        Assertions.assertEquals((Object)"buildings", (Object)((VectorLayer)tileJSON.vectorLayers().get(0)).id());
        Assertions.assertEquals((Object)"roads", (Object)((VectorLayer)tileJSON.vectorLayers().get(1)).id());
        String json = this.objectMapper.writeValueAsString((Object)tileJSON);
        TileJSON deserialized = (TileJSON)this.objectMapper.readValue(json, TileJSON.class);
        Assertions.assertEquals((Object)tileJSON.tilejson(), (Object)deserialized.tilejson());
        Assertions.assertEquals((Object)tileJSON.name(), (Object)deserialized.name());
        Assertions.assertEquals((Object)tileJSON.description(), (Object)deserialized.description());
        Assertions.assertEquals((Object)tileJSON.attribution(), (Object)deserialized.attribution());
        Assertions.assertEquals((Object)tileJSON.bounds(), (Object)deserialized.bounds());
        Assertions.assertEquals((Object)tileJSON.center(), (Object)deserialized.center());
        Assertions.assertEquals((Integer)tileJSON.minzoom(), (Integer)deserialized.minzoom());
        Assertions.assertEquals((Integer)tileJSON.maxzoom(), (Integer)deserialized.maxzoom());
        Assertions.assertEquals((int)tileJSON.vectorLayers().size(), (int)deserialized.vectorLayers().size());
    }

    @Test
    void testRequiredFieldValidation() {
        VectorLayer layer = VectorLayer.of((String)"test", Map.of("name", "string"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> TileJSON.of(null, List.of("https://example.com/{z}/{x}/{y}.pbf"), List.of(layer)));
        Assertions.assertThrows(IllegalArgumentException.class, () -> TileJSON.of((String)"", List.of("https://example.com/{z}/{x}/{y}.pbf"), List.of(layer)));
        Assertions.assertThrows(IllegalArgumentException.class, () -> TileJSON.of((String)"3.0.0", null, List.of(layer)));
        Assertions.assertThrows(IllegalArgumentException.class, () -> TileJSON.of((String)"3.0.0", List.of(), List.of(layer)));
        Assertions.assertThrows(IllegalArgumentException.class, () -> TileJSON.of((String)"3.0.0", Arrays.asList(new String[]{null}), List.of(layer)));
        Assertions.assertThrows(IllegalArgumentException.class, () -> TileJSON.of((String)"3.0.0", List.of(""), List.of(layer)));
        Assertions.assertThrows(IllegalArgumentException.class, () -> TileJSON.of((String)"3.0.0", List.of("https://example.com/{z}/{x}/{y}.pbf"), null));
    }

    @Test
    void testBoundsValidation() {
        VectorLayer layer = VectorLayer.of((String)"test", Map.of("name", "string"));
        TileJSON tileJSON = TileJSON.of((String)"3.0.0", List.of("https://example.com/{z}/{x}/{y}.pbf"), List.of(layer));
        Assertions.assertThrows(IllegalArgumentException.class, () -> tileJSON.withBounds(10.0, -85.0, 10.0, 85.0));
        Assertions.assertThrows(IllegalArgumentException.class, () -> tileJSON.withBounds(10.0, -85.0, -10.0, 85.0));
        Assertions.assertThrows(IllegalArgumentException.class, () -> tileJSON.withBounds(-180.0, 85.0, 180.0, 85.0));
        Assertions.assertThrows(IllegalArgumentException.class, () -> tileJSON.withBounds(-180.0, 85.0, 180.0, -85.0));
        Assertions.assertThrows(IllegalArgumentException.class, () -> tileJSON.withBounds(-181.0, -85.0, 180.0, 85.0));
        Assertions.assertThrows(IllegalArgumentException.class, () -> tileJSON.withBounds(-180.0, -91.0, 180.0, 85.0));
        Assertions.assertThrows(IllegalArgumentException.class, () -> tileJSON.withBounds(-180.0, -85.0, 181.0, 85.0));
        Assertions.assertThrows(IllegalArgumentException.class, () -> tileJSON.withBounds(-180.0, -85.0, 180.0, 91.0));
    }

    @Test
    void testCenterValidation() {
        VectorLayer layer = VectorLayer.of((String)"test", Map.of("name", "string"));
        TileJSON tileJSON = TileJSON.of((String)"3.0.0", List.of("https://example.com/{z}/{x}/{y}.pbf"), List.of(layer));
        Assertions.assertThrows(IllegalArgumentException.class, () -> tileJSON.withCenter(-181.0, 0.0, null));
        Assertions.assertThrows(IllegalArgumentException.class, () -> tileJSON.withCenter(181.0, 0.0, null));
        Assertions.assertThrows(IllegalArgumentException.class, () -> tileJSON.withCenter(0.0, -91.0, null));
        Assertions.assertThrows(IllegalArgumentException.class, () -> tileJSON.withCenter(0.0, 91.0, null));
        Assertions.assertThrows(IllegalArgumentException.class, () -> tileJSON.withCenter(0.0, 0.0, Double.valueOf(-1.0)));
        Assertions.assertThrows(IllegalArgumentException.class, () -> tileJSON.withCenter(0.0, 0.0, Double.valueOf(31.0)));
        Assertions.assertDoesNotThrow(() -> tileJSON.withCenter(-180.0, -90.0, null));
        Assertions.assertDoesNotThrow(() -> tileJSON.withCenter(180.0, 90.0, null));
        Assertions.assertDoesNotThrow(() -> tileJSON.withCenter(0.0, 0.0, Double.valueOf(0.0)));
        Assertions.assertDoesNotThrow(() -> tileJSON.withCenter(0.0, 0.0, Double.valueOf(30.0)));
    }

    @Test
    void testZoomValidation() {
        VectorLayer layer = VectorLayer.of((String)"test", Map.of("name", "string"));
        TileJSON tileJSON = TileJSON.of((String)"3.0.0", List.of("https://example.com/{z}/{x}/{y}.pbf"), List.of(layer));
        Assertions.assertThrows(IllegalArgumentException.class, () -> tileJSON.withZoomRange(Integer.valueOf(-1), Integer.valueOf(10)));
        Assertions.assertThrows(IllegalArgumentException.class, () -> tileJSON.withZoomRange(Integer.valueOf(0), Integer.valueOf(31)));
        Assertions.assertThrows(IllegalArgumentException.class, () -> tileJSON.withZoomRange(Integer.valueOf(10), Integer.valueOf(5)));
        Assertions.assertDoesNotThrow(() -> tileJSON.withZoomRange(Integer.valueOf(0), Integer.valueOf(0)));
        Assertions.assertDoesNotThrow(() -> tileJSON.withZoomRange(Integer.valueOf(0), Integer.valueOf(30)));
        Assertions.assertDoesNotThrow(() -> tileJSON.withZoomRange(null, Integer.valueOf(10)));
        Assertions.assertDoesNotThrow(() -> tileJSON.withZoomRange(Integer.valueOf(5), null));
    }

    @Test
    void testJSONDeserialization() throws Exception {
        String json = "{\n    \"tilejson\": \"3.0.0\",\n    \"tiles\": [\"https://example.com/{z}/{x}/{y}.pbf\"],\n    \"vector_layers\": [\n        {\n            \"id\": \"roads\",\n            \"fields\": {\n                \"name\": \"String\",\n                \"highway\": \"String\"\n            },\n            \"description\": \"Road network\",\n            \"minzoom\": 6,\n            \"maxzoom\": 18\n        }\n    ],\n    \"name\": \"Test Tileset\",\n    \"description\": \"A test tileset\",\n    \"attribution\": \"\u00a9 Test\",\n    \"bounds\": [-180, -85, 180, 85],\n    \"center\": [-74, 40.7, 10],\n    \"minzoom\": 0,\n    \"maxzoom\": 18,\n    \"version\": \"1.0.0\",\n    \"unknown_property\": \"should be ignored\"\n}\n";
        TileJSON tileJSON = (TileJSON)this.objectMapper.readValue(json, TileJSON.class);
        Assertions.assertEquals((Object)"3.0.0", (Object)tileJSON.tilejson());
        Assertions.assertEquals((Object)"Test Tileset", (Object)tileJSON.name());
        Assertions.assertEquals((Object)"A test tileset", (Object)tileJSON.description());
        Assertions.assertEquals((Object)"\u00a9 Test", (Object)tileJSON.attribution());
        Assertions.assertEquals((Object)"1.0.0", (Object)tileJSON.version());
        Assertions.assertEquals((int)1, (int)tileJSON.tiles().size());
        Assertions.assertEquals((Object)"https://example.com/{z}/{x}/{y}.pbf", tileJSON.tiles().get(0));
        Assertions.assertEquals((int)4, (int)tileJSON.bounds().size());
        Assertions.assertEquals((double)-180.0, (Double)((Double)tileJSON.bounds().get(0)));
        Assertions.assertEquals((int)3, (int)tileJSON.center().size());
        Assertions.assertEquals((double)-74.0, (Double)((Double)tileJSON.center().get(0)));
        Assertions.assertEquals((double)40.7, (Double)((Double)tileJSON.center().get(1)));
        Assertions.assertEquals((double)10.0, (Double)((Double)tileJSON.center().get(2)));
        Assertions.assertEquals((Integer)0, (Integer)tileJSON.minzoom());
        Assertions.assertEquals((Integer)18, (Integer)tileJSON.maxzoom());
        Assertions.assertEquals((int)1, (int)tileJSON.vectorLayers().size());
        VectorLayer layer = (VectorLayer)tileJSON.vectorLayers().get(0);
        Assertions.assertEquals((Object)"roads", (Object)layer.id());
        Assertions.assertEquals((Object)"Road network", (Object)layer.description());
        Assertions.assertEquals((Integer)6, (Integer)layer.minZoom());
        Assertions.assertEquals((Integer)18, (Integer)layer.maxZoom());
        Assertions.assertEquals((Object)"String", layer.fields().get("name"));
        Assertions.assertEquals((Object)"String", layer.fields().get("highway"));
    }

    @Test
    void testBuilderMethods() {
        VectorLayer layer = VectorLayer.of((String)"test", Map.of("name", "string"));
        TileJSON original = TileJSON.of((String)"3.0.0", List.of("https://example.com/{z}/{x}/{y}.pbf"), List.of(layer));
        TileJSON modified = original.withName("New Name").withDescription("New Description").withAttribution("New Attribution").withVersion("2.0.0").withBounds(-90.0, -45.0, 90.0, 45.0).withCenter(0.0, 0.0, Double.valueOf(5.0)).withZoomRange(Integer.valueOf(2), Integer.valueOf(14));
        Assertions.assertEquals((Object)"New Name", (Object)modified.name());
        Assertions.assertEquals((Object)"New Description", (Object)modified.description());
        Assertions.assertEquals((Object)"New Attribution", (Object)modified.attribution());
        Assertions.assertEquals((Object)"2.0.0", (Object)modified.version());
        Assertions.assertEquals(List.of(Double.valueOf(-90.0), Double.valueOf(-45.0), Double.valueOf(90.0), Double.valueOf(45.0)), (Object)modified.bounds());
        Assertions.assertEquals(List.of(Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(5.0)), (Object)modified.center());
        Assertions.assertEquals((Integer)2, (Integer)modified.minzoom());
        Assertions.assertEquals((Integer)14, (Integer)modified.maxzoom());
        Assertions.assertNull((Object)original.name());
        Assertions.assertNull((Object)original.description());
        Assertions.assertNull((Object)original.attribution());
    }
}

