/*
 * Decompiled with CFR 0.152.
 */
package io.tileverse.jackson.databind.pmtiles.v3;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.tileverse.jackson.databind.pmtiles.v3.PMTilesMetadata;
import io.tileverse.jackson.databind.tilejson.v3.TilesetType;
import io.tileverse.jackson.databind.tilejson.v3.VectorLayer;
import io.tileverse.pmtiles.PMTilesReader;
import io.tileverse.pmtiles.PMTilesTestData;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class PMTilesMetadataTest {
    private final ObjectMapper objectMapper = new ObjectMapper();
    @TempDir
    static Path tmpFolder;

    PMTilesMetadataTest() {
    }

    @Test
    void testSimpleMetadataDeserialization() throws Exception {
        String json = "{\n    \"name\": \"Test Tileset\",\n    \"description\": \"A test tileset for unit testing\",\n    \"version\": \"1.0.0\",\n    \"attribution\": \"\u00a9 Test Contributors\",\n    \"type\": \"baselayer\"\n}\n";
        PMTilesMetadata metadata = (PMTilesMetadata)this.objectMapper.readValue(json, PMTilesMetadata.class);
        Assertions.assertEquals((Object)"Test Tileset", (Object)metadata.name());
        Assertions.assertEquals((Object)"A test tileset for unit testing", (Object)metadata.description());
        Assertions.assertEquals((Object)"1.0.0", (Object)metadata.version());
        Assertions.assertEquals((Object)"\u00a9 Test Contributors", (Object)metadata.attribution());
        Assertions.assertEquals((Object)TilesetType.BASELAYER, (Object)metadata.type());
        Assertions.assertNull((Object)metadata.vectorLayers());
        Assertions.assertNull((Object)metadata.extras());
    }

    @Test
    void testVectorTilesetMetadata() throws Exception {
        String json = "{\n    \"name\": \"Vector Tileset\",\n    \"description\": \"A vector tileset with layers\",\n    \"version\": \"2.0.0\",\n    \"attribution\": \"\u00a9 OpenStreetMap contributors\",\n    \"type\": \"overlay\",\n    \"vector_layers\": [\n        {\n            \"id\": \"buildings\",\n            \"description\": \"Building footprints\",\n            \"minzoom\": 10,\n            \"maxzoom\": 18,\n            \"fields\": {\n                \"height\": \"Number\",\n                \"name\": \"String\",\n                \"type\": \"String\"\n            }\n        },\n        {\n            \"id\": \"roads\",\n            \"description\": \"Road network\",\n            \"minzoom\": 0,\n            \"maxzoom\": 18,\n            \"fields\": {\n                \"name\": \"String\",\n                \"highway\": \"String\",\n                \"oneway\": \"Boolean\"\n            }\n        }\n    ]\n}\n";
        PMTilesMetadata metadata = (PMTilesMetadata)this.objectMapper.readValue(json, PMTilesMetadata.class);
        Assertions.assertEquals((Object)"Vector Tileset", (Object)metadata.name());
        Assertions.assertEquals((Object)"A vector tileset with layers", (Object)metadata.description());
        Assertions.assertEquals((Object)"2.0.0", (Object)metadata.version());
        Assertions.assertEquals((Object)"\u00a9 OpenStreetMap contributors", (Object)metadata.attribution());
        Assertions.assertEquals((Object)TilesetType.OVERLAY, (Object)metadata.type());
        Assertions.assertNotNull((Object)metadata.vectorLayers());
        Assertions.assertEquals((int)2, (int)metadata.vectorLayers().size());
        VectorLayer buildings = (VectorLayer)metadata.vectorLayers().get(0);
        Assertions.assertEquals((Object)"buildings", (Object)buildings.id());
        Assertions.assertEquals((Object)"Building footprints", (Object)buildings.description());
        Assertions.assertEquals((Integer)10, (Integer)buildings.minZoom());
        Assertions.assertEquals((Integer)18, (Integer)buildings.maxZoom());
        Assertions.assertNotNull((Object)buildings.fields());
        Assertions.assertEquals((Object)"Number", buildings.fields().get("height"));
        Assertions.assertEquals((Object)"String", buildings.fields().get("name"));
        Assertions.assertEquals((Object)"String", buildings.fields().get("type"));
        VectorLayer roads = (VectorLayer)metadata.vectorLayers().get(1);
        Assertions.assertEquals((Object)"roads", (Object)roads.id());
        Assertions.assertEquals((Object)"Road network", (Object)roads.description());
        Assertions.assertEquals((Integer)0, (Integer)roads.minZoom());
        Assertions.assertEquals((Integer)18, (Integer)roads.maxZoom());
        Assertions.assertNotNull((Object)roads.fields());
        Assertions.assertEquals((Object)"String", roads.fields().get("name"));
        Assertions.assertEquals((Object)"String", roads.fields().get("highway"));
        Assertions.assertEquals((Object)"Boolean", roads.fields().get("oneway"));
    }

    @Test
    void testMetadataWithUnknownProperties() throws Exception {
        String json = "{\n    \"name\": \"Test Tileset\",\n    \"description\": \"Test description\",\n    \"type\": \"baselayer\",\n    \"unknown_property\": \"should be ignored\",\n    \"custom_field\": {\n        \"nested\": \"value\"\n    },\n    \"bounds\": [-180, -85, 180, 85],\n    \"center\": [0, 0, 5],\n    \"minzoom\": 0,\n    \"maxzoom\": 14\n}\n";
        PMTilesMetadata metadata = (PMTilesMetadata)this.objectMapper.readValue(json, PMTilesMetadata.class);
        Assertions.assertEquals((Object)"Test Tileset", (Object)metadata.name());
        Assertions.assertEquals((Object)"Test description", (Object)metadata.description());
        Assertions.assertEquals((Object)TilesetType.BASELAYER, (Object)metadata.type());
    }

    @Test
    void testMetadataSerialization() throws Exception {
        PMTilesMetadata original = PMTilesMetadata.of((String)"Test Tileset", (String)"Test description", (String)"\u00a9 Test").withVersion("1.0.0").withType(TilesetType.BASELAYER).withVectorLayers(List.of(VectorLayer.of((String)"test", Map.of("name", "String"), (String)"Test layer").withZoomRange(Integer.valueOf(0), Integer.valueOf(14))));
        String json = this.objectMapper.writeValueAsString((Object)original);
        Assertions.assertNotNull((Object)json);
        Assertions.assertTrue((boolean)json.contains("Test Tileset"));
        Assertions.assertTrue((boolean)json.contains("baselayer"));
        PMTilesMetadata deserialized = (PMTilesMetadata)this.objectMapper.readValue(json, PMTilesMetadata.class);
        Assertions.assertEquals((Object)original.name(), (Object)deserialized.name());
        Assertions.assertEquals((Object)original.description(), (Object)deserialized.description());
        Assertions.assertEquals((Object)original.version(), (Object)deserialized.version());
        Assertions.assertEquals((Object)original.attribution(), (Object)deserialized.attribution());
        Assertions.assertEquals((Object)original.type(), (Object)deserialized.type());
        Assertions.assertNotNull((Object)deserialized.vectorLayers());
        Assertions.assertEquals((int)1, (int)deserialized.vectorLayers().size());
        VectorLayer layer = (VectorLayer)deserialized.vectorLayers().get(0);
        Assertions.assertEquals((Object)"test", (Object)layer.id());
        Assertions.assertEquals((Object)"Test layer", (Object)layer.description());
    }

    @Test
    void testTilesetTypeEnum() throws Exception {
        String baselayerJson = "{\n    \"name\": \"Base Map\",\n    \"type\": \"baselayer\"\n}\n";
        PMTilesMetadata baselayerMetadata = (PMTilesMetadata)this.objectMapper.readValue(baselayerJson, PMTilesMetadata.class);
        Assertions.assertEquals((Object)TilesetType.BASELAYER, (Object)baselayerMetadata.type());
        String overlayJson = "{\n    \"name\": \"Overlay Map\",\n    \"type\": \"overlay\"\n}\n";
        PMTilesMetadata overlayMetadata = (PMTilesMetadata)this.objectMapper.readValue(overlayJson, PMTilesMetadata.class);
        Assertions.assertEquals((Object)TilesetType.OVERLAY, (Object)overlayMetadata.type());
        String unknownJson = "{\n    \"name\": \"Unknown Map\",\n    \"type\": \"unknown_type\"\n}\n";
        PMTilesMetadata unknownMetadata = (PMTilesMetadata)this.objectMapper.readValue(unknownJson, PMTilesMetadata.class);
        Assertions.assertNull((Object)unknownMetadata.type());
        PMTilesMetadata original = PMTilesMetadata.of((String)"Test").withType(TilesetType.BASELAYER);
        String json = this.objectMapper.writeValueAsString((Object)original);
        Assertions.assertTrue((boolean)json.contains("\"type\":\"baselayer\""));
        PMTilesMetadata deserialized = (PMTilesMetadata)this.objectMapper.readValue(json, PMTilesMetadata.class);
        Assertions.assertEquals((Object)TilesetType.BASELAYER, (Object)deserialized.type());
    }

    @Test
    void testBuilderMethods() {
        PMTilesMetadata metadata = PMTilesMetadata.of((String)"Original Name").withDescription("Test description").withVersion("1.0").withAttribution("\u00a9 Test").withType(TilesetType.OVERLAY);
        Assertions.assertEquals((Object)"Original Name", (Object)metadata.name());
        Assertions.assertEquals((Object)"Test description", (Object)metadata.description());
        Assertions.assertEquals((Object)"1.0", (Object)metadata.version());
        Assertions.assertEquals((Object)"\u00a9 Test", (Object)metadata.attribution());
        Assertions.assertEquals((Object)TilesetType.OVERLAY, (Object)metadata.type());
    }

    @Test
    void testVectorLayerBuilderMethods() {
        VectorLayer layer = VectorLayer.of((String)"test", Map.of("name", "String", "count", "Number")).withDescription("Test layer").withZoomRange(Integer.valueOf(0), Integer.valueOf(10));
        Assertions.assertEquals((Object)"test", (Object)layer.id());
        Assertions.assertEquals((Object)"Test layer", (Object)layer.description());
        Assertions.assertEquals((Integer)0, (Integer)layer.minZoom());
        Assertions.assertEquals((Integer)10, (Integer)layer.maxZoom());
        Assertions.assertNotNull((Object)layer.fields());
        Assertions.assertEquals((Object)"String", layer.fields().get("name"));
        Assertions.assertEquals((Object)"Number", layer.fields().get("count"));
    }

    @Test
    void testEmptyMetadata() {
        PMTilesMetadata empty = PMTilesMetadata.of(null);
        Assertions.assertNull((Object)empty.name());
        Assertions.assertNull((Object)empty.description());
        Assertions.assertNull((Object)empty.version());
        Assertions.assertNull((Object)empty.attribution());
        Assertions.assertNull((Object)empty.vectorLayers());
        Assertions.assertNull((Object)empty.type());
        Assertions.assertNull((Object)empty.extras());
    }

    @Test
    void testAndorraMetadata() throws Exception {
        PMTilesReader pmtilesReader = new PMTilesReader(PMTilesTestData.andorra(tmpFolder));
        PMTilesMetadata metadata = pmtilesReader.getMetadata();
        Assertions.assertNotNull((Object)metadata);
        Assertions.assertEquals((Object)"Shortbread", (Object)metadata.name());
        Assertions.assertEquals((Object)"A basic, lean, general-purpose vector tile schema for OpenStreetMap data. See https://shortbread.geofabrik.de/", (Object)metadata.description());
        Assertions.assertEquals((Object)"<a href=\"https://www.openstreetmap.org/copyright\" target=\"_blank\">&copy; OpenStreetMap contributors</a>", (Object)metadata.attribution());
        Assertions.assertEquals((Object)TilesetType.BASELAYER, (Object)metadata.type());
        Assertions.assertNotNull((Object)metadata.vectorLayers());
        Assertions.assertEquals((int)21, (int)metadata.vectorLayers().size());
        Map layerMap = metadata.vectorLayers().stream().collect(Collectors.toMap(VectorLayer::id, Function.identity()));
        Assertions.assertTrue((boolean)layerMap.containsKey("addresses"), (String)"Should have addresses layer");
        Assertions.assertTrue((boolean)layerMap.containsKey("boundaries"), (String)"Should have boundaries layer");
        Assertions.assertTrue((boolean)layerMap.containsKey("buildings"), (String)"Should have buildings layer");
        Assertions.assertTrue((boolean)layerMap.containsKey("streets"), (String)"Should have streets layer");
        VectorLayer addresses = (VectorLayer)layerMap.get("addresses");
        Assertions.assertNotNull((Object)addresses, (String)"addresses layer should exist");
        Assertions.assertEquals((Integer)14, (Integer)addresses.minZoom());
        Assertions.assertEquals((Integer)14, (Integer)addresses.maxZoom());
        Assertions.assertNotNull((Object)addresses.fields());
        Assertions.assertEquals((Object)"String", addresses.fields().get("housename"));
        Assertions.assertEquals((Object)"String", addresses.fields().get("housenumber"));
    }
}

